/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.aspectj.debugger.gui.AJStackFrameFormatter;
import org.aspectj.debugger.gui.AJThreadFormatter;
import org.aspectj.debugger.gui.ComponentRepository;

class StackTableModel
extends DefaultTableModel {
    private final String[] colNames = new String[]{"#", "Location"};
    private final Class[] colClasses = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = StackTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$org$aspectj$debugger$gui$AJStackFrameFormatter$MethodAndSource == null ? (class$org$aspectj$debugger$gui$AJStackFrameFormatter$MethodAndSource = StackTableModel.class$("org.aspectj.debugger.gui.AJStackFrameFormatter$MethodAndSource")) : class$org$aspectj$debugger$gui$AJStackFrameFormatter$MethodAndSource};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$aspectj$debugger$gui$AJStackFrameFormatter$MethodAndSource;

    public StackTableModel(ThreadReference threadRef) {
        if (threadRef != null) {
            this.colNames[1] = this.colNames[1] + ": " + AJThreadFormatter.format(threadRef);
        }
        this.setColumnIdentifiers(this.colNames);
        if (threadRef != null) {
            try {
                List stack = ComponentRepository.getAJDebugger().frames(threadRef);
                int i = 0;
                while (i < stack.size()) {
                    Object[] os = new Object[]{new Integer(i + 1), AJStackFrameFormatter.format((StackFrame)stack.get(i))};
                    this.addRow(os);
                    ++i;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
        }
    }

    public Class getColumnClass(int col) {
        return this.colClasses[col];
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    String format(StackFrame frame) {
        if (frame == null) {
            return "<BAD FRAME>";
        }
        Location loc = frame.location();
        Method meth = loc.method();
        String str = meth.declaringType().name() + "." + meth.name() + " (";
        if (meth instanceof Method && meth.isNative()) {
            str = str + "native method";
        } else if (loc.lineNumber() > -1) {
            try {
                str = str + loc.sourceName();
            }
            catch (AbsentInformationException e) {
                str = str + "<unknown>";
            }
            str = str + ":";
            str = str + loc.lineNumber();
        } else {
            str = str + "<unknown>";
        }
        str = str + ")";
        return str;
    }

    public String toString() {
        return "Stack Table Pane";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

