/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class UtilFrame
extends JFrame
implements ItemListener {
    JTextPane textPane;
    JCheckBox debugBox;
    boolean debug = true;
    DefaultStyledDocument dsd;
    SimpleAttributeSet[] attrs = null;
    int count = 0;
    static final int MSG = -1;
    static final int ERROR = 0;
    static final int DEBUG = 1;
    static final int ASPECT = 2;
    static final int EXCEPTION = 3;
    Color[] colors = new Color[]{Color.red, Color.blue, Color.green.darker().darker(), Color.darkGray};
    int[] colorsConstants = new int[]{0, 1, 2, 3};

    public UtilFrame() {
        super("Utilily Frame");
        this.dsd = new DefaultStyledDocument();
        this.textPane = new JTextPane(this.dsd);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        scrollPane.setPreferredSize(new Dimension(500, 500));
        this.debugBox = new JCheckBox("Debug?");
        this.debugBox.setSelected(true);
        this.debugBox.addItemListener(this);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add((Component)this.debugBox, "North");
        this.setContentPane(contentPane);
        this.initAttrs();
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.debugBox) {
            this.debug = !this.debug;
        }
    }

    protected void initAttrs() {
        this.attrs = new SimpleAttributeSet[this.colors.length];
        int i = 0;
        while (i < this.colors.length) {
            this.attrs[i] = this.getAttr(this.colors[i]);
            ++i;
        }
    }

    protected SimpleAttributeSet getAttr(Color c) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setForeground(attr, c);
        StyleConstants.setFontSize(attr, 10);
        return attr;
    }

    public void error(Object o) {
        this.msg("ERROR", o, this.colors[0]);
    }

    public void debug(Object o) {
        this.msg("DEBUG", o, this.colors[1]);
    }

    public void aspect(Object o) {
        this.msg("ASPECT", o, this.colors[2]);
    }

    public void ex(Object o) {
        if (o instanceof Exception) {
            this.msg("EXCEPTION", ((Exception)o).getMessage(), this.colors[3]);
        } else {
            this.msg("EXCEPTION", o, this.colors[3]);
        }
    }

    public void msg(Object o, Color c) {
        this.msg("MSG", o, c);
    }

    public void msg(String m, Object o, Color c) {
        String s = "NULL";
        if (o != null) {
            s = o.toString();
        }
        this.outln("<<" + m + ">> " + s, c);
    }

    private void outln(String s, Color c) {
        this.outln(s, this.getAttr(c));
    }

    private void outln(String s, int i) {
        this.outln(s, this.attrs[i]);
    }

    private void outln(String s, SimpleAttributeSet attr) {
        if (!this.debug) {
            return;
        }
        try {
            this.dsd.insertString(this.dsd.getLength(), s + "\n", attr);
            this.count += s.length() + 1;
            this.textPane.setCaretPosition(this.count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

