/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.aspectj.debugger.base.DebuggerListener;
import org.aspectj.debugger.gui.AJPanel;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.WatchpointTree;
import org.aspectj.debugger.gui.WatchpointTreeNode;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.RequestEvent;
import org.aspectj.debugger.request.WatchRequest;

public class WatchpointTreePane
extends AJPanel
implements DebuggerListener {
    private WatchpointTree tree = null;

    public WatchpointTreePane(Frame frame, GUIDebugger guid) {
        super(guid);
        this.debugger().addDebuggerListener(this);
        this.setLayout(new BorderLayout());
        this.tree = new WatchpointTree(frame);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void requestSetEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof WatchRequest)) {
            return;
        }
        this.add((WatchRequest)r, true);
    }

    public void requestClearEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof WatchRequest)) {
            return;
        }
        this.remove((WatchRequest)r);
    }

    public void requestDeferredEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof WatchRequest)) {
            return;
        }
        this.add((WatchRequest)r, false);
    }

    public void requestFailedEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof WatchRequest)) {
            return;
        }
        this.remove((WatchRequest)r);
    }

    private void remove(WatchRequest wr) {
    }

    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
    }

    private void add(WatchRequest wr, boolean isVerified) {
        WatchpointTreeNode node = null;
        DefaultMutableTreeNode root = this.getRoot();
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            node = (WatchpointTreeNode)enumeration.nextElement();
            if (!node.toString().equals(wr + "")) continue;
            return;
        }
        node = new WatchpointTreeNode(wr);
        root.add(node);
        this.tree.expandRow(0);
    }

    public static String d() {
        return "Watchpoint Tree Pane";
    }

    public String toString() {
        return WatchpointTreePane.d();
    }
}

