/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.ide;

import java.io.File;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.ide.SourceShower;
import org.aspectj.debugger.request.BreakpointRequestAction;

public abstract class FullPathSourceShower
implements SourceShower {
    public static final SourceShower proto = new FullPathSourceShower(){

        public void showSourceForFullPath(String fullPath) {
            System.out.println("fullPath:" + fullPath);
        }

        public void showLineForCurrentModel(int line, boolean isAtBreakpoint) {
            System.out.println("line:" + line + " isAtBreakpoint:" + isAtBreakpoint);
        }

        public String getSourceName() {
            return "who knows?";
        }

        public void requestSet(String filename, int line, BreakpointRequestAction ba) {
        }

        public void requestClear(String filename, int line, BreakpointRequestAction ba) {
        }

        public void requestDeferred(String filename, int line, BreakpointRequestAction ba) {
        }
    };

    public abstract void showSourceForFullPath(String var1);

    public abstract void showLineForCurrentModel(int var1, boolean var2);

    public abstract String getSourceName();

    public boolean showSource(String relativePath) {
        String fullPath = ComponentRepository.getAJDebugger().getFullSourcePath(relativePath);
        File file = new File(fullPath);
        if (file == null || file.isDirectory() || !file.exists()) {
            return false;
        }
        this.showSourceForFullPath(fullPath);
        return true;
    }

    public void requestSet(String filename, int line, BreakpointRequestAction ba) {
    }

    public void requestClear(String filename, int line, BreakpointRequestAction ba) {
    }

    public void requestDeferred(String filename, int line, BreakpointRequestAction ba) {
    }
}

