/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.ide;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.DebuggerListener;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.ide.IDEComponentDirector;
import org.aspectj.debugger.ide.IDEInterface;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.ClassBreakpointRequestAction;
import org.aspectj.debugger.request.ClassLineBreakpointRequestAction;
import org.aspectj.debugger.request.ClassMethodBreakpointRequestAction;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.RequestEvent;
import org.aspectj.debugger.request.SourceLineBreakpointRequestAction;
import org.aspectj.tools.ide.SourceLine;

public abstract class IDEInterfaceHelper
implements IDEInterface {
    public static IDEInterfaceHelper singletonInstance = null;
    protected ComponentDirector director;
    private boolean settingFromIDE = false;
    private boolean settingFromDebugger = false;
    public static final Log log = new Log();

    public abstract String getClasspath();

    public abstract String getVMParameters();

    public abstract String getClassNameToRun();

    public abstract String findClassName();

    public abstract String findFileName();

    public abstract List getInitialBreakpoints();

    protected abstract void markLine(String var1, List var2);

    protected abstract void markLineWithClass(String var1, int var2);

    protected abstract void markLine(String var1, int var2);

    protected abstract void unmarkLine(String var1, int var2);

    public void toggle(String sourceName, int lineNumber) {
    }

    protected abstract void handle(Throwable var1);

    public void toggleBreakpoint(String sourcePath, int lineNumber) {
        this.ajdb().toggleBreakpoint(sourcePath, lineNumber);
    }

    public void exit() {
    }

    public void init(IDEComponentDirector director) {
    }

    public void settingBreakpointsFromIDE() {
        this.downSettingFromDebugger();
    }

    public void doneSettingBreakpointsFromIDE() {
        this.upSettingFromDebugger();
    }

    public void setComponentDirector(ComponentDirector director) {
        this.director = director;
        this.init(director);
    }

    public ComponentDirector getComponentDirector() {
        return this.director;
    }

    public AJDebugger ajdb() {
        GUIDebugger guid = this.guid();
        return guid != null ? guid.getDebugger() : null;
    }

    public GUIDebugger guid() {
        return this.director != null ? this.director.getGUIDebugger() : null;
    }

    public void init(ComponentDirector _director) {
        this.director = _director;
        this.director.getDebugger().addDebuggerListener(new RequestListener());
    }

    protected boolean downSettingFromIDE() {
        return this.settingFromIDE ? false : (this.settingFromIDE = true);
    }

    protected void upSettingFromIDE() {
        this.settingFromIDE = false;
    }

    protected boolean downSettingFromDebugger() {
        return this.settingFromDebugger ? false : (this.settingFromDebugger = true);
    }

    protected void upSettingFromDebugger() {
        this.settingFromDebugger = false;
    }

    protected final boolean breakpoint(IDEInterface.AbstractSourceLineBreakpoint breakpoint, boolean stopping) {
        return this.breakpoint(breakpoint.getSourceName(), breakpoint.getLine(), stopping);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean breakpoint(String sourceName, int line, boolean stopping) {
        try {
            try {
                if (!this.downSettingFromDebugger()) {
                    boolean bl = false;
                    Object var6_6 = null;
                    this.upSettingFromDebugger();
                    return bl;
                }
                if (stopping) {
                    IDEInterfaceHelper.debug("stopping " + sourceName + ":" + line);
                    this.director.getDebugger().stopOnCommand(sourceName, line);
                } else {
                    IDEInterfaceHelper.debug("clearing " + sourceName + ":" + line);
                    this.director.getDebugger().clearOnCommand(sourceName, line);
                }
            }
            catch (Exception t) {
                this.handle(t);
                Object var6_8 = null;
                this.upSettingFromDebugger();
                return true;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.upSettingFromDebugger();
            throw throwable;
        }
        Object var6_7 = null;
        this.upSettingFromDebugger();
        return true;
    }

    private void unmarkLine(RequestEvent re) {
        Request request = re.getRequest();
        IDEInterfaceHelper.debug("request:" + request);
        if (request == null) {
            return;
        }
        if (request instanceof BreakpointRequestAction) {
            BreakpointRequestAction bra = (BreakpointRequestAction)request;
            String sourceName = bra.getRealSourceName();
            int line = bra.getRealLine();
            if (this.ajdb().isAjcFile(sourceName)) {
                SourceLine sourceLine = this.ajdb().getSourceLine(bra);
                sourceName = this.ajdb().getFullSourcePath(bra.getRealSourceName());
                IDEInterfaceHelper.debug("*** unmarking.real:" + sourceName + ":" + line);
                IDEInterfaceHelper.debug("*** but sourceLine:" + sourceLine);
                IDEInterfaceHelper.debug("*** bra:" + bra + ",bra.class:" + bra.getClass());
                this.downSettingFromIDE();
                this.unmarkLine(sourceLine.filename, sourceLine.line);
                this.upSettingFromIDE();
                return;
            }
        }
    }

    public final void atomicMarkLine(String sourceFilename, int lineNumber) {
        this.downSettingFromIDE();
        this.markLine(sourceFilename, lineNumber);
        this.upSettingFromIDE();
    }

    private final void markLine(RequestEvent re) {
        BreakpointRequestAction ra;
        int line;
        String sourceName;
        BreakpointRequestAction bra;
        Request request = re.getRequest();
        IDEInterfaceHelper.debug("request:" + request);
        if (request == null) {
            return;
        }
        if (request instanceof BreakpointRequestAction) {
            bra = (BreakpointRequestAction)request;
            sourceName = bra.getRealSourceName();
            IDEInterfaceHelper.debug("sourceName:" + sourceName);
            line = bra.getRealLine();
            if (this.ajdb().isAjcFile(sourceName)) {
                SourceLine sourceLine = this.ajdb().getSourceLine(bra);
                sourceName = this.ajdb().getFullSourcePath(bra.getRealSourceName());
                IDEInterfaceHelper.debug("*** marking sourceLine:" + sourceLine + " " + sourceName + ":" + line + "," + bra.getLine() + ",class:" + bra.getClass().getName());
                this.downSettingFromIDE();
                this.markLine(sourceLine.filename, sourceLine.line);
                this.upSettingFromIDE();
                return;
            }
        }
        if (request instanceof SourceLineBreakpointRequestAction) {
            ra = (SourceLineBreakpointRequestAction)request;
            SourceLine sl = this.ajdb().getSourceLine(ra);
            this.downSettingFromIDE();
            this.markLine(sl.filename, sl.line);
            this.upSettingFromIDE();
        } else if (request instanceof ClassLineBreakpointRequestAction) {
            ra = (ClassLineBreakpointRequestAction)request;
            String className = ((ClassBreakpointRequestAction)ra).getClassName();
            line = ((ClassLineBreakpointRequestAction)ra).getLine();
            this.downSettingFromIDE();
            this.markLineWithClass(className, line);
            this.upSettingFromIDE();
        } else if (request instanceof ClassMethodBreakpointRequestAction) {
            ra = (ClassMethodBreakpointRequestAction)request;
            String methodProto = ((ClassMethodBreakpointRequestAction)ra).getMethodProto();
            List argNames = ((ClassMethodBreakpointRequestAction)ra).getArgumentTypeNames();
            String className = ((ClassBreakpointRequestAction)ra).getClassName();
            this.downSettingFromIDE();
            this.markLine(className, argNames);
            this.upSettingFromIDE();
        } else if (request instanceof BreakpointRequestAction) {
            ra = (BreakpointRequestAction)request;
            SourceLine sl = this.ajdb().getSourceLine(ra);
            this.downSettingFromIDE();
            this.markLine(sl.filename, sl.line);
            this.upSettingFromIDE();
        }
        sourceName = "asdf";
        line = -123;
        if (request instanceof BreakpointRequestAction) {
            bra = (BreakpointRequestAction)request;
            sourceName = bra.getSourceName();
            line = bra.getLine();
        }
        IDEInterfaceHelper.debug("sourceName:" + sourceName + " line:" + line);
    }

    public static void debug(Object msg) {
        log.println(msg);
    }

    public static class Log {
        private JTextArea area = new JTextArea(30, 100);
        private boolean ok = false;

        public Log() {
            JFrame frame = new JFrame("IDE Logger");
            this.ok = System.getProperty("user.name").equals("palm") && System.getProperty("no.logger") != null;
            if (this.ok) {
                frame.getContentPane().add(new JScrollPane(this.area));
                frame.pack();
                ((Component)frame).setVisible(true);
            }
        }

        public void up() {
            if (!this.ok) {
                return;
            }
            this.println("up");
            this.area.setForeground(Color.black);
        }

        public void down() {
            if (!this.ok) {
                return;
            }
            this.println("down");
            this.area.setForeground(Color.red.darker());
        }

        public void println() {
            this.println("");
        }

        public void println(Object msg) {
            if (this.ok) {
                this.area.append(msg + "\n");
            }
        }
    }

    final class RequestListener
    implements DebuggerListener {
        RequestListener() {
        }

        public void requestSetEvent(RequestEvent re) {
            IDEInterfaceHelper.debug("requestSetEvent:" + re);
            this.set(re);
        }

        public void requestClearEvent(RequestEvent re) {
            IDEInterfaceHelper.debug("requestClearEvent:" + re);
            this.clear(re);
        }

        public void requestDeferredEvent(RequestEvent re) {
            IDEInterfaceHelper.debug("requestDeferredEvent:" + re);
            this.set(re);
        }

        public void requestFailedEvent(RequestEvent re) {
            IDEInterfaceHelper.debug("requestFailedEvent:" + re);
            this.clear(re);
        }

        private void set(RequestEvent re) {
            if (!IDEInterfaceHelper.this.downSettingFromDebugger()) {
                return;
            }
            IDEInterfaceHelper.this.markLine(re);
            IDEInterfaceHelper.this.upSettingFromDebugger();
        }

        private void clear(RequestEvent re) {
            if (!IDEInterfaceHelper.this.downSettingFromDebugger()) {
                return;
            }
            IDEInterfaceHelper.this.unmarkLine(re);
            IDEInterfaceHelper.this.upSettingFromDebugger();
        }
    }
}

