/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.List;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public abstract class AbstractStepRequest
extends Request {
    public AbstractStepRequest(Debugger debugger) {
        super(debugger);
    }

    public Object go() throws NoVMException, DebuggerException {
        StepRequest request;
        EventRequestManager mgr = null;
        try {
            mgr = this.vm().eventRequestManager();
        }
        catch (NoVMException nvme) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        ThreadReference threadRef = this.dbg().getStoppedThread();
        List<StepRequest> steps = mgr.stepRequests();
        int i = 0;
        while (i < steps.size()) {
            request = steps.get(i);
            if (request.thread().equals(threadRef)) {
                mgr.deleteEventRequest(request);
            }
            ++i;
        }
        request = mgr.createStepRequest(threadRef, this.getSize(), this.getDepth());
        request.putProperty("name", this.name());
        request.addCountFilter(1);
        request.setSuspendPolicy(2);
        request.enable();
        this.dbg().addExcludesTo(request);
        this.dbg().resumeUntilZero(threadRef);
        return request;
    }

    abstract int getDepth();

    abstract int getSize();

    abstract String name();
}

