/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.UnableToSetRequestException;

public abstract class ClassBreakpointRequestAction
extends BreakpointRequestAction {
    protected String className;

    ClassBreakpointRequestAction(Debugger debugger, String className) {
        super(debugger);
        this.className = className;
    }

    EventRequest resolve(ReferenceType refType) throws MultipleLocationsException, UnableToSetRequestException {
        BreakpointRequest request = null;
        try {
            if (refType.name().equals(this.className)) {
                EventRequestManager em = this.vm().eventRequestManager();
                Location location = this.findLocation();
                if (location == null) {
                    return null;
                }
                request = this.request(location);
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return request;
    }

    public String getRealSourceName() {
        return this.ajdbg().getFullSourcePathFromAJCClass(this.getClassName());
    }

    public String getClassName() {
        return this.className;
    }

    public int getLine() {
        if (this.getLocation() != null) {
            return this.getLocation().lineNumber();
        }
        return -1;
    }

    public String getSourceName() {
        if (this.getLocation() != null) {
            try {
                return this.getLocation().sourceName();
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return "<not-available>";
    }

    abstract Location findLocation() throws NoVMException, MultipleLocationsException, UnableToSetRequestException;
}

