/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.util.Iterator;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.ClassBreakpointRequestAction;
import org.aspectj.debugger.request.UnableToSetRequestException;
import org.aspectj.tools.ide.SourceLine;
import org.aspectj.util.LineNumberTableMapper;

public abstract class ClassLineBreakpointRequestAction
extends ClassBreakpointRequestAction {
    private int line;

    ClassLineBreakpointRequestAction(Debugger debugger, String className, int line) {
        super(debugger, className);
        System.err.println(">> breakpoint request, class: " + className + ", line: " + line);
        this.line = line;
    }

    public String getProto() {
        SourceLine sl = this.ajdbg().getSourceLineFromClass(this.getClassName(), this.getLine());
        int newLine = this.line;
        if (sl == null) {
            System.err.println("sl is null for " + this.getClassName() + ":" + this.line);
        } else {
            newLine = sl.line;
        }
        return this.getClassName() + ":" + newLine;
    }

    public String getErrorMessage() {
        return "No code at line " + this.line + " in " + this.getClassName();
    }

    Location findLocation() throws NoVMException, MultipleLocationsException, UnableToSetRequestException {
        block5: {
            System.err.println(">>> resolving class-line breakpoint, class: " + this.className);
            try {
                Iterator<ReferenceType> it = this.vm().classesByName(this.className).iterator();
                ReferenceType refType = null;
                while (it.hasNext()) {
                    refType = it.next();
                    System.err.println(">> refType: " + refType.sourceName());
                }
                if (refType != null) {
                    String attrib = refType.sourceName();
                    String pkg = this.className.substring(0, this.className.lastIndexOf(46)).replace('.', '/');
                    String srcPath = AJDebugger.INSTANCE.getSourcePath();
                    File srcRoot = new File(srcPath);
                    System.err.println(">> findMethod attrib: " + attrib + ", pkg: " + pkg + ", src: " + srcPath);
                    LineNumberTableMapper mapper = new LineNumberTableMapper(attrib, pkg, srcRoot);
                    System.err.println(">>> mapper: " + mapper.toString());
                    System.err.println(">> mapped: " + mapper.getCorrespondingFile(this.line).getPath() + " : " + mapper.getCorrespondingLineNumber(this.line));
                    Iterator<Location> linesIter = refType.allLineLocations().iterator();
                    while (linesIter.hasNext()) {
                        Location loc = linesIter.next();
                        if (loc.lineNumber() != mapper.getCorrespondingLineNumber(this.line)) continue;
                        return loc;
                    }
                    break block5;
                }
                throw new AbsentInformationException();
            }
            catch (AbsentInformationException aie) {
                System.err.println("> ERROR: in class line breakpoint request");
                aie.printStackTrace();
            }
        }
        return null;
    }

    public int getLine() {
        return this.line;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ClassLineBreakpointRequestAction)) {
            return super.equals(other);
        }
        ClassLineBreakpointRequestAction ra = (ClassLineBreakpointRequestAction)other;
        return this.getClassName().equals(ra.getClassName()) && this.getLine() == ra.getLine();
    }
}

