/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Iterator;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.EventRequestWrapper;

class ClassLineBreakpointRequestWrapper
extends EventRequestWrapper {
    private String className;
    private int line;

    ClassLineBreakpointRequestWrapper(Debugger debugger, String className, int line) {
        super(debugger);
        this.className = className;
        this.line = line;
    }

    public EventRequest resolve(ReferenceType refType) {
        BreakpointRequest request = null;
        try {
            if (refType.name().equals(this.className)) {
                EventRequestManager em = this.vm().eventRequestManager();
                Location location = this.findLocation();
                if (location == null) {
                    return null;
                }
                request = em.createBreakpointRequest(location);
                request.enable();
                request.setSuspendPolicy(0);
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return request;
    }

    public String toString() {
        return "breakpoint " + this.className + ":" + this.line;
    }

    private Location findLocation() throws NoVMException {
        Location location = null;
        Iterator<ReferenceType> iter = this.vm().classesByName(this.className).iterator();
        while (iter.hasNext()) {
            ReferenceType refType = iter.next();
            if (!refType.name().equals(this.className)) continue;
            try {
                Iterator<Location> linesIter = refType.locationsOfLine(this.line).iterator();
                if (!linesIter.hasNext()) continue;
                return linesIter.next();
            }
            catch (AbsentInformationException e) {
                return null;
            }
        }
        return location;
    }
}

