/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.ClassBreakpointRequestAction;
import org.aspectj.debugger.request.UnableToSetRequestException;
import org.aspectj.tools.ide.SourceLine;

public abstract class ClassMethodBreakpointRequestAction
extends ClassBreakpointRequestAction {
    private String methodProto;

    ClassMethodBreakpointRequestAction(Debugger debugger, String className, String methodProto) {
        super(debugger, className);
        this.methodProto = methodProto;
    }

    public String getMethodProto() {
        return this.methodProto;
    }

    public String getErrorMessage() {
        return "No method " + this.getMethodName() + " in " + this.getClassName();
    }

    public String getProto() {
        return this.getClassName() + "." + this.getMethodProto();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassMethodBreakpointRequestAction)) {
            return super.equals(o);
        }
        ClassMethodBreakpointRequestAction ra = (ClassMethodBreakpointRequestAction)o;
        return ra.getClassName().equals(this.getClassName()) && ra.getMethodName().equals(this.getMethodName()) && ra.argumentTypeNames().equals(this.argumentTypeNames());
    }

    /*
     * Unable to fully structure code
     */
    Location findLocation() throws NoVMException, MultipleLocationsException, UnableToSetRequestException {
        location = null;
        iter = this.vm().classesByName(this.className).iterator();
        while (iter.hasNext()) {
            refType = iter.next();
            if (!refType.name().equals(this.className)) continue;
            methods = refType.methodsByName(this.getMethodName());
            methodsIter = methods.iterator();
            argumentTypeNames = this.argumentTypeNames();
            justName = true;
            i = 0;
            while (i < this.methodProto.length()) {
                if (!Character.isJavaIdentifierPart(this.methodProto.charAt(i))) {
                    justName = false;
                    break;
                }
                ++i;
            }
            if (!justName) ** GOTO lbl28
            if (methods.size() == 1) {
                location = methods.get(0).location();
                return location;
            }
            if (methods.size() == 0) {
                throw new UnableToSetRequestException(this);
            }
            throw new MultipleLocationsException(this.className + "." + this.methodProto, methods);
lbl-1000:
            // 1 sources

            {
                method = methodsIter.next();
                if (!this.argumentTypeNames().equals(method.argumentTypeNames())) continue;
                location = method.location();
                return location;
lbl28:
                // 2 sources

                ** while (methodsIter.hasNext())
            }
lbl29:
            // 1 sources

            throw new UnableToSetRequestException(this);
        }
        return location;
    }

    String getMethodName() {
        int iparen = this.methodProto.indexOf("(");
        if (iparen != -1) {
            return this.methodProto.substring(0, iparen);
        }
        return this.methodProto;
    }

    public List getArgumentTypeNames() {
        return this.argumentTypeNames();
    }

    List argumentTypeNames() {
        ArrayList<String> argNames = new ArrayList<String>();
        int iparen = this.methodProto.indexOf("(");
        if (iparen == -1) {
            return argNames;
        }
        StringTokenizer tok = new StringTokenizer(this.methodProto, "(,;:)");
        try {
            String meth = tok.nextToken();
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                argNames.add(token);
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return argNames;
    }

    public int getLine() {
        SourceLine sl = this.sourceLine();
        if (sl == null || sl.line < 0) {
            return super.getLine();
        }
        return sl.line;
    }

    public String getSourceName() {
        SourceLine sl = this.sourceLine();
        if (sl == null) {
            return super.getSourceName();
        }
        return sl.filename;
    }

    public SourceLine sourceLine() {
        String fullSrcPath = this.ajdbg().getFullSourcePathFromAJCClass(this.className);
        Location loc = this.getLocation();
        if (loc == null) {
            return this.ajdbg().sourceLineOfMethodThatShouldMap(this.getClassName(), this.getMethodName(), fullSrcPath);
        }
        return this.ajdbg().sourceLineOfMethodThatShouldMap(loc, fullSrcPath);
    }
}

