/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.RequestAction;

public abstract class ExceptionRequestAction
extends RequestAction {
    protected String className;

    ExceptionRequestAction(Debugger debugger, String className) {
        super(debugger);
        this.className = className;
    }

    EventRequest resolve(ReferenceType refType) throws MultipleLocationsException {
        ExceptionRequest request = null;
        try {
            if (refType.name().equals(this.className)) {
                EventRequestManager em = this.vm().eventRequestManager();
                request = em.createExceptionRequest(refType, this.notifyCaught(), this.notifyUncaught());
                request.enable();
                request.setSuspendPolicy(2);
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return request;
    }

    public String getClassName() {
        return this.className;
    }

    abstract boolean notifyCaught();

    abstract boolean notifyUncaught();

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ExceptionRequestAction)) {
            return super.equals(other);
        }
        ExceptionRequestAction ra = (ExceptionRequestAction)other;
        return this.getClassName().equals(ra.getClassName());
    }

    public void exceptionEvent(ExceptionEvent e) {
        this.print(e);
    }
}

