/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.request.Request;

public class MonitorRequest
extends Request
implements StopListener {
    private String command;
    private int number;

    public MonitorRequest(Debugger debugger, String command, int number) {
        super(debugger);
        this.command = command;
        this.number = number;
    }

    public Object go() throws NoVMException, DebuggerException {
        if (!this.command.startsWith("monitor")) {
            this.debugger.addMonitorRequest(this);
        }
        return this.command;
    }

    public int getNumber() {
        return this.number;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MonitorRequest)) {
            return super.equals(other);
        }
        return ((MonitorRequest)other).getNumber() == this.getNumber();
    }

    public String toString() {
        return this.number + ":  " + this.command;
    }

    public void accessWatchpointEvent(AccessWatchpointEvent e) {
        this.debugger.execute(this.command);
    }

    public void breakpointEvent(BreakpointEvent e) {
        this.debugger.execute(this.command);
    }

    public void exceptionEvent(ExceptionEvent e) {
        this.debugger.execute(this.command);
    }

    public void modificationWatchpointEvent(ModificationWatchpointEvent e) {
        this.debugger.execute(this.command);
    }

    public void stepEvent(StepEvent e) {
        this.debugger.execute(this.command);
    }
}

