/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public class ReadRequest
extends Request {
    private String fileName;
    private boolean silent;

    public ReadRequest(Debugger debugger, String fileName, boolean silent) {
        super(debugger);
        this.fileName = fileName;
        this.silent = silent;
    }

    public ReadRequest(Debugger debugger, String fileName) {
        this(debugger, fileName, false);
    }

    public Object go() throws NoVMException, DebuggerException {
        Vector<String> commands = new Vector<String>();
        FileReader fileReader = null;
        String filePath = this.fileName;
        try {
            File file = this.getFile();
            filePath = file.getAbsolutePath();
            fileReader = new FileReader(file);
        }
        catch (IOException ioe) {
            throw new DebuggerException("Invalid file name '" + this.fileName + "'.");
        }
        BufferedReader in = new BufferedReader(fileReader);
        String line = "";
        try {
            if (!this.silent) {
                this.debugger.outln("*** Reading commands from " + filePath);
            }
            while ((line = in.readLine()) != null) {
                if (this.isComment(line)) continue;
                commands.add(line);
                if (this.silent) continue;
                Object o = this.debugger.execute(line);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return commands;
    }

    private boolean isComment(String line) {
        return (line = line.trim()).startsWith("#");
    }

    /*
     * Unable to fully structure code
     */
    private File getFile() throws IOException {
        iter = this.getDirs().iterator();
        file = new File(this.fileName);
        if (!file.exists()) ** GOTO lbl9
        return file.getAbsoluteFile();
lbl-1000:
        // 1 sources

        {
            dir = iter.next() + "";
            file = new File(dir + File.separator + this.fileName);
            if (!file.exists()) continue;
            return file.getAbsoluteFile();
lbl9:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl10:
        // 1 sources

        throw new IOException("File not found '" + this.fileName + "'.");
    }

    private List getDirs() {
        Vector<String> dirs = new Vector<String>();
        dirs.add(".");
        try {
            dirs.add(System.getProperty("user.home") + "");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            dirs.add(System.getProperty("user.dir") + "");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        dirs.add(this.debugger.getSourceManager().getSourcePath());
        return dirs;
    }
}

