/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.VirtualMachine;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;

public abstract class Request {
    protected Debugger debugger;
    protected boolean debug = true;

    protected void db(Object o) {
        if (this.debug) {
            System.out.println("... " + o);
        }
    }

    public Request(Debugger debugger) {
        this.debugger = debugger;
    }

    public Request() {
        this(null);
    }

    public abstract Object go() throws NoVMException, DebuggerException;

    public String getErrorMessage() {
        return "no error message";
    }

    protected VirtualMachine vm() throws NoVMException {
        return this.debugger.getVM();
    }

    protected Debugger dbg() {
        return this.debugger;
    }

    protected AJDebugger ajdbg() {
        return (AJDebugger)this.debugger;
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }
}

