/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.ClassListener;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.request.ClassLineBreakpointRequestWrapper;
import org.aspectj.debugger.request.EventRequestWrapper;

public class RequestList
implements ClassListener,
VMListener {
    private List requests;
    private Debugger debugger;

    public RequestList(Debugger debugger) {
        this.debugger = debugger;
        debugger.addClassListener(this);
        debugger.addVMListener(this);
        this.requests = Collections.synchronizedList(new Vector());
    }

    private void add(EventRequestWrapper wrapper) {
        System.out.println("Adding wrapper=" + wrapper);
        this.requests.add(wrapper);
    }

    public EventRequestWrapper remove(EventRequestWrapper wrapper) {
        if (this.requests.remove(wrapper)) {
            return wrapper;
        }
        return null;
    }

    public ClassLineBreakpointRequestWrapper createBreakpointRequest(String className, int line) {
        ClassLineBreakpointRequestWrapper wrapper = new ClassLineBreakpointRequestWrapper(this.debugger, className, line);
        this.add(wrapper);
        this.resolveAgainstAllClasses(wrapper);
        return wrapper;
    }

    boolean resolveAgainstAllClasses(EventRequestWrapper wrapper) {
        try {
            Iterator<ReferenceType> iter = this.debugger.getVM().allClasses().iterator();
            while (iter.hasNext()) {
                if (wrapper.resolve(iter.next()) == null) continue;
                this.remove(wrapper);
                return true;
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return false;
    }

    boolean resolveAgainstClass(EventRequestWrapper wrapper, ReferenceType refType) {
        if (wrapper.resolve(refType) != null) {
            this.remove(wrapper);
            return true;
        }
        return false;
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
        int i = 0;
        while (i < this.requests.size()) {
            this.resolveAgainstClass((EventRequestWrapper)this.requests.get(i), e.referenceType());
            ++i;
        }
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }

    public void vmStartEvent(VMStartEvent e) {
        int i = 0;
        while (i < this.requests.size()) {
            this.resolveAgainstAllClasses((EventRequestWrapper)this.requests.get(i));
            ++i;
        }
    }

    public void vmDeathEvent(VMDeathEvent e) {
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
    }
}

