/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.ThreadNotFoundException;
import org.aspectj.debugger.base.ThreadsNotFoundException;
import org.aspectj.debugger.request.ThreadsNeedingRequest;

public abstract class ThreadNeedingRequest
extends ThreadsNeedingRequest {
    protected String threadName;

    public ThreadNeedingRequest(Debugger debugger, String threadName) {
        super(debugger, new SingletonArrayList(threadName));
        this.threadName = threadName;
    }

    protected ThreadReference getThread() throws NoVMException, DebuggerException {
        if (this.threadName == null || this.threadName.length() == 0) {
            return this.debugger.getDefaultThread();
        }
        try {
            List threads = this.getThreads();
            if (threads != null) {
                if (threads.size() == 0) {
                    return this.debugger.getDefaultThread();
                }
                return (ThreadReference)threads.get(0);
            }
        }
        catch (ThreadsNotFoundException threadsNotFoundException) {
            // empty catch block
        }
        throw new ThreadNotFoundException(this.threadName);
    }

    static class SingletonArrayList
    extends ArrayList {
        public SingletonArrayList(Object o) {
            this.add(o);
        }
    }
}

