/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadGroupReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public class ThreadsRequest
extends Request {
    private String threadGroupName;

    public ThreadsRequest(Debugger debugger, String threadGroupName) {
        super(debugger);
        this.threadGroupName = threadGroupName.trim();
    }

    public Object go() throws NoVMException, DebuggerException {
        List list = new ArrayList();
        list = this.threadGroupName == null || this.threadGroupName.length() == 0 ? this.getAllThreads() : this.getThreads();
        return list;
    }

    private List getAllThreads() throws NoVMException, DebuggerException {
        return this.vm().allThreads();
    }

    private List getThreads() throws NoVMException, DebuggerException {
        List result = this.getThreads(null);
        if (result == null) {
            throw new ThreadGroupNotFoundException();
        }
        return result;
    }

    private List getThreads(ThreadGroupReference ref) throws NoVMException, DebuggerException {
        if (ref != null) {
            if (ref.name().equals(this.threadGroupName)) {
                return ref.threads();
            }
            try {
                long ourID = Long.parseLong(this.threadGroupName);
                long refID = ref.uniqueID();
                if (ourID == refID) {
                    return ref.threads();
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        List<ThreadGroupReference> threadGroups = null;
        threadGroups = ref == null ? this.vm().topLevelThreadGroups() : ref.threadGroups();
        Iterator<ThreadGroupReference> iter = threadGroups.iterator();
        while (iter.hasNext()) {
            List threads = this.getThreads(iter.next());
            if (threads == null) continue;
            return threads;
        }
        return null;
    }

    class ThreadGroupNotFoundException
    extends DebuggerException {
        public ThreadGroupNotFoundException() {
            super(ThreadsRequest.this.threadGroupName + " is not a valid thread group.");
        }
    }
}

