/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.tty;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.DebuggerApp;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.DebuggerListener;
import org.aspectj.debugger.base.ErrorLogger;
import org.aspectj.debugger.base.LockInformation;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.Options;
import org.aspectj.debugger.base.ParseException;
import org.aspectj.debugger.base.PromptListener;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.base.ThreadLockInformation;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.request.MonitorRequest;
import org.aspectj.debugger.request.RequestAction;
import org.aspectj.debugger.request.RequestEvent;
import org.aspectj.debugger.request.TraceMethodsRequest;
import org.aspectj.debugger.request.UntraceMethodsRequest;

public class CommandLineDebugger
implements DebuggerApp,
StopListener,
VMListener,
DebuggerListener,
PromptListener,
Runnable {
    protected AJDebugger debugger;
    private boolean isRunning = true;
    private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private static String title = "AspectJ Example Debugger";
    private static String version = "v0.1";
    private static String copyright = "(C) 2000 Xerox Corporation";
    private String lastCommand = "";
    private boolean echo = false;
    private static String[] echoStrings = new String[0];
    private boolean showPrompt;
    private String[] cmdLineArgs;
    private Thread thread;
    private Options options = new Options();
    protected boolean wantsToExit = true;
    private boolean debug = false;
    private int deaths = 0;

    private void db(Object o) {
        if (this.debug) {
            System.err.println("<CL DEBUGGER>: " + o);
        }
    }

    public CommandLineDebugger(String[] args) {
        this(args, true);
    }

    public CommandLineDebugger(AJDebugger debugger, String[] args) {
        this(debugger, args, true);
    }

    public CommandLineDebugger(String[] args, String scriptFile) {
        this(args, false);
        List commands = new Vector();
        try {
            commands = this.debugger.readCommand(scriptFile, true);
        }
        catch (NoVMException nvme) {
        }
        catch (DebuggerException de) {
            // empty catch block
        }
        int i = 0;
        while (i < commands.size()) {
            String command = commands.get(i) + "";
            this.executeCommand(command);
            ++i;
        }
        while (this.debugger.isRunning()) {
        }
        this.exit();
    }

    public CommandLineDebugger(String[] args, boolean showPrompt) {
        this.debugger = new AJDebugger(this, showPrompt);
        this.debugger.addStopListener(this);
        this.debugger.addVMListener(this);
        this.debugger.addDebuggerListener(this);
        this.debugger.addPromptListener(this);
        this.showPrompt = showPrompt;
        this.cmdLineArgs = args;
        this.options.fill(args);
    }

    public CommandLineDebugger(AJDebugger db, String[] args, boolean showPrompt) {
        this.debugger = db;
        this.debugger.addStopListener(this);
        this.debugger.addVMListener(this);
        this.debugger.addDebuggerListener(this);
        this.debugger.addPromptListener(this);
        this.showPrompt = showPrompt;
        this.cmdLineArgs = args;
        this.options.fill(args);
    }

    public void go() {
        this.debugger.setOptions(this.options);
        String mainClass = this.options.getClassName();
        boolean runNow = false;
        if (!this.options.isSet("now") && mainClass != null && !mainClass.equals("")) {
            this.debugger.loadMainClass(this.options);
        }
        this.start();
        if (this.options.isSet("now")) {
            this.debugger.runCommand();
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        if (this.showPrompt) {
            while (true) {
                this.prompt();
                this.executeCommand(this.line());
            }
        }
    }

    public boolean isGUI() {
        return false;
    }

    public AJDebugger getDebugger() {
        return this.debugger;
    }

    private boolean runNow(String[] args) {
        return !this.options.getClassName().equals("");
    }

    String className(String[] args) {
        if (args != null && args.length > 0) {
            return args[0];
        }
        return "";
    }

    String exArgs(String[] args) {
        String exArgs = "";
        if (args != null && args.length > 1) {
            int i = 1;
            while (i < args.length) {
                exArgs = exArgs + args[i] + " ";
                ++i;
            }
        }
        return exArgs.trim();
    }

    public void runCommand(String className, String exArgs) throws NoVMException, DebuggerException {
    }

    public void runCommand(String className, String vmArgs, String exArgs, boolean isSuspended, int debugTraceMode) throws NoVMException, DebuggerException {
    }

    public void clearAtCommand(String className, int line, EventRequest request) throws NoVMException, DebuggerException {
    }

    public void clearInCommand(String className, String methodProto, EventRequest request) throws NoVMException, DebuggerException {
    }

    public void clearOnCommand(String sourceName, int line, EventRequest request) throws NoVMException, DebuggerException {
    }

    public void clearCommand(List breakpoints) throws NoVMException, DebuggerException {
        this.result("Breakpoints:\n" + this.debugger.iter(breakpoints));
    }

    public void clearAllCommand(List breakpoints) throws NoVMException, DebuggerException {
        this.result("Breakpoint requests cleared:\n" + this.debugger.iter(breakpoints));
    }

    public void stopAtCommand(String className, int line, EventRequest request) throws NoVMException, DebuggerException {
    }

    public void stopInCommand(String className, String methodProto, EventRequest request) throws NoVMException, DebuggerException {
    }

    public void stopOnCommand(String sourceName, int line, EventRequest request) throws NoVMException, DebuggerException {
    }

    public void stopCommand(List breakpoints) throws NoVMException, DebuggerException {
        this.clearCommand(breakpoints);
    }

    public void contCommand() throws NoVMException, DebuggerException {
    }

    public void threadsCommand(String threadGroupName, List threads) throws NoVMException, DebuggerException {
        this.result(this.debugger.threads(threads));
    }

    public void threadGroupsCommand(List threadGroups) throws NoVMException, DebuggerException {
        this.result(this.debugger.threadGroups(threadGroups));
    }

    public void fieldsCommand(String className, List fields) throws NoVMException, DebuggerException {
        this.result(this.debugger.fields(fields));
    }

    public void methodsCommand(String className, List methods) throws NoVMException, DebuggerException {
        this.result(this.debugger.methods(methods));
    }

    public void classesCommand(List classes) throws NoVMException, DebuggerException {
        this.result(this.debugger.classes(classes));
    }

    public void classCommand(String className, ReferenceType refType) throws NoVMException, DebuggerException {
        this.result(this.debugger.clazz(refType));
    }

    public void threadCommand(String threadName, ThreadReference threadRef) throws NoVMException, DebuggerException {
    }

    public void threadGroupCommand(String threadGroupName, ThreadGroupReference threadGroupRef) throws NoVMException, DebuggerException {
    }

    public void suspendCommand(List threadNames, List threads) throws NoVMException, DebuggerException {
    }

    public void resumeCommand(List threadNames, List threads) throws NoVMException, DebuggerException {
    }

    public void whereCommand(String threadName, List frames) throws NoVMException, DebuggerException {
        this.result(this.debugger.frames(frames));
    }

    public void localsCommand(List locals) throws NoVMException, DebuggerException {
        this.result(this.debugger.locals(locals));
    }

    public void interruptCommand(String threadName, ThreadReference threadRef) throws NoVMException, DebuggerException {
    }

    public void upCommand(int frames, StackFrame currentFrame) throws NoVMException, DebuggerException {
    }

    public void downCommand(int frames, StackFrame currentFrame) throws NoVMException, DebuggerException {
    }

    public void stepCommand(StepRequest request) throws NoVMException, DebuggerException {
    }

    public void stepUpCommand(StepRequest request) throws NoVMException, DebuggerException {
    }

    public void stepiCommand(StepRequest request) throws NoVMException, DebuggerException {
    }

    public void nextCommand(StepRequest request) throws NoVMException, DebuggerException {
    }

    public void printCommand(Object valueRep, Value value) throws NoVMException, DebuggerException {
        this.result(" " + valueRep + " = " + this.getValue(value));
    }

    public void dumpCommand(Object valueRep, Value value) throws NoVMException, DebuggerException {
        this.result(" " + valueRep + " = " + this.getValue(value));
    }

    public void evalCommand(Object valueRep, Value value) throws NoVMException, DebuggerException {
        this.result(" " + valueRep + " = " + this.getValue(value));
    }

    private String getValue(Value value) {
        String valString = value + "";
        if (!this.debugger.getOptions().isSet("extra")) {
            return valString;
        }
        valString = valString + " = " + this.value(value);
        return valString;
    }

    private String value(Value value) {
        if (value == null) {
            return "null";
        }
        if (!(value instanceof ObjectReference)) {
            return value + "";
        }
        String valString = "";
        try {
            ObjectReference oRef = (ObjectReference)value;
            if (oRef instanceof ArrayReference) {
                String result = "{";
                ArrayReference arrayRef = (ArrayReference)oRef;
                int length = arrayRef.length();
                int i = 0;
                while (i < length) {
                    try {
                        result = result + this.value(arrayRef.getValue(i));
                    }
                    catch (NullPointerException npe) {
                        result = result + "null";
                    }
                    result = result + (i < length - 1 ? ", " : "");
                    ++i;
                }
                result = result + "}";
                return result;
            }
            ReferenceType refType = oRef.referenceType();
            String name = refType.name();
            ThreadReference thread = null;
            try {
                if (this.debugger.getVM().canGetOwnedMonitorInfo()) {
                    try {
                        thread = oRef.owningThread();
                    }
                    catch (UnsupportedOperationException uoe) {
                        // empty catch block
                    }
                }
                if (thread == null) {
                    thread = this.debugger.getDefaultThread();
                }
            }
            catch (NoVMException nvme) {
                return valString;
            }
            int options = 2;
            Method method = null;
            if (name.equals("java.lang.Byte")) {
                method = refType.methodsByName("byteValue").get(0);
            } else if (name.equals("java.lang.Boolean")) {
                method = refType.methodsByName("booleanValue").get(0);
            } else if (name.equals("java.lang.Character")) {
                method = refType.methodsByName("charValue").get(0);
            } else if (name.equals("java.lang.Double")) {
                method = refType.methodsByName("doubleValue").get(0);
            } else if (name.equals("java.lang.Float")) {
                method = refType.methodsByName("floatValue").get(0);
            } else if (name.equals("java.lang.Integer")) {
                method = refType.methodsByName("intValue").get(0);
            } else if (name.equals("java.lang.Long")) {
                method = refType.methodsByName("longValue").get(0);
            } else if (name.equals("java.lang.Short")) {
                method = refType.methodsByName("shortValue").get(0);
            } else {
                List<Method> list = refType.methodsByName("toString");
                if (null != list) {
                    Iterator<Method> it = list.iterator();
                    while (it.hasNext()) {
                        Method m = it.next();
                        List<Type> types = m.argumentTypes();
                        if (null != types && 0 != types.size()) continue;
                        method = m;
                        System.err.println("method: " + method);
                        break;
                    }
                }
            }
            if (null != thread && null != method) {
                Value newValue = oRef.invokeMethod(thread, method, new Vector(), options);
                valString = valString + newValue + "";
            }
        }
        catch (InvalidTypeException ite) {
        }
        catch (ClassNotLoadedException cnle) {
        }
        catch (IncompatibleThreadStateException itse) {
        }
        catch (InvocationException ie) {
            // empty catch block
        }
        return valString;
    }

    public void setWantsToExit(boolean wantsToExit) {
        this.wantsToExit = wantsToExit;
    }

    public void setCommand(Object lvalue, Object rvalue, Value oldValue, Value newValue) throws NoVMException, DebuggerException {
        this.result("Changed '" + lvalue + "' from '" + oldValue + "' to '" + newValue + "'");
    }

    public void classpathCommand(String baseDirectory, List paths) throws NoVMException, DebuggerException {
        String result = "base directory: " + baseDirectory + "\n" + "classpath: " + paths;
        this.result(result);
    }

    public void lockCommand(Object valueRep, LockInformation lockInfo) throws NoVMException, DebuggerException {
        this.result("Lock information for '" + valueRep + "':\n" + lockInfo);
    }

    public void threadlocksCommand(String threadName, ThreadLockInformation threadLockInfo) throws NoVMException, DebuggerException {
        this.result("Thread lock information for '" + threadName + "':\n" + threadLockInfo);
    }

    public void watchAccessCommand(String className, String fieldName, WatchpointRequest request) throws NoVMException, DebuggerException {
    }

    public void watchAllCommand(String className, String fieldName, WatchpointRequest request) throws NoVMException, DebuggerException {
    }

    public void unwatchAccessCommand(String className, String fieldName, WatchpointRequest request) throws NoVMException, DebuggerException {
    }

    public void unwatchAllCommand(String className, String fieldName, WatchpointRequest request) throws NoVMException, DebuggerException {
    }

    public void catchCommand(String className, ExceptionRequest request) throws NoVMException, DebuggerException {
    }

    public void ignoreCommand(String className, ExceptionRequest request) throws NoVMException, DebuggerException {
    }

    public void traceMethodsCommand(String threadName, TraceMethodsRequest.EntryExitPair pair) throws NoVMException, DebuggerException {
    }

    public void untraceMethodsCommand(String threadName, UntraceMethodsRequest.EntryExitPair pair) throws NoVMException, DebuggerException {
    }

    public void excludeCommand(List classNames, List classes) throws NoVMException, DebuggerException {
        this.result("Exclude:\n" + this.debugger.iter(classes));
    }

    public void quitCommand() throws NoVMException, DebuggerException {
    }

    public void helpCommand(String helpString) throws NoVMException, DebuggerException {
        this.result(helpString);
    }

    public void versionCommand(Object version) throws NoVMException, DebuggerException {
        this.result(version);
    }

    public void killCommand(String threadName, String valueRep, ThreadReference threadRef) throws NoVMException, DebuggerException {
        this.result("Killed thread '" + threadName + "' = " + threadRef + " with '" + valueRep + "'");
    }

    public void useCommand(String sourcePath, String newSourcePath) throws NoVMException, DebuggerException {
        this.result("Using sourcepath: " + newSourcePath);
    }

    public void workingdirCommand(String workingdirPath, String newWorkingdirPath) throws NoVMException, DebuggerException {
        this.result("Using workingdir: " + newWorkingdirPath);
    }

    public void listCommand(List sourceLines) throws NoVMException, DebuggerException {
        String o = this.debugger.sourceLines(sourceLines, true);
        if (sourceLines.size() == 0) {
            o = "Source file not found: unkown.source";
        }
        this.result(o);
    }

    public void listCommand(String sourceName, List sourceLines) throws NoVMException, DebuggerException {
        String o = this.debugger.sourceLines(sourceLines, true);
        if (sourceLines.size() == 0) {
            o = "Source file not found: " + (sourceName != null ? sourceName : "<unkown>");
        }
        this.result(o);
    }

    public void listCommand(String sourceName, int lineNumber, SourceManager.SourceLine sl) throws NoVMException, DebuggerException {
        String o = this.debugger.sourceLine(sl);
        if (sl.getLineNumber() < 0) {
            o = "<no source available for " + sourceName + ":" + lineNumber + ">";
        }
        this.result(o);
    }

    public void listCommand(String sourceName, int startLine, int endLine, List sourceLines) throws NoVMException, DebuggerException {
        this.listCommand(sourceLines);
    }

    public void monitorCommand(String command, String result) throws NoVMException, DebuggerException {
    }

    public void monitorCommand(List monitors) throws NoVMException, DebuggerException {
        this.result(monitors);
    }

    public void unmonitorCommand(int number, MonitorRequest request) throws NoVMException, DebuggerException {
        this.result("Unmonitoring " + request);
    }

    public void readCommand(String fileName, List commands) throws NoVMException, DebuggerException {
    }

    public void viewCommand(String sourceName, List sourceLines) throws NoVMException, DebuggerException {
        this.listCommand(sourceName, sourceLines);
    }

    public void tostringCommand(String tostring) throws NoVMException, DebuggerException {
        this.result(tostring);
    }

    public void connectCommand(VirtualMachine vm) throws NoVMException, DebuggerException {
        throw new DebuggerException("connect is not valid on the command line");
    }

    public void pwdCommand(File file) throws NoVMException, DebuggerException {
        if (file != null) {
            this.result(file.getAbsolutePath());
        }
    }

    public void lsCommand(String dir, List files) throws NoVMException, DebuggerException {
        this.result(dir + ":\n" + this.debugger.iter(files));
    }

    public void handleParseException(ParseException e) {
        this.result(e.getMessage());
    }

    public void handleNoVMException(NoVMException e) {
        this.result("There is no VM: " + this.nonull(e.getMessage()));
    }

    public void handleDebuggerException(DebuggerException e) {
        this.result(e.getMessage());
    }

    public void handleVMDisconnectedException(VMDisconnectedException e) {
        this.result("The VM has already disconnected.");
    }

    public void handleInternalException(Throwable e) {
        this.result("Internal error: " + e);
        e.printStackTrace(this.getOutputStream());
        new ErrorLogger(this.debugger).log(e);
    }

    public PrintStream getOutputStream() {
        return System.out;
    }

    public Object executeCommand(String str) {
        if (this.echo(str)) {
            this.result(str);
        }
        return this.debugger.execute(str.trim());
    }

    private boolean echo(String str) {
        if (str != null) {
            str = str.trim();
            int i = 0;
            while (i < echoStrings.length) {
                if (str.startsWith(echoStrings[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void repeat() {
        this.executeCommand(this.lastCommand);
    }

    protected boolean nonull(String str) {
        return str != null && !"null".equals(str);
    }

    protected void result(Object str) {
        if (str != null) {
            this.outln(str);
        }
    }

    protected void result(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.result(iter.next());
        }
    }

    private void warn(String str) {
        this.outln("  *** " + str);
    }

    public String line() {
        String str = "";
        try {
            this.db("get line?");
            str = this.in.readLine();
            this.db("got line str=" + str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str;
    }

    public void exit() {
        this.isRunning = false;
        this.debugger.shutDown();
        if (this.wantsToExit()) {
            System.exit(0);
        }
    }

    private void prompt() {
        if (this.showPrompt) {
            this.out(this.debugger.getPrompt() + " ");
        }
    }

    private void out(Object o) {
        System.out.print(o);
        System.out.flush();
    }

    public void outln(Object o) {
        this.out(o);
        this.out("\n");
    }

    public void log(Object o) {
    }

    private VirtualMachine vm() {
        return this.debugger.vm();
    }

    public void resetPrompt() {
        this.prompt();
    }

    public void accessWatchpointEvent(AccessWatchpointEvent e) {
    }

    public void breakpointEvent(BreakpointEvent e) {
        this.result("\n\nBreakpoint hit: " + this.debugger.format(e));
    }

    public void exceptionEvent(ExceptionEvent e) {
        this.result("\n\nException occured: " + this.debugger.format(e));
    }

    public void modificationWatchpointEvent(ModificationWatchpointEvent e) {
    }

    public void stepEvent(StepEvent e) {
        this.result("\n\nStep completed: " + this.debugger.format(e));
    }

    public void vmDeathEvent(VMDeathEvent e) {
        this.die();
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        this.die();
    }

    public void vmStartEvent(VMStartEvent e) {
        this.deaths = 0;
        this.result("VM Started: ");
    }

    private void die() {
        if (this.deaths++ == 0) {
            this.result("\nThe application has exited.");
        }
        this.exit();
    }

    public void requestSetEvent(RequestEvent re) {
        RequestAction action = (RequestAction)re.getRequest();
        this.result("Set " + (action.isDeferred() ? " deferred " : "") + re.getRequest());
    }

    public void requestClearEvent(RequestEvent re) {
        this.result("Clear " + re.getRequest());
    }

    public void requestDeferredEvent(RequestEvent re) {
        if (!this.debugger.isRunning()) {
            this.result("Deferring " + re.getRequest() + "\n" + "It will be set after the class is loaded.");
        }
    }

    public void requestFailedEvent(RequestEvent re) {
        this.result("Unable to set " + re.getRequest() + " : " + re.getErrorMessage());
    }

    public boolean wantsToExit() {
        return this.wantsToExit;
    }

    public boolean canRestart() {
        return false;
    }

    public VirtualMachine connect(String vmArgs, String className, String commandLine) {
        return null;
    }
}

