/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.swing.CompilerMessage;
import org.aspectj.ajde.ui.swing.CompilerMessagesCellRenderer;
import org.aspectj.asm.SourceLocation;
import org.aspectj.asm.StructureMessage;
import org.aspectj.tools.ajbrowser.BrowserManager;

public class CompilerMessagesPanel
extends JPanel
implements TaskListManager {
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList list = new JList();
    private DefaultListModel listModel = new DefaultListModel();
    private BorderLayout borderLayout1 = new BorderLayout();

    public CompilerMessagesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.list.setModel(this.listModel);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    int index = CompilerMessagesPanel.this.list.locationToIndex(e.getPoint());
                    if (CompilerMessagesPanel.this.listModel.getSize() >= index && index != -1) {
                        CompilerMessage cm = (CompilerMessage)CompilerMessagesPanel.this.listModel.getElementAt(index);
                        Ajde.getDefault().getEditorManager().showSourceLine(cm.sourceLocation, true);
                    }
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        this.list.setCellRenderer(new CompilerMessagesCellRenderer());
    }

    public void addSourcelineTask(String message, SourceLocation sourceLocation, StructureMessage.Kind kind) {
        this.listModel.addElement(new CompilerMessage(message, sourceLocation, kind));
        BrowserManager.getDefault().showMessages();
    }

    public void addProjectTask(String message, StructureMessage.Kind kind) {
        this.listModel.addElement(new CompilerMessage(message, kind));
        BrowserManager.getDefault().showMessages();
    }

    public void clearTasks() {
        this.listModel.clear();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.list, null);
    }
}

