/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajc;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.aspectj.compiler.base.CompilerErrors;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.ExitRequestException;
import org.aspectj.compiler.base.InternalCompilerError;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.Options;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.util.ConfigParser;

public class Main {
    static final String usage = "Usage: ajc <options> <source files>\n\nwhere <options> includes:\n  -verbose              Output messages about what ajc is doing\n  -version              Print the version of ajc               \n  -nocomments           Don't generate any comments into the woven code\n  -emacssym             Generate symbols used by AJDE for Emacs\n  -usejavac             Use javac to generate .class files\n  -preprocess           Generate regular Java code into <workingdir>\n                        Don't try to generate any .class files\n  -workingdir <dir>     Only relevant with -usejavac or -preprocess modes\n                        Specify where to place intermediate .java files\n                        <dir> defaults to ./ajworkingdir\n  -O                    Optimize; may hinder debugging or enlarge class files\n  -d <directory>        Specify where to place generated .class files\n                        <directory> defaults to the current working dir\n  -classpath <path>     Specify where to find user class files\n  -bootclasspath <path> Override location of bootstrap class files\n  -extdirs <dirs>       Override location of installed extensions\n  -argfile <file>       the file is a line-delimited list of arguments\n                        these arguments are inserted into the argument list\n  -encoding <encoding>  Specify character encoding used by source files\n  -source 1.4           Support assertions as defined in JLS-1.4\n  -lenient              Be extra-lenient in interpreting the java specification\n  -strict               Be extra-strict in interpreting the java specification\n  -porting              Make the use of some features from pre-1.0 versions\n                        of AspectJ be warnings to ease porting old code\n\nIf an argument is of the form @<filename>, the file will be interpreted as\na line delimited set of arguments to insert into the argument list.";
    protected List filenames;
    protected JavaCompiler compiler;
    protected ErrorHandler errorHandler;
    static final String internalErrorMessage = "Please copy the following text into an email message and send it,\nalong with any additional information you can add to:            \n                                                                 \n       support@aspectj.org                            \n                                                                 \n";
    static final String outOfMemoryMessage = "The compiler ran out of memory while trying to compile your system.\nBy default, only 64MB are available to ajc.  You can increase\nthis amount by editing the ajc launch script to pass -Xmx128M or\nsome larger amount of memory to the JVM used to run ajc.\nMore information about this issue can be found in the FAQ at\nhttp://aspectj.org/faq by searching for \"OutOfMemoryError\".\n";
    static final String generalCodeRequest = "If possible, please include a small fragment of code that can \nreproduce the error, provided that code isn't confidential.  \n";

    public static void main(String[] args) throws IOException {
        new Main().realMain(args);
    }

    public Main(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Main() {
        this(null);
    }

    public void checkJavaVersion() {
        Class<?> c;
        try {
            c = Class.forName("java.util.Map");
        }
        catch (ClassNotFoundException cnfe) {
            this.fail("Java 2 or later required to run ajc (jdk1.2 or 1.3); not java " + System.getProperty("java.version"));
        }
        try {
            c = Class.forName("java.lang.CharSequence");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void realMain(String[] args) {
        int exitCode = -1;
        do {
            this.compiler = null;
            exitCode = this.compile(args);
        } while (this.shouldRecompile());
        this.exit(exitCode);
    }

    public Options getOptions() {
        return this.getCompiler().getOptions();
    }

    public int compile(String[] args) {
        try {
            this.checkJavaVersion();
            return this.run(args);
        }
        catch (CompilerErrors errs) {
            return -1;
        }
        catch (InternalCompilerError compilerError) {
            this.handleInternalError(compilerError.uncaughtThrowable, compilerError);
            return -2;
        }
        catch (ExitRequestException exitException) {
            return exitException.getValue();
        }
        catch (Throwable e) {
            this.handleInternalError(e, null);
            return -2;
        }
    }

    protected JavaCompiler getCompiler() {
        if (this.compiler != null) {
            return this.compiler;
        }
        if (this.compiler == null) {
            this.compiler = this.errorHandler == null ? new AspectJCompiler() : new AspectJCompiler(this.errorHandler);
        }
        return this.compiler;
    }

    public void clearState() {
        if (this.compiler != null) {
            this.compiler.clearState();
        }
    }

    public int run(String[] args) {
        this.filenames = new LinkedList();
        this.parseCommandLine(args);
        this.getCompiler().compile(this.filenames);
        return 0;
    }

    public boolean shouldRecompile() {
        if (!this.getCompiler().getOptions().incremental) {
            return false;
        }
        System.out.print("ajc> ");
        System.out.flush();
        byte[] buffer = new byte[2048];
        int n = 0;
        try {
            n = System.in.read(buffer);
            if (n <= 0) {
                throw new IOException();
            }
        }
        catch (Throwable e) {
            System.out.println("bye!");
            this.exit(0);
        }
        return buffer[0] < 97 || buffer[0] > 122;
    }

    protected void parseCommandLine(String[] args) {
        if (args.length == 0) {
            this.displayHelpAndExit(null);
        }
        AjcConfigParser configParser = new AjcConfigParser();
        configParser.parseCommandLine(args);
        this.filenames = configParser.getFiles();
        if (this.filenames.size() == 0) {
            this.displayHelpAndExit("Nothing to compile.");
        }
    }

    protected void printVersion() {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 3);
        TimeZone tz = TimeZone.getTimeZone("PST");
        formatter.setTimeZone(tz);
        Date buildDate = new Date(this.getCompiler().getBuildTime());
        String dateString = formatter.format(buildDate) + " " + tz.getDisplayName(false, 0);
        System.err.print("ajc version " + this.getCompiler().getVersion() + " (built " + dateString + ")");
        System.err.println(" running on java " + System.getProperty("java.version"));
    }

    public void handleInternalError(Throwable uncaughtThrowable, InternalCompilerError compilerError) {
        if (uncaughtThrowable instanceof OutOfMemoryError) {
            System.err.println(outOfMemoryMessage);
            return;
        }
        System.err.println("An internal error occured in AspectJ-" + this.getCompiler().getVersion());
        System.err.println(internalErrorMessage);
        System.err.println(uncaughtThrowable.toString());
        uncaughtThrowable.printStackTrace();
        System.err.println();
        if (compilerError != null) {
            compilerError.showWhere(new PrintWriter(System.err));
        }
        System.err.println(generalCodeRequest);
    }

    protected void displayHelpAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println();
        System.err.println(usage);
        this.internalExit(0);
    }

    protected void fail(Exception e) {
        this.fail(e.toString());
    }

    protected void fail(String message) {
        System.err.println(message);
        this.internalExit(1);
    }

    void internalExit(int value) {
        System.out.flush();
        System.err.flush();
        throw new ExitRequestException(value);
    }

    protected void exit(int value) {
        System.out.flush();
        System.err.flush();
        System.exit(value);
    }

    private class AjcConfigParser
    extends ConfigParser {
        private AjcConfigParser() {
        }

        protected void parseOption(String arg, LinkedList args) {
            if (arg.equals("-d")) {
                Main.this.getOptions().outputDir = this.makeFile(this.removeStringArg(args));
            } else if (arg.equals("-workingdir")) {
                Main.this.getOptions().workingDir = this.makeFile(this.removeStringArg(args));
            } else if (arg.equals("-version")) {
                Main.this.printVersion();
                Main.this.internalExit(0);
            } else if (arg.equals("-showversion")) {
                Main.this.printVersion();
            } else if (arg.startsWith("-")) {
                String key = arg.substring(1);
                Object value = Boolean.TRUE;
                if (Main.this.getOptions().isStringOption(key)) {
                    value = this.removeStringArg(args);
                } else if (Main.this.getOptions().isIntegerOption(key)) {
                    value = Integer.valueOf(this.removeStringArg(args));
                }
                if (!Main.this.getOptions().set(key, value)) {
                    this.showWarning("invalid flag: " + key);
                    Main.this.displayHelpAndExit(null);
                }
            } else {
                this.showWarning(arg + " is an invalid option or argument.");
                Main.this.displayHelpAndExit(null);
            }
        }

        protected void showError(String message) {
            this.showWarning(message);
            Main.this.internalExit(1);
        }
    }
}

