/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ThrowsTag;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.aspectj.ajdoc.AdviceDoc;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.tools.ajdoc.ClassDocImpl;
import org.aspectj.tools.ajdoc.MemberDocImpl;
import org.aspectj.tools.ajdoc.ParameterImpl;
import org.aspectj.tools.ajdoc.Util;

public abstract class ExecutableMemberDocImpl
extends MemberDocImpl
implements ExecutableMemberDoc {
    private Collection advice;
    private Collection parameters;
    private Collection thrownExceptions;
    private String signature;
    private String flatSignature;

    public ExecutableMemberDocImpl(ClassDoc containingClass) {
        super(containingClass);
    }

    protected abstract Collection createAdvice();

    protected abstract Formals getFormals();

    protected abstract TypeDs getThrows();

    public void makeParameters(Formals formals) {
        this.parameters = this.createParameters(formals);
    }

    public void makeThrownExceptions(TypeDs thrown) {
        this.thrownExceptions = this.createThrownExceptions(thrown);
    }

    public final AdviceDoc[] advice() {
        if (this.advice == null) {
            this.advice = this.createAdvice();
        }
        return this.advice.toArray(new AdviceDoc[this.advice.size()]);
    }

    public final ClassDoc[] thrownExceptions() {
        if (this.thrownExceptions == null) {
            this.makeThrownExceptions(this.getThrows());
        }
        return this.thrownExceptions.toArray(new ClassDoc[this.thrownExceptions.size()]);
    }

    public final Parameter[] parameters() {
        if (this.parameters == null) {
            this.makeParameters(this.getFormals());
        }
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public String flatSignature() {
        if (this.flatSignature == null) {
            this.flatSignature = Util.flatSignature(this.parameters());
        }
        return this.flatSignature;
    }

    public String signature() {
        if (this.signature == null) {
            this.signature = Util.signature(this.parameters());
        }
        return this.signature;
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifierSpecifier());
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifierSpecifier());
    }

    public ThrowsTag[] throwsTags() {
        return this.getComment().throwsTags();
    }

    public ParamTag[] paramTags() {
        return this.getComment().paramTags();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.name());
        sb.append('(');
        Parameter[] params = this.parameters();
        int i = 0;
        int N = params.length;
        while (i < N) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(params[i].type().qualifiedTypeName());
            sb.append(params[i].type().dimension());
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private Collection createParameters(Formals formals) {
        if (formals == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>(formals.size());
        int i = 0;
        int N = formals.size();
        while (i < N) {
            list.add(new ParameterImpl(formals.get(i)));
            ++i;
        }
        return list;
    }

    private Collection createThrownExceptions(TypeDs typeds) {
        if (typeds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ClassDocImpl> list = new ArrayList<ClassDocImpl>(typeds.size());
        int i = 0;
        int N = typeds.size();
        while (i < N) {
            list.add(ClassDocImpl.getInstance(((NameType)typeds.get(i).getType()).getTypeDec()));
            ++i;
        }
        return list;
    }

    public boolean weakEquals(Object md) {
        Parameter[] edsPds;
        if (!(md instanceof ExecutableMemberDocImpl)) {
            return false;
        }
        ExecutableMemberDocImpl emdi = (ExecutableMemberDocImpl)md;
        if (!this.name().equals(emdi.name())) {
            return false;
        }
        Parameter[] ourPds = this.parameters();
        if (ourPds.length != (edsPds = emdi.parameters()).length) {
            return false;
        }
        int i = 0;
        int N = ourPds.length;
        while (i < N) {
            if (!ourPds[i].equals(edsPds[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

