/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.util.Collections;
import java.util.List;
import org.aspectj.ajdoc.ClassDoc;
import org.aspectj.ajdoc.OfClauseDoc;
import org.aspectj.ajdoc.OfEachObjectDoc;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PerCFlow;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PerObject;
import org.aspectj.compiler.crosscuts.ast.PerSingleton;

public class OfClauseDocImpl {
    private static final Factory factory = new Factory();

    public static final OfClauseDoc getInstance(PerClause clause) {
        return factory.getInstance(clause);
    }

    private static class Factory {
        private static final OfClauseDoc EACH_CFLOW = new OfClauseDoc(){

            public OfClauseDoc.Kind kind() {
                return OfClauseDoc.Kind.EACH_CFLOW;
            }
        };
        private static final OfClauseDoc EACH_JVM = new OfClauseDoc(){

            public OfClauseDoc.Kind kind() {
                return OfClauseDoc.Kind.EACH_JVM;
            }
        };

        private Factory() {
        }

        public final OfClauseDoc getInstance(PerClause clause) {
            if (clause instanceof PerCFlow) {
                return EACH_CFLOW;
            }
            if (clause instanceof PerSingleton) {
                return EACH_JVM;
            }
            if (clause instanceof PerObject) {
                return new OfEachObjectDocImpl((PerObject)clause);
            }
            return null;
        }
    }

    private static final class OfEachObjectDocImpl
    implements OfEachObjectDoc {
        private final List instances;

        private OfEachObjectDocImpl(PerObject eo) {
            this.instances = this.createInstances(eo);
        }

        public ClassDoc[] instances() {
            return this.instances.toArray(new ClassDoc[this.instances.size()]);
        }

        public OfClauseDoc.Kind kind() {
            return OfClauseDoc.Kind.EACH_OBJECT;
        }

        private List createInstances(PerObject eo) {
            Pcd pc = eo.getPcd();
            if (pc == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.EMPTY_LIST;
        }
    }
}

