/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdoc.AspectDoc;
import org.aspectj.ajdoc.ClassDoc;
import org.aspectj.ajdoc.PackageDoc;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.tools.ajdoc.AjdocCompiler;
import org.aspectj.tools.ajdoc.ClassDocImpl;
import org.aspectj.tools.ajdoc.Comment;
import org.aspectj.tools.ajdoc.DocImpl;
import org.aspectj.tools.ajdoc.Util;

public class PackageDocImpl
extends DocImpl
implements PackageDoc {
    public static final String UNNAMED_PACKAGE = "";
    private static AjdocCompiler ajdoc = AjdocCompiler.instance();
    private static AspectJCompiler ajc = ajdoc;
    private Set allClasses = new HashSet();
    private Comment comment;
    private String name;
    private static Map namesToPackages = new HashMap();

    public AspectJCompiler ajc() {
        return ajc;
    }

    private PackageDocImpl(String name) {
        this.name = name;
        this.findDocumentation();
    }

    public void addClass(com.sun.javadoc.ClassDoc classDoc) {
        this.allClasses.add(classDoc);
    }

    public com.sun.javadoc.ClassDoc findClass(String className) {
        Type type = ajc.getTypeManager().findType(this.name(), className);
        if (type != null) {
            return ClassDocImpl.getInstance(type.getTypeDec());
        }
        Iterator i = this.allClasses.iterator();
        while (i.hasNext()) {
            com.sun.javadoc.ClassDoc cd = (com.sun.javadoc.ClassDoc)i.next();
            if (!className.equals(cd.name())) continue;
            return cd;
        }
        return null;
    }

    public com.sun.javadoc.ClassDoc[] allClasses() {
        return this.allClasses.toArray(new com.sun.javadoc.ClassDoc[this.allClasses.size()]);
    }

    public AspectDoc[] aspects() {
        ArrayList<ClassDoc> list = new ArrayList<ClassDoc>();
        Iterator i = this.allClasses.iterator();
        while (i.hasNext()) {
            ClassDoc doc = (ClassDoc)i.next();
            if (!doc.isAspect()) continue;
            list.add(doc);
        }
        return list.toArray(new AspectDoc[list.size()]);
    }

    public com.sun.javadoc.ClassDoc[] ordinaryClasses() {
        ArrayList<com.sun.javadoc.ClassDoc> list = new ArrayList<com.sun.javadoc.ClassDoc>();
        Iterator i = this.allClasses.iterator();
        while (i.hasNext()) {
            com.sun.javadoc.ClassDoc doc = (com.sun.javadoc.ClassDoc)i.next();
            if (!doc.isOrdinaryClass()) continue;
            list.add(doc);
        }
        return list.toArray(new com.sun.javadoc.ClassDoc[list.size()]);
    }

    public com.sun.javadoc.ClassDoc[] exceptions() {
        ArrayList<com.sun.javadoc.ClassDoc> list = new ArrayList<com.sun.javadoc.ClassDoc>();
        Iterator i = this.allClasses.iterator();
        while (i.hasNext()) {
            com.sun.javadoc.ClassDoc doc = (com.sun.javadoc.ClassDoc)i.next();
            if (!doc.isException()) continue;
            list.add(doc);
        }
        return list.toArray(new com.sun.javadoc.ClassDoc[list.size()]);
    }

    public com.sun.javadoc.ClassDoc[] errors() {
        ArrayList<com.sun.javadoc.ClassDoc> list = new ArrayList<com.sun.javadoc.ClassDoc>();
        Iterator i = this.allClasses.iterator();
        while (i.hasNext()) {
            com.sun.javadoc.ClassDoc doc = (com.sun.javadoc.ClassDoc)i.next();
            if (!doc.isError()) continue;
            list.add(doc);
        }
        return list.toArray(new com.sun.javadoc.ClassDoc[list.size()]);
    }

    public com.sun.javadoc.ClassDoc[] interfaces() {
        ArrayList<com.sun.javadoc.ClassDoc> list = new ArrayList<com.sun.javadoc.ClassDoc>();
        Iterator i = this.allClasses.iterator();
        while (i.hasNext()) {
            com.sun.javadoc.ClassDoc doc = (com.sun.javadoc.ClassDoc)i.next();
            if (!doc.isInterface()) continue;
            list.add(doc);
        }
        return list.toArray(new com.sun.javadoc.ClassDoc[list.size()]);
    }

    public String name() {
        return this.isIncluded() ? this.name : null;
    }

    public boolean equals(Object other) {
        return other instanceof PackageDocImpl && other != null ? this.name().equals(((PackageDocImpl)other).name()) : super.equals(other);
    }

    public String toString() {
        return this.name();
    }

    private void findDocumentation() {
        if (ajdoc == null) {
            return;
        }
        String filename = (this.name.equals(UNNAMED_PACKAGE) ? this.name : this.name.replace('.', File.separatorChar) + File.separatorChar) + "package.html";
        File html = ajdoc.findFile(filename, false);
        if (html == null) {
            return;
        }
        String rawCommentText = Util.documentation(html, ajdoc.err());
        this.setComment(new Comment(this, rawCommentText));
    }

    public static Collection packages() {
        return namesToPackages.values();
    }

    public static void init(AspectJCompiler ajc) {
        PackageDocImpl.ajc = ajc;
        if (ajc instanceof AjdocCompiler) {
            ajdoc = (AjdocCompiler)ajc;
        }
    }

    public static PackageDocImpl getPackageDoc(TypeDec typeDec) {
        return PackageDocImpl.getPackageDoc(typeDec.getPackageName());
    }

    public static PackageDocImpl getPackageDoc(String packageName) {
        return PackageDocImpl.addPackageDoc(packageName);
    }

    public static PackageDocImpl addPackageDoc(String name) {
        PackageDocImpl packageDoc;
        if (name == null) {
            name = UNNAMED_PACKAGE;
        }
        if ((packageDoc = (PackageDocImpl)namesToPackages.get(name)) == null) {
            packageDoc = new PackageDocImpl(name);
            PackageDocImpl.addPackageDoc(packageDoc);
        }
        return packageDoc;
    }

    public static PackageDocImpl addPackageDoc(PackageDoc packageDoc) {
        if (packageDoc == null) {
            return null;
        }
        return (PackageDocImpl)namesToPackages.put(packageDoc.name(), packageDoc);
    }

    public static void excludeEmptyPackages() {
        Iterator i = PackageDocImpl.packages().iterator();
        while (i.hasNext()) {
            PackageDocImpl pkg = (PackageDocImpl)i.next();
            if (pkg.allClasses().length >= 1) continue;
            pkg.setIncluded(false);
        }
    }
}

