/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.ajdoc.ClassDoc;
import org.aspectj.ajdoc.PackageDoc;
import org.aspectj.ajdoc.RootDoc;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.World;
import org.aspectj.tools.ajdoc.AccessChecker;
import org.aspectj.tools.ajdoc.AspectDocImpl;
import org.aspectj.tools.ajdoc.ClassDocImpl;
import org.aspectj.tools.ajdoc.DocImpl;
import org.aspectj.tools.ajdoc.PackageDocImpl;
import org.aspectj.tools.ajdoc.Quietable;

public class RootDocImpl
extends DocImpl
implements RootDoc,
Quietable {
    private final Set specifiedPackages;
    private final Set specifiedClasses;
    private final Set packages = new HashSet();
    private final Set classes = new HashSet();
    private final String[][] options;
    private final World world;
    private final AccessChecker filter;
    private boolean notice = true;

    public RootDocImpl(World world, String[][] options, Collection pkgnames, Collection classnames, AccessChecker filter) {
        this.world = world;
        this.options = options;
        this.filter = null != filter ? filter : AccessChecker.PUBLIC;
        HashSet set = this.createSpecifiedPackages(pkgnames);
        this.specifiedPackages = set;
        set = this.createSpecifiedClasses(classnames);
        this.specifiedClasses = Collections.unmodifiableSet(set);
        this.addSpecifiedPackages();
        this.addSpecifiedClasses();
        this.setupDominatesRelations();
        this.ensureWorldInclusion();
    }

    public com.sun.javadoc.ClassDoc[] classes() {
        return this.classes.toArray(new ClassDoc[this.classes.size()]);
    }

    public com.sun.javadoc.ClassDoc classNamed(String className) {
        com.sun.javadoc.ClassDoc[] docs = this.classes();
        int i = 0;
        while (i < docs.length) {
            com.sun.javadoc.ClassDoc doc = docs[i];
            if (doc.name().equals(className)) {
                return doc;
            }
            ++i;
        }
        return null;
    }

    public com.sun.javadoc.PackageDoc packageNamed(String packageName) {
        Iterator i = this.packages.iterator();
        while (i.hasNext()) {
            com.sun.javadoc.PackageDoc doc = (com.sun.javadoc.PackageDoc)i.next();
            if (!doc.name().equals(packageName)) continue;
            return doc;
        }
        return null;
    }

    public World world() {
        return this.world;
    }

    public String[][] options() {
        return this.options;
    }

    public com.sun.javadoc.ClassDoc[] specifiedClasses() {
        return this.specifiedClasses.toArray(new ClassDoc[this.specifiedClasses.size()]);
    }

    public com.sun.javadoc.PackageDoc[] specifiedPackages() {
        return this.specifiedPackages.toArray(new PackageDoc[this.specifiedPackages.size()]);
    }

    public void quiet() {
        this.notice = false;
    }

    public void speak() {
        this.notice = true;
    }

    public void printError(String msg) {
        this.err().printError(msg);
    }

    public void printNotice(String msg) {
        if (this.notice) {
            this.err().printNotice(msg);
        }
    }

    public void printWarning(String msg) {
        this.err().printWarning(msg);
    }

    public String name() {
        return "who knows???";
    }

    private HashSet createSpecifiedPackages(Collection pkgnames) {
        HashSet<PackageDocImpl> result = new HashSet<PackageDocImpl>();
        Iterator i = pkgnames.iterator();
        while (i.hasNext()) {
            String pkgname = (String)i.next();
            PackageDocImpl pkgdoc = PackageDocImpl.getPackageDoc(pkgname);
            pkgdoc.setIncluded(true);
            result.add(pkgdoc);
        }
        return result;
    }

    private void addWorldTypes() {
        Iterator i = this.world.getTypes().iterator();
        while (i.hasNext()) {
            TypeDec td = (TypeDec)i.next();
            ClassDocImpl cd = ClassDocImpl.getInstance(td);
            this.addClass(cd);
            cd.setIncluded(this.filter.canAccess(td));
        }
    }

    private HashSet createSpecifiedClasses(Collection classnames) {
        HashSet<com.sun.javadoc.ClassDoc> result = new HashSet<com.sun.javadoc.ClassDoc>();
        if (classnames != null) {
            Iterator i = classnames.iterator();
            block0: while (i.hasNext()) {
                String classname = (String)i.next();
                Iterator j = this.world.getTypes().iterator();
                while (j.hasNext()) {
                    ClassDocImpl cd;
                    TypeDec td = (TypeDec)j.next();
                    if (!this.filter.canAccess(td) || !(cd = ClassDocImpl.getInstance(td)).qualifiedName().equals(classname)) continue;
                    result.add(cd);
                    com.sun.javadoc.ClassDoc[] inners = cd.innerClasses();
                    if (null == inners) continue block0;
                    int l = 0;
                    while (l < inners.length) {
                        result.add(inners[l]);
                        ++l;
                    }
                    continue block0;
                }
            }
        }
        return result;
    }

    private void addSpecifiedClasses() {
        Iterator i = ((AbstractList)new ArrayList(this.specifiedClasses)).iterator();
        while (i.hasNext()) {
            com.sun.javadoc.ClassDoc cd = (com.sun.javadoc.ClassDoc)i.next();
            this.addClass(cd);
        }
    }

    private void addSpecifiedPackages() {
        Iterator i = ((AbstractList)new ArrayList(this.specifiedPackages)).iterator();
        while (i.hasNext()) {
            com.sun.javadoc.PackageDoc pd = (com.sun.javadoc.PackageDoc)i.next();
            com.sun.javadoc.ClassDoc[] allClasses = pd.allClasses();
            if (allClasses.length == 0) {
                this.specifiedPackages.remove(pd);
                continue;
            }
            int j = 0;
            while (j < allClasses.length) {
                this.addClass(allClasses[j]);
                ++j;
            }
        }
    }

    private void addClass(com.sun.javadoc.ClassDoc cd) {
        if (null == cd) {
            return;
        }
        ClassDocImpl impl = (ClassDocImpl)cd;
        if (this.filter.canAccess(impl.typeDec()) && !this.classes.contains(impl)) {
            impl.setIncluded(true);
            this.classes.add(impl);
            this.packages.add(impl.containingPackage());
            com.sun.javadoc.ClassDoc[] inners = impl.innerClasses();
            int i = 0;
            while (i < inners.length) {
                this.addClass(inners[i]);
                ++i;
            }
        }
    }

    private void setupDominatesRelations() {
        ArrayList<ClassDocImpl> aspects = new ArrayList<ClassDocImpl>();
        com.sun.javadoc.ClassDoc[] classes = this.classes();
        int i = 0;
        while (i < classes.length) {
            ClassDocImpl cd = (ClassDocImpl)classes[i];
            if (cd.isAspect()) {
                aspects.add(cd);
            }
            ++i;
        }
        Iterator i2 = aspects.iterator();
        while (i2.hasNext()) {
            AspectDocImpl aspect1 = (AspectDocImpl)i2.next();
            Iterator j = aspects.iterator();
            while (j.hasNext()) {
                AspectDocImpl aspect2 = (AspectDocImpl)j.next();
                if (!aspect1.dominates(aspect2)) continue;
                aspect1.addDominatee(aspect2);
                aspect2.addDominator(aspect1);
            }
        }
    }

    private void ensureWorldInclusion() {
        Iterator i = this.world.getTypes().iterator();
        while (i.hasNext()) {
            TypeDec td = (TypeDec)i.next();
            ClassDocImpl cd = ClassDocImpl.getInstance(td);
            boolean isIncluded = cd.isIncluded();
            boolean shouldInclude = this.filter.canAccess(td);
            if (shouldInclude == isIncluded) continue;
            cd.setIncluded(shouldInclude);
        }
    }
}

