/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc.rootmakers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.tools.ajdoc.ErrPrinter;

public abstract class Javadoc {
    protected ErrPrinter err;

    protected final Object invoke(Method method, Object owner, Object[] args) {
        if (method == null || owner == null) {
            return null;
        }
        String classname = owner.getClass().getName();
        String methodName = method.getName();
        try {
            Thread.currentThread().setContextClassLoader(owner.getClass().getClassLoader());
            return method.invoke(owner, args);
        }
        catch (InvocationTargetException e) {
            this.err.invocationTargetException(e, classname, methodName);
        }
        catch (IllegalAccessException e) {
            this.err.ex(e, "method_not_accessible", classname, methodName);
        }
        catch (Exception e) {
            this.err.ex(e, "exception_thrown", "List", classname, methodName, e != null ? e.getMessage() : e + "");
        }
        return null;
    }

    protected final Class type(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            this.err.ex(e, "class_not_found", "Hashtable", classname);
            return null;
        }
    }

    protected final Method method(String name, Class[] params, Class type) {
        if (type == null) {
            return null;
        }
        try {
            return type.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            this.err.ex(e, "method_not_found", type.getClass().getName(), name);
            return null;
        }
    }

    protected final Object newInstance(String classname) {
        return this.newInstance(this.type(classname));
    }

    protected final Object newInstance(Class type) {
        if (type == null) {
            return null;
        }
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            this.err.ex(e, "must_have_default_ctor", type.getClass().getName());
            return null;
        }
        catch (IllegalAccessException e) {
            this.err.ex(e, "method_not_accessible", type.getClass().getName(), "new()");
            return null;
        }
    }
}

