/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajdoc.AdviceDoc;
import org.aspectj.ajdoc.AspectDoc;

public class Statics {
    public static String type(ClassDoc cd) {
        return cd instanceof AspectDoc ? "aspect" : (cd.isInterface() ? "interface" : "class");
    }

    public static String where(ProgramElementDoc member) {
        return member.name();
    }

    public static String label(ProgramElementDoc member) {
        return member.name();
    }

    public static String where(ClassDoc cd, ProgramElementDoc member) {
        if (member instanceof AdviceDoc) {
            return Statics.name(cd, (AdviceDoc)member).replace(' ', '_').replace('#', '-');
        }
        return member.name();
    }

    public static String label(ClassDoc cd, ProgramElementDoc member) {
        return Statics.name(cd, member);
    }

    public static String name(ClassDoc cd, ProgramElementDoc member) {
        if (member instanceof AdviceDoc) {
            return Statics.name(cd, (AdviceDoc)member);
        }
        return member.name();
    }

    public static String name(ClassDoc cd, AdviceDoc advice) {
        String name = advice.name();
        int num = 1;
        Iterator i = Statics.advice(cd).iterator();
        while (i.hasNext()) {
            AdviceDoc ad = (AdviceDoc)i.next();
            if (ad.equals(advice)) break;
            if (!ad.name().equals(name)) continue;
            ++num;
        }
        return name + " #" + num;
    }

    public static List advice(ClassDoc classdoc) {
        if (!(classdoc instanceof AspectDoc)) {
            return Collections.EMPTY_LIST;
        }
        ProgramElementDoc[] advice = ((AspectDoc)classdoc).advice();
        return advice == null ? Collections.EMPTY_LIST : Util.asList((ProgramElementDoc[])advice);
    }

    public static ClassDoc[] classes(ClassDoc[] arr) {
        ArrayList<ClassDoc> list = new ArrayList<ClassDoc>();
        int i = 0;
        while (i < arr.length) {
            if (!(arr[i] instanceof AspectDoc)) {
                list.add(arr[i]);
            }
            ++i;
        }
        return list.toArray(new ClassDoc[list.size()]);
    }

    public static List classes(List types) {
        return Statics.types(types, false);
    }

    public static List aspects(List types) {
        return Statics.types(types, true);
    }

    public static List types(List types, boolean wantAspects) {
        ArrayList<ClassDoc> list = new ArrayList<ClassDoc>();
        Iterator i = types.iterator();
        while (i.hasNext()) {
            ClassDoc cd = (ClassDoc)i.next();
            if (cd instanceof AspectDoc != wantAspects) continue;
            list.add(cd);
        }
        return list;
    }

    public static String getPreQualifiedClassLink(SubWriterHolderWriter writer, ClassDoc cd, String where) {
        return writer.getPkgName(cd) + writer.getClassLink(cd, where, cd.name());
    }

    public static void printPreQualifiedClassLink(SubWriterHolderWriter writer, ClassDoc cd, String where) {
        writer.print(Statics.getPreQualifiedClassLink(writer, cd, where));
    }
}

