/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ide;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.aspectj.tools.ide.SymbolManager;

public class Declaration
implements Serializable {
    private int beginLine;
    private int endLine;
    private int beginColumn;
    private int endColumn;
    private String modifiers;
    private String fullSignature;
    private String signature;
    private String crosscutDesignator;
    private String packageName;
    private String kind;
    private String declaringType;
    private String filename;
    private String formalComment;
    private Declaration[] declarations;
    private Handle crosscutDeclarationHandle;
    private Handle[] pointedToByHandles;
    private Handle[] pointsToHandles;
    private transient Declaration crosscutDeclaration;
    private transient Declaration[] pointedToBy = null;
    private transient Declaration[] pointsTo = null;
    private Declaration parentDeclaration = null;

    public Declaration(int beginLine, int endLine, int beginColumn, int endColumn, String modifiers, String signature, String fullSignature, String crosscutDesignator, String declaringType, String kind, String filename, String formalComment, String packageName) {
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginColumn = beginColumn;
        this.endColumn = endColumn;
        this.modifiers = modifiers;
        this.signature = signature;
        this.fullSignature = fullSignature;
        this.crosscutDesignator = crosscutDesignator;
        this.declaringType = declaringType;
        this.kind = kind;
        this.filename = filename;
        this.formalComment = formalComment;
        this.packageName = packageName;
        this.pointedToByHandles = new Handle[0];
        this.pointsToHandles = new Handle[0];
        this.declarations = new Declaration[0];
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public String getFullSignature() {
        return this.fullSignature;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getCrosscutDesignator() {
        return this.crosscutDesignator;
    }

    public Declaration getParentDeclaration() {
        return this.parentDeclaration;
    }

    public Declaration getCrosscutDeclaration() {
        if (this.crosscutDeclaration == null && this.crosscutDeclarationHandle != null) {
            this.crosscutDeclaration = this.crosscutDeclarationHandle.resolve();
        }
        return this.crosscutDeclaration;
    }

    public void setCrosscutDeclaration(Declaration _crosscutDeclaration) {
        this.crosscutDeclaration = _crosscutDeclaration;
    }

    public String getDeclaringType() {
        return this.declaringType;
    }

    public String getKind() {
        if (this.kind.startsWith("introduced-")) {
            return this.kind.substring(11);
        }
        return this.kind;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFormalComment() {
        return this.formalComment;
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(Declaration[] decs) {
        this.declarations = decs;
        if (decs != null) {
            int i = 0;
            while (i < decs.length) {
                decs[i].parentDeclaration = this;
                ++i;
            }
        }
    }

    public void setPointedToBy(Declaration[] decs) {
        this.pointedToBy = decs;
    }

    public void setPointsTo(Declaration[] decs) {
        this.pointsTo = decs;
    }

    public Declaration[] getPointedToBy() {
        if (this.pointedToBy == null) {
            this.pointedToBy = this.resolveHandles(this.pointedToByHandles);
        }
        return this.pointedToBy;
    }

    public Declaration[] getPointsTo() {
        if (this.pointsTo == null) {
            this.pointsTo = this.resolveHandles(this.pointsToHandles);
        }
        return this.pointsTo;
    }

    private Declaration[] filterTypes(Declaration[] a_decs) {
        LinkedList<Declaration> decs = new LinkedList<Declaration>(Arrays.asList(a_decs));
        Iterator i = decs.iterator();
        while (i.hasNext()) {
            Declaration dec = (Declaration)i.next();
            if (dec.isType()) continue;
            i.remove();
        }
        return decs.toArray(new Declaration[decs.size()]);
    }

    public Declaration[] getTargets() {
        Declaration[] pointsTo = this.getPointsTo();
        if (this.kind.equals("advice")) {
            return pointsTo;
        }
        if (this.kind.equals("introduction")) {
            return this.filterTypes(pointsTo);
        }
        return new Declaration[0];
    }

    private Handle getHandle() {
        return new Handle(this.filename, this.beginLine, this.beginColumn);
    }

    private Declaration[] resolveHandles(Handle[] handles) {
        Declaration[] declarations = new Declaration[handles.length];
        int missed = 0;
        int i = 0;
        while (i < handles.length) {
            declarations[i] = handles[i].resolve();
            if (declarations[i] == null) {
                ++missed;
            }
            ++i;
        }
        if (missed > 0) {
            Declaration[] decs = new Declaration[declarations.length - missed];
            int i2 = 0;
            int j = 0;
            while (i2 < declarations.length) {
                if (declarations[i2] != null) {
                    decs[j++] = declarations[i2];
                }
                ++i2;
            }
            declarations = decs;
        }
        return declarations;
    }

    private Handle[] getHandles(Declaration[] declarations) {
        Handle[] handles = new Handle[declarations.length];
        int i = 0;
        while (i < declarations.length) {
            handles[i] = declarations[i].getHandle();
            ++i;
        }
        return handles;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.pointedToByHandles = this.getHandles(this.getPointedToBy());
        this.pointsToHandles = this.getHandles(this.getPointsTo());
        if (this.crosscutDeclaration != null) {
            this.crosscutDeclarationHandle = this.crosscutDeclaration.getHandle();
        }
        out.defaultWriteObject();
    }

    public Declaration[] getCrosscutDeclarations() {
        return this.getDeclarationsHelper("pointcut");
    }

    public Declaration[] getAdviceDeclarations() {
        return this.getDeclarationsHelper("advice");
    }

    public Declaration[] getIntroductionDeclarations() {
        return this.getDeclarationsHelper("introduction");
    }

    private Declaration[] getDeclarationsHelper(String kind) {
        Declaration[] decls = this.getDeclarations();
        ArrayList<Declaration> result = new ArrayList<Declaration>();
        int i = 0;
        while (i < decls.length) {
            Declaration decl = decls[i];
            if (decl.getKind().equals(kind)) {
                result.add(decl);
            }
            ++i;
        }
        return result.toArray(new Declaration[result.size()]);
    }

    public boolean isType() {
        return this.getKind().equals("interface") || this.getKind().equals("class");
    }

    public boolean hasBody() {
        String kind = this.getKind();
        return kind.equals("class") || kind.endsWith("constructor") || kind.endsWith("method") && this.getModifiers().indexOf("abstract") == -1 && this.getModifiers().indexOf("native") == -1;
    }

    public boolean isIntroduced() {
        return this.kind.startsWith("introduced-");
    }

    public boolean hasSignature() {
        String kind = this.getKind();
        return kind.equals("class") || kind.equals("interface") || kind.equals("initializer") || kind.equals("field") || kind.equals("constructor") || kind.equals("method");
    }

    private static class Handle
    implements Serializable {
        public String filename;
        public int line;
        public int column;

        public Handle(String filename, int line, int column) {
            this.filename = filename;
            this.line = line;
            this.column = column;
        }

        public Declaration resolve() {
            SymbolManager manager = SymbolManager.getSymbolManager();
            return manager.getDeclarationAtPoint(this.filename, this.line, this.column);
        }
    }
}

