/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigFileUtil {
    private static final File USERDIR;
    private static final File DOTDIR;
    private static final FileFilter SOURCEFILTER;

    public static List getLstFilesInDir(String dirPath) {
        ArrayList<String> configs = new ArrayList<String>();
        File f = new File(dirPath);
        File[] dirContents = f.listFiles();
        int j = 0;
        while (j < dirContents.length) {
            if (dirContents[j].isDirectory()) {
                configs.addAll(ConfigFileUtil.getLstFilesInDir(dirContents[j].getAbsolutePath()));
            } else if (dirContents[j].getName().endsWith(".lst")) {
                configs.add(dirContents[j].getAbsolutePath().replace('\\', '/'));
            }
            ++j;
        }
        return configs;
    }

    public static File qualifiedFile(String name, File currentWorkingDir) throws IOException {
        File file = new File(name = name.replace('/', File.separatorChar));
        if (!file.isAbsolute()) {
            if (null == currentWorkingDir) {
                currentWorkingDir = USERDIR;
            }
            file = new File(currentWorkingDir, name).getAbsoluteFile();
        }
        return file.getCanonicalFile();
    }

    public static List expandLstFile(String filename) throws IOException, LstFileEntryInvalidException {
        return ConfigFileUtil.expandLstFile(filename, null);
    }

    public static List expandLstFile(String filename, File relativeTo) throws IOException, LstFileEntryInvalidException {
        ArrayList fileContents = new ArrayList();
        ConfigFileUtil.expandAtFile(ConfigFileUtil.qualifiedFile(filename, relativeTo), fileContents, null);
        return fileContents;
    }

    /*
     * WARNING - void declaration
     */
    private static void expandAtFile(File file, List args, List atFiles) throws IOException, LstFileEntryInvalidException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(file));
        File parentDir = null == file ? null : file.getParentFile();
        while ((line = in.readLine()) != null) {
            File newfile;
            void var5_5;
            if (var5_5 == null || var5_5.length() < 1 || (line = var5_5.trim()).startsWith("//")) continue;
            int indexStarJava = line.lastIndexOf("*.java");
            int indexStar = line.lastIndexOf("*");
            String dirName = null;
            if (indexStarJava != -1) {
                dirName = line.substring(0, indexStarJava);
            } else if (indexStar != -1) {
                dirName = line.substring(0, indexStar);
            }
            if (dirName != null) {
                File newDirFile = ConfigFileUtil.qualifiedFile(dirName, parentDir);
                File[] javafiles = newDirFile.listFiles(SOURCEFILTER);
                if (javafiles == null) {
                    ConfigFileUtil.cantResolve(newDirFile, "unable to file java files in wildcard directory " + newDirFile.getPath());
                    continue;
                }
                int i = 0;
                while (i < javafiles.length) {
                    if (!ConfigFileUtil.maybeAdd(javafiles[i], args)) {
                        ConfigFileUtil.cantResolve(javafiles[i], "unable to add wildcard to collection");
                    }
                    ++i;
                }
                continue;
            }
            if (line.startsWith("@")) {
                newfile = ConfigFileUtil.qualifiedFile(line.substring(1).trim(), parentDir);
                if (!newfile.exists()) {
                    ConfigFileUtil.cantResolve(newfile, "@file does not exist");
                    continue;
                }
                String filePath = newfile.getCanonicalPath().intern();
                if (null == atFiles) {
                    atFiles = new ArrayList<String>();
                    atFiles.add(file.getCanonicalPath().intern());
                }
                if (atFiles.contains(filePath)) continue;
                atFiles.add(filePath);
                ConfigFileUtil.expandAtFile(newfile, args, atFiles);
                continue;
            }
            newfile = ConfigFileUtil.qualifiedFile(line, parentDir);
            if (newfile.exists()) {
                if (ConfigFileUtil.maybeAdd(newfile, args)) continue;
                ConfigFileUtil.cantResolve(newfile, "unable to add to collection");
                continue;
            }
            if (!newfile.getName().equals("*.java") && !newfile.getName().equals("*")) {
                ConfigFileUtil.cantResolve(newfile, "expecting @{listFile}, *, *.java, or {path}.java");
                continue;
            }
            ConfigFileUtil.cantResolve(newfile, "unable to find file " + newfile);
        }
        in.close();
    }

    private static void cantResolve(File file, String reason) throws LstFileEntryInvalidException {
        throw new LstFileEntryInvalidException(file.getAbsolutePath(), -1, reason);
    }

    private static void cantResolve(File file) throws LstFileEntryInvalidException {
        throw new LstFileEntryInvalidException(file.getAbsolutePath(), -1);
    }

    private static boolean maybeAdd(File file, Collection files) {
        if (ConfigFileUtil.isJavaFile(file)) {
            files.add(file.getAbsolutePath());
            return true;
        }
        return false;
    }

    private static boolean isJavaFile(File file) {
        return file != null && file.exists() && !file.isDirectory() && file.getName().endsWith(".java");
    }

    static {
        File userDir = null;
        File dotDir = null;
        try {
            try {
                dotDir = new File(".");
                userDir = new File(System.getProperty("user.dir")).getCanonicalFile();
            }
            catch (Throwable t) {
                if (null == userDir) {
                    userDir = dotDir;
                }
                Object var4_3 = null;
                DOTDIR = dotDir;
                USERDIR = userDir;
            }
            Object var4_2 = null;
            DOTDIR = dotDir;
            USERDIR = userDir;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DOTDIR = dotDir;
            USERDIR = userDir;
            throw throwable;
        }
        SOURCEFILTER = new FileFilter(){

            public boolean accept(File f) {
                return f != null && f.getName().endsWith(".java");
            }
        };
    }

    public static class LstFileEntryInvalidException
    extends Exception {
        public final String lstFile;
        public final int lineNumber;

        public LstFileEntryInvalidException(String lstFile, int lineNumber) {
            this(lstFile, lineNumber, "");
        }

        public LstFileEntryInvalidException(String lstFile, int lineNumber, String reason) {
            super("" + lstFile + ":" + lineNumber + ": " + reason + " (invalid entry - expecting *.java or {path}.java or @{listFile})");
            this.lstFile = lstFile;
            this.lineNumber = lineNumber;
        }
    }
}

