/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class ConfigParser {
    Location location;
    protected List files = new LinkedList();
    private boolean fileParsed = false;

    public List getFiles() {
        return this.files;
    }

    public void parseCommandLine(String[] argsArray) throws ParseException {
        this.location = new CommandLineLocation();
        LinkedList<Arg> args = new LinkedList<Arg>();
        int i = 0;
        while (i < argsArray.length) {
            args.add(new Arg(argsArray[i], this.location));
            ++i;
        }
        this.parseArgs(args);
    }

    public void parseConfigFile(File configFile) throws ParseException {
        if (this.fileParsed) {
            throw new ParseException("The file has already been parsed.", null);
        }
        this.parseConfigFileHelper(configFile);
    }

    private void parseConfigFileHelper(File configFile) {
        if (!configFile.exists()) {
            this.showError("file does not exist: " + configFile.getPath());
            return;
        }
        LinkedList<Arg> args = new LinkedList<Arg>();
        int lineNum = 0;
        try {
            BufferedReader stream = new BufferedReader(new FileReader(configFile));
            String line = null;
            while ((line = stream.readLine()) != null) {
                ++lineNum;
                if ((line = this.stripWhitespaceAndComments(line)).length() == 0) continue;
                args.add(new Arg(line, new SourceLocation(configFile, lineNum)));
            }
        }
        catch (IOException e) {
            this.location = new SourceLocation(configFile, lineNum);
            this.showError("error reading config file: " + e.toString());
        }
        this.parseArgs(args);
        this.fileParsed = true;
    }

    File getCurrentDir() {
        return this.location.getDirectory();
    }

    String stripSingleLineComment(String s, String commentString) {
        int commentStart = s.indexOf(commentString);
        if (commentStart == -1) {
            return s;
        }
        return s.substring(0, commentStart);
    }

    String stripWhitespaceAndComments(String s) {
        s = this.stripSingleLineComment(s, "//");
        s = this.stripSingleLineComment(s, "#");
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected void addFile(File sourceFile) {
        if (!sourceFile.isFile()) {
            this.showError("source file does not exist: " + sourceFile.getPath());
        }
        this.files.add(sourceFile);
    }

    void addFileOrPattern(File sourceFile) {
        if (sourceFile.getName().equals("*.java")) {
            this.addFiles(sourceFile.getParentFile(), new FileFilter(){

                public boolean accept(File f) {
                    return f != null && f.getName().endsWith(".java");
                }
            });
        } else if (sourceFile.getName().equals("*.aj")) {
            this.addFiles(sourceFile.getParentFile(), new FileFilter(){

                public boolean accept(File f) {
                    return f != null && f.getName().endsWith(".aj");
                }
            });
        } else {
            this.addFile(sourceFile);
        }
    }

    void addFiles(File dir, FileFilter filter) {
        File[] files;
        if (dir == null) {
            dir = new File(".");
        }
        if (!dir.isDirectory()) {
            this.showError("can't find " + dir.getPath());
        }
        if ((files = dir.listFiles(filter)).length == 0) {
            this.showWarning("no matching files found in: " + dir);
        }
        int i = 0;
        while (i < files.length) {
            this.addFile(files[i]);
            ++i;
        }
    }

    protected void parseOption(String arg, LinkedList args) {
        this.showWarning("unrecognized option: " + arg);
    }

    protected void showWarning(String message) {
        if (this.location != null) {
            message = message + " at " + this.location.toString();
        }
        System.err.println(message);
    }

    protected void showError(String message) {
        throw new ParseException(message, this.location);
    }

    void parseArgs(LinkedList args) {
        while (args.size() > 0) {
            this.parseOneArg(args);
        }
    }

    protected Arg removeArg(LinkedList args) {
        if (args.size() == 0) {
            this.showError("value missing");
            return null;
        }
        return (Arg)args.removeFirst();
    }

    protected String removeStringArg(LinkedList args) {
        Arg arg = this.removeArg(args);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    boolean isSourceFileName(String s) {
        if (s.endsWith(".java")) {
            return true;
        }
        if (s.endsWith(".aj")) {
            return true;
        }
        if (s.endsWith(".ajava")) {
            this.showWarning(".ajava is deprecated, replace with .aj or .java: " + s);
            return true;
        }
        return false;
    }

    void parseOneArg(LinkedList args) {
        Arg arg = this.removeArg(args);
        String v = arg.getValue();
        this.location = arg.getLocation();
        if (v.startsWith("@")) {
            this.parseImportedConfigFile(v.substring(1));
        } else if (v.equals("-argfile")) {
            this.parseConfigFileHelper(this.makeFile(this.removeArg(args).getValue()));
        } else if (this.isSourceFileName(v)) {
            this.addFileOrPattern(this.makeFile(v));
        } else {
            this.parseOption(arg.getValue(), args);
        }
    }

    protected void parseImportedConfigFile(String relativeFilePath) {
        this.parseConfigFileHelper(this.makeFile(relativeFilePath));
    }

    public File makeFile(String name) {
        return this.makeFile(this.getCurrentDir(), name);
    }

    File makeFile(File dir, String name) {
        name = name.replace('/', File.separatorChar);
        File ret = new File(name);
        if (dir == null || ret.isAbsolute()) {
            return ret;
        }
        return new File(dir, name);
    }

    public static class ParseException
    extends RuntimeException {
        private Location location;

        public ParseException(String message, Location location) {
            super(message);
            this.location = location;
        }

        public int getLine() {
            if (this.location == null) {
                return -1;
            }
            return this.location.getLine();
        }

        public File getFile() {
            if (this.location == null) {
                return null;
            }
            return this.location.getFile();
        }
    }

    static class CommandLineLocation
    extends Location {
        CommandLineLocation() {
        }

        public File getFile() {
            return new File(".");
        }

        public File getDirectory() {
            return new File(".");
        }

        public int getLine() {
            return -1;
        }

        public String toString() {
            return "command-line";
        }
    }

    static class SourceLocation
    extends Location {
        private int line;
        private File file;

        public SourceLocation(File file, int line) {
            this.line = line;
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public File getDirectory() {
            return this.file.getParentFile();
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.file.getPath() + ":" + this.line;
        }
    }

    static abstract class Location {
        Location() {
        }

        public abstract File getFile();

        public abstract File getDirectory();

        public abstract int getLine();

        public abstract String toString();
    }

    protected static class Arg {
        private Location location;
        private String value;

        public Arg(String value, Location location) {
            this.value = value;
            this.location = location;
        }

        public String getValue() {
            return this.value;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

