/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.File;
import java.util.Vector;

public class LineNumberTableMapper {
    private static final char PACKAGE_SEPARATOR = '/';
    private static final char FILE_SEPARATOR = ';';
    private File[] files;
    private int[] offsets;

    public LineNumberTableMapper(String attrib, String pkg, File root) {
        int len = attrib.length();
        int i = attrib.indexOf(59);
        if (i == -1) {
            this.files = new File[]{LineNumberTableMapper.buildFile(root, pkg == null ? attrib : pkg + '/' + attrib)};
            this.offsets = new int[]{0};
        } else {
            Vector<String> strings = new Vector<String>();
            Vector<Integer> ints = new Vector<Integer>();
            strings.add(attrib.substring(0, i));
            ints.add(new Integer(0));
            while (i != -1) {
                int start;
                int end = (i = attrib.indexOf(59, start = ++i)) == -1 ? len : i;
                --end;
                --end;
                int accumulator = 0;
                int power = 1;
                char c = attrib.charAt(--end);
                while (c != '(') {
                    accumulator += Character.digit(c, 10) * power;
                    power *= 10;
                    c = attrib.charAt(--end);
                }
                strings.add(attrib.substring(start, end));
                ints.add(new Integer(accumulator * 1000));
            }
            int size = strings.size();
            this.files = new File[size];
            this.offsets = new int[size];
            int j = 0;
            while (j < size) {
                this.files[j] = LineNumberTableMapper.buildFile(root, (String)strings.get(j));
                this.offsets[j] = (Integer)ints.get(j);
                ++j;
            }
        }
    }

    private static File buildFile(File root, String path) {
        int i = 0;
        int j = path.indexOf(47);
        while (j != -1) {
            root = new File(root, path.substring(i, j));
            i = j + 1;
            j = path.indexOf(47, i);
        }
        return new File(root, path.substring(i, path.length()));
    }

    public File getCorrespondingFile(int n) {
        int end = this.files.length - 1;
        int i = 1;
        while (i <= end) {
            if (n < this.offsets[i]) {
                return this.files[i - 1];
            }
            ++i;
        }
        return this.files[end];
    }

    public int getCorrespondingLineNumber(int n) {
        int end = this.offsets.length - 1;
        int i = 1;
        while (i <= end) {
            if (n < this.offsets[i]) {
                return n - this.offsets[i - 1];
            }
            ++i;
        }
        return n - this.offsets[end];
    }

    public int getCorrespondingLineNumber(File f, int n) {
        int i = 0;
        int len = this.files.length;
        while (i < len) {
            if (f.equals(this.files[i])) {
                return this.offsets[i] + n;
            }
            ++i;
        }
        throw new IllegalArgumentException("No code from " + f + " in this classfile");
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.files.length - 1) {
            s = s + this.offsets[i] + " " + this.files[i] + ":";
            ++i;
        }
        s = s + this.offsets[this.files.length - 1] + " " + this.files[this.files.length - 1];
        return s;
    }

    public static void main(String[] args) {
        System.err.println(new LineNumberTableMapper(args[0], "", new File(".")));
    }
}

