/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class UnicodeEscapeWriter
extends Writer {
    protected OutputStream outputStream;
    protected byte[] buffer;
    protected static final int bufferSize = 2048;
    protected int index;
    protected boolean addSlash;

    public UnicodeEscapeWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.buffer = new byte[2064];
        this.index = 0;
        this.addSlash = false;
    }

    public void write(int ch) throws IOException {
        if (this.addSlash && ch == 117) {
            this.buffer[this.index++] = 92;
        }
        this.addSlash = ch == 92 ? !this.addSlash : false;
        if (ch < 1 || ch > 126) {
            int b1 = ch >> 12;
            int b2 = ch >> 8 & 0xF;
            int b3 = ch >> 4 & 0xF;
            int b4 = ch & 0xF;
            this.buffer[this.index++] = 92;
            this.buffer[this.index++] = 117;
            this.buffer[this.index++] = (byte)Character.forDigit(b1, 16);
            this.buffer[this.index++] = (byte)Character.forDigit(b2, 16);
            this.buffer[this.index++] = (byte)Character.forDigit(b3, 16);
            this.buffer[this.index++] = (byte)Character.forDigit(b4, 16);
        } else {
            this.buffer[this.index++] = (byte)ch;
        }
        if (this.index >= 2048) {
            this.flushBuffer();
        }
    }

    public void flushBuffer() throws IOException {
        this.outputStream.write(this.buffer, 0, this.index);
        this.index = 0;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int index = 0;
        while (index < len) {
            this.write(cbuf[off + index++]);
        }
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.outputStream.flush();
    }

    public static void main(String[] args) throws IOException {
        UnicodeEscapeWriter writer = new UnicodeEscapeWriter(System.out);
        writer.write("x = '\u0000'; y = '23\u1234\uabcd'\n");
        writer.write("\\uxxxx");
        writer.flush();
    }
}

