/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.bridge.IMessage;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerSingleton;

public class EclipseSourceType
extends ResolvedTypeX.ConcreteName {
    protected ResolvedPointcutDefinition[] declaredPointcuts = null;
    protected ResolvedMember[] declaredMethods = null;
    protected ResolvedMember[] declaredFields = null;
    public List declares = new ArrayList();
    public List typeMungers = new ArrayList();
    private EclipseFactory factory;
    private SourceTypeBinding binding;
    private TypeDeclaration declaration;

    protected EclipseFactory eclipseWorld() {
        return this.factory;
    }

    public EclipseSourceType(ResolvedTypeX.Name resolvedTypeX, EclipseFactory factory, SourceTypeBinding binding, TypeDeclaration declaration) {
        super(resolvedTypeX, true);
        this.factory = factory;
        this.binding = binding;
        this.declaration = declaration;
        resolvedTypeX.setSourceContext(new EclipseSourceContext(declaration.compilationResult));
        resolvedTypeX.setStartPos(declaration.sourceStart);
        resolvedTypeX.setEndPos(declaration.sourceEnd);
    }

    public boolean isAspect() {
        return this.declaration instanceof AspectDeclaration;
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    public ResolvedTypeX getSuperclass() {
        if (this.binding.isInterface()) {
            return this.getResolvedTypeX().getWorld().getCoreType(TypeX.OBJECT);
        }
        return this.eclipseWorld().fromEclipse(this.binding.superclass());
    }

    public ResolvedTypeX[] getDeclaredInterfaces() {
        return this.eclipseWorld().fromEclipse(this.binding.superInterfaces());
    }

    protected void fillDeclaredMembers() {
        ArrayList<ResolvedPointcutDefinition> declaredPointcuts = new ArrayList<ResolvedPointcutDefinition>();
        ArrayList<ResolvedMember> declaredMethods = new ArrayList<ResolvedMember>();
        ArrayList<ResolvedMember> declaredFields = new ArrayList<ResolvedMember>();
        this.binding.methods();
        AbstractMethodDeclaration[] methods = this.declaration.methods;
        if (methods != null) {
            int i = 0;
            int len = methods.length;
            while (i < len) {
                AbstractMethodDeclaration amd = methods[i];
                if (amd != null && !amd.ignoreFurtherInvestigation) {
                    if (amd instanceof PointcutDeclaration) {
                        PointcutDeclaration d = (PointcutDeclaration)amd;
                        ResolvedPointcutDefinition df = d.makeResolvedPointcutDefinition();
                        declaredPointcuts.add(df);
                    } else if (!(amd instanceof InterTypeDeclaration) && !(amd instanceof DeclareDeclaration) && !(amd instanceof AdviceDeclaration) && amd.binding != null && amd.binding.isValidBinding()) {
                        declaredMethods.add(EclipseFactory.makeResolvedMember(amd.binding));
                    }
                }
                ++i;
            }
        }
        FieldBinding[] fields = this.binding.fields();
        int i = 0;
        int len = fields.length;
        while (i < len) {
            FieldBinding f = fields[i];
            declaredFields.add(EclipseFactory.makeResolvedMember(f));
            ++i;
        }
        this.declaredPointcuts = declaredPointcuts.toArray(new ResolvedPointcutDefinition[declaredPointcuts.size()]);
        this.declaredMethods = declaredMethods.toArray(new ResolvedMember[declaredMethods.size()]);
        this.declaredFields = declaredFields.toArray(new ResolvedMember[declaredFields.size()]);
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.declaredFields == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredFields;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.declaredMethods == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredMethods;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.declaredPointcuts == null) {
            this.fillDeclaredMembers();
        }
        return this.declaredPointcuts;
    }

    public int getModifiers() {
        return this.binding.modifiers & 0xFFFF;
    }

    public String toString() {
        return "EclipseSourceType(" + new String(this.binding.sourceName()) + ")";
    }

    public void checkPointcutDeclarations() {
        ResolvedMember[] pointcuts = this.getDeclaredPointcuts();
        boolean sawError = false;
        int i = 0;
        int len = pointcuts.length;
        while (i < len) {
            if (pointcuts[i].isAbstract()) {
                if (!this.isAspect()) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "abstract pointcut only allowed in aspect" + pointcuts[i].getName(), pointcuts[i].getSourceLocation(), null);
                    sawError = true;
                } else if (!this.binding.isAbstract()) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "abstract pointcut in concrete aspect" + pointcuts[i], pointcuts[i].getSourceLocation(), null);
                    sawError = true;
                }
            }
            int j = i + 1;
            while (j < len) {
                if (pointcuts[i].getName().equals(pointcuts[j].getName())) {
                    this.eclipseWorld().showMessage(IMessage.ERROR, "duplicate pointcut name: " + pointcuts[j].getName(), pointcuts[i].getSourceLocation(), pointcuts[j].getSourceLocation());
                    sawError = true;
                }
                ++j;
            }
            ++i;
        }
        if (sawError || !this.isAspect()) {
            return;
        }
        this.getResolvedTypeX().getExposedPointcuts();
    }

    public boolean isInterface() {
        return this.binding.isInterface();
    }

    public PerClause getPerClause() {
        return new PerSingleton();
    }

    protected Collection getDeclares() {
        return this.declares;
    }

    protected Collection getPrivilegedAccesses() {
        return Collections.EMPTY_LIST;
    }

    protected Collection getTypeMungers() {
        return this.typeMungers;
    }

    public boolean doesNotExposeShadowMungers() {
        return true;
    }
}

