/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.FieldOrMethod;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.Visitor;
import org.aspectj.apache.bcel.generic.Type;

public final class Method
extends FieldOrMethod {
    public Method() {
    }

    public Method(Method c) {
        super(c);
    }

    Method(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public Method(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitMethod(this);
    }

    public final Code getCode() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof Code)) continue;
            return (Code)this.attributes[i];
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        for (int i = 0; i < this.attributes_count; ++i) {
            if (!(this.attributes[i] instanceof ExceptionTable)) continue;
            return (ExceptionTable)this.attributes[i];
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLocalVariableTable();
        }
        return null;
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code != null) {
            return code.getLineNumberTable();
        }
        return null;
    }

    public final String toString() {
        String str;
        String access = Utility.accessToString(this.access_flags);
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuffer buf = new StringBuffer(signature);
        for (int i = 0; i < this.attributes_count; ++i) {
            Attribute a = this.attributes[i];
            if (a instanceof Code || a instanceof ExceptionTable) continue;
            buf.append(" [" + a.toString() + "]");
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows " + str);
        }
        return buf.toString();
    }

    public final Method copy(ConstantPool constant_pool) {
        return (Method)this.copy_(constant_pool);
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }
}

