/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.dom;

import java.util.HashMap;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.core.dom.ASTNode;
import org.aspectj.org.eclipse.jdt.core.dom.Comment;
import org.aspectj.org.eclipse.jdt.core.dom.CompilationUnit;
import org.aspectj.org.eclipse.jdt.core.dom.DefaultASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;

class DefaultCommentMapper {
    Comment[] comments;
    HashMap leadingComments;
    HashMap trailingComments;
    Scanner scanner;

    DefaultCommentMapper(Comment[] table) {
        this.comments = table;
    }

    boolean hasSameTable(Comment[] table) {
        return this.comments == table;
    }

    Comment getComment(int position) {
        if (this.comments == null) {
            return null;
        }
        int size = this.comments.length;
        if (size == 0) {
            return null;
        }
        int index = this.getCommentIndex(0, position, 0);
        if (index < 0) {
            return null;
        }
        return this.comments[index];
    }

    private int getCommentIndex(int start, int position, int exact) {
        if (position == 0) {
            if (this.comments.length > 0 && this.comments[0].getStartPosition() == 0) {
                return 0;
            }
            return -1;
        }
        int bottom = start;
        int top = this.comments.length - 1;
        int i = 0;
        int index = -1;
        Comment comment = null;
        while (bottom <= top) {
            i = (bottom + top) / 2;
            comment = this.comments[i];
            int commentStart = comment.getStartPosition();
            if (position < commentStart) {
                top = i - 1;
                continue;
            }
            if (position >= commentStart + comment.getLength()) {
                bottom = i + 1;
                continue;
            }
            index = i;
            break;
        }
        if (index < 0 && exact != 0) {
            comment = this.comments[i];
            if (position < comment.getStartPosition()) {
                return exact < 0 ? i - 1 : i;
            }
            return exact < 0 ? i : i + 1;
        }
        return index;
    }

    Comment[] getLeadingComments(ASTNode node) {
        int[] range;
        if (this.leadingComments != null && (range = (int[])this.leadingComments.get(node)) != null) {
            int length = range[1] - range[0] + 1;
            Comment[] leadComments = new Comment[length];
            System.arraycopy(this.comments, range[0], leadComments, 0, length);
            return leadComments;
        }
        return null;
    }

    Comment[] getTrailingComments(ASTNode node) {
        int[] range;
        if (this.trailingComments != null && (range = (int[])this.trailingComments.get(node)) != null) {
            int length = range[1] - range[0] + 1;
            Comment[] trailComments = new Comment[length];
            System.arraycopy(this.comments, range[0], trailComments, 0, length);
            return trailComments;
        }
        return null;
    }

    public int getExtendedStartPosition(ASTNode node) {
        int[] range;
        if (this.leadingComments != null && (range = (int[])this.leadingComments.get(node)) != null) {
            return this.comments[range[0]].getStartPosition();
        }
        return node.getStartPosition();
    }

    public int getExtendedEnd(ASTNode node) {
        int[] range;
        int end = node.getStartPosition() + node.getLength();
        if (this.trailingComments != null && (range = (int[])this.trailingComments.get(node)) != null) {
            if (range[0] == -1 && range[1] == -1) {
                ASTNode parent = node.getParent();
                if (parent != null) {
                    return this.getExtendedEnd(parent);
                }
            } else {
                Comment lastComment = this.comments[range[1]];
                end = lastComment.getStartPosition() + lastComment.getLength();
            }
        }
        return end - 1;
    }

    public int getExtendedLength(ASTNode node) {
        return this.getExtendedEnd(node) - this.getExtendedStartPosition(node) + 1;
    }

    void initialize(CompilationUnit unit, Scanner sc) {
        this.comments = unit.optionalCommentTable;
        if (this.comments == null) {
            return;
        }
        int size = this.comments.length;
        if (size == 0) {
            return;
        }
        this.leadingComments = new HashMap();
        this.trailingComments = new HashMap();
        this.scanner = sc;
        this.scanner.linePtr = this.scanner.lineEnds.length - 1;
        this.scanner.tokenizeWhiteSpace = true;
        CommentMapperVisitor commentVisitor = new CommentMapperVisitor();
        unit.accept(commentVisitor);
    }

    int storeLeadingComments(ASTNode node, int previousEnd) {
        int nodeStart;
        int extended = nodeStart = node.getStartPosition();
        int previousEndLine = this.scanner.getLineNumber(previousEnd);
        int nodeStartLine = this.scanner.getLineNumber(nodeStart);
        int idx = this.getCommentIndex(0, nodeStart, -1);
        if (idx == -1) {
            return nodeStart;
        }
        int startIdx = -1;
        int endIdx = idx;
        int previousStart = nodeStart;
        while (idx >= 0 && previousStart >= previousEnd) {
            Comment comment = this.comments[idx];
            int commentStart = comment.getStartPosition();
            int end = commentStart + comment.getLength() - 1;
            int commentLine = this.scanner.getLineNumber(commentStart);
            if (end <= previousEnd || commentLine == previousEndLine && commentLine != nodeStartLine) break;
            if (end + 1 < previousStart) {
                this.scanner.resetTo(end + 1, previousStart);
                try {
                    int token = this.scanner.getNextToken();
                    if (token != 1000 || this.scanner.currentPosition != previousStart) {
                        if (idx != endIdx) break;
                        return nodeStart;
                    }
                }
                catch (InvalidInputException e) {
                    return nodeStart;
                }
                char[] gap = this.scanner.getCurrentIdentifierSource();
                int nbrLine = 0;
                int pos = -1;
                while ((pos = CharOperation.indexOf('\n', gap, pos + 1)) >= 0) {
                    ++nbrLine;
                }
                if (nbrLine > 1) break;
            }
            previousStart = commentStart;
            startIdx = idx--;
        }
        if (startIdx != -1) {
            int commentStart = this.comments[startIdx].getStartPosition();
            if (previousEnd < commentStart && previousEndLine != nodeStartLine) {
                int lastTokenEnd = previousEnd;
                this.scanner.resetTo(previousEnd, commentStart);
                try {
                    while (this.scanner.currentPosition != commentStart) {
                        if (this.scanner.getNextToken() == 1000) continue;
                        lastTokenEnd = this.scanner.getCurrentTokenEndPosition();
                    }
                }
                catch (InvalidInputException end) {
                    // empty catch block
                }
                int lastTokenLine = this.scanner.getLineNumber(lastTokenEnd);
                int length = this.comments.length;
                while (startIdx < length && lastTokenLine == this.scanner.getLineNumber(this.comments[startIdx].getStartPosition()) && nodeStartLine != lastTokenLine) {
                    ++startIdx;
                }
            }
            if (startIdx <= endIdx) {
                this.leadingComments.put(node, new int[]{startIdx, endIdx});
                extended = this.comments[endIdx].getStartPosition();
            }
        }
        return extended;
    }

    int storeTrailingComments(ASTNode node, int nextStart, boolean lastChild) {
        int nodeEnd = node.getStartPosition() + node.getLength() - 1;
        if (nodeEnd == nextStart) {
            this.trailingComments.put(node, new int[]{-1, -1});
            return nodeEnd;
        }
        int extended = nodeEnd;
        int nodeEndLine = this.scanner.getLineNumber(nodeEnd);
        int idx = this.getCommentIndex(0, nodeEnd, 1);
        if (idx == -1) {
            return nodeEnd;
        }
        int startIdx = idx;
        int endIdx = -1;
        int length = this.comments.length;
        int commentStart = extended + 1;
        int previousEnd = nodeEnd + 1;
        int sameLineIdx = -1;
        while (idx < length && commentStart < nextStart) {
            int commentLine;
            Comment comment = this.comments[idx];
            commentStart = comment.getStartPosition();
            if (commentStart >= nextStart) break;
            if (previousEnd < commentStart) {
                this.scanner.resetTo(previousEnd, commentStart);
                try {
                    int token = this.scanner.getNextToken();
                    if (token != 1000 || this.scanner.currentPosition != commentStart) {
                        if (idx != startIdx) break;
                        return nodeEnd;
                    }
                }
                catch (InvalidInputException e) {
                    return nodeEnd;
                }
                char[] gap = this.scanner.getCurrentIdentifierSource();
                int nbrLine = 0;
                int pos = -1;
                while ((pos = CharOperation.indexOf('\n', gap, pos + 1)) >= 0) {
                    ++nbrLine;
                }
                if (nbrLine > 1) break;
            }
            if ((commentLine = this.scanner.getLineNumber(commentStart)) == nodeEndLine) {
                sameLineIdx = idx;
            }
            previousEnd = commentStart + comment.getLength();
            endIdx = idx++;
        }
        if (endIdx != -1) {
            int previousLine;
            int nextLine;
            if (!lastChild && (nextLine = this.scanner.getLineNumber(nextStart)) - (previousLine = this.scanner.getLineNumber(previousEnd)) <= 1) {
                if (sameLineIdx == -1) {
                    return nodeEnd;
                }
                endIdx = sameLineIdx;
            }
            this.trailingComments.put(node, new int[]{startIdx, endIdx});
            extended = this.comments[endIdx].getStartPosition() + this.comments[endIdx].getLength() - 1;
        }
        return extended;
    }

    class CommentMapperVisitor
    extends DefaultASTVisitor {
        HashMap waitingSiblings = new HashMap(10);

        CommentMapperVisitor() {
        }

        protected boolean visitNode(ASTNode node) {
            ASTNode parent = node.getParent();
            int previousEnd = parent.getStartPosition();
            ASTNode sibling = (ASTNode)this.waitingSiblings.get(parent);
            if (sibling != null) {
                try {
                    previousEnd = DefaultCommentMapper.this.storeTrailingComments(sibling, node.getStartPosition(), false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                DefaultCommentMapper.this.storeLeadingComments(node, previousEnd);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.waitingSiblings.put(parent, node);
            return true;
        }

        protected void endVisitNode(ASTNode node) {
            ASTNode sibling = (ASTNode)this.waitingSiblings.get(node);
            if (sibling != null) {
                try {
                    DefaultCommentMapper.this.storeTrailingComments(sibling, node.getStartPosition() + node.getLength() - 1, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean visit(CompilationUnit node) {
            return true;
        }
    }
}

