/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.codeassist;

import java.util.Locale;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.ICompletionRequestor;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.codeassist.IExtendedCompletionRequestor;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.codeassist.RelevanceConstants;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionNodeFound;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnArgumentName;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnClassReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnExceptionReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnExplicitConstructorCall;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldName;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldType;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnImportReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnInterfaceReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnKeyword;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnLocalName;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnMessageSend;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnMethodName;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnMethodReturnType;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnPackageReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedClassReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedExceptionReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedInterfaceReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionParser;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.CompletionScanner;
import org.aspectj.org.eclipse.jdt.internal.codeassist.complete.InvalidCursorLocation;
import org.aspectj.org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.aspectj.org.eclipse.jdt.internal.codeassist.impl.Engine;
import org.aspectj.org.eclipse.jdt.internal.codeassist.impl.Keywords;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.INamingRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.InternalNamingConventions;
import org.aspectj.org.eclipse.jdt.internal.core.TypeConverter;

public final class CompletionEngine
extends Engine
implements ISearchRequestor,
TypeConstants,
TerminalTokens,
RelevanceConstants,
SuffixConstants {
    public HashtableOfObject typeCache;
    public static boolean DEBUG = false;
    private static final char[] ERROR_PATTERN = "*error*".toCharArray();
    private static final char[] EXCEPTION_PATTERN = "*exception*".toCharArray();
    private static final char[] SEMICOLON = new char[]{';'};
    private static final int SUPERTYPE = 1;
    private static final int SUBTYPE = 2;
    private static final int FIELD = 0;
    private static final int LOCAL = 1;
    private static final int ARGUMENT = 2;
    int expectedTypesPtr = -1;
    TypeBinding[] expectedTypes = new TypeBinding[1];
    int expectedTypesFilter;
    int uninterestingBindingsPtr = -1;
    Binding[] uninterestingBindings = new Binding[1];
    boolean assistNodeIsClass;
    boolean assistNodeIsException;
    boolean assistNodeIsInterface;
    IJavaProject javaProject;
    CompletionParser parser;
    ICompletionRequestor requestor;
    ProblemReporter problemReporter;
    char[] source;
    char[] completionToken;
    char[] qualifiedCompletionToken;
    boolean resolvingImports = false;
    boolean insideQualifiedReference = false;
    boolean noProposal = true;
    IProblem problem = null;
    int startPosition;
    int actualCompletionPosition;
    int endPosition;
    int offset;
    HashtableOfObject knownPkgs = new HashtableOfObject(10);
    HashtableOfObject knownTypes = new HashtableOfObject(10);
    Scanner nameScanner;
    static final char[][] baseTypes = new char[][]{"boolean".toCharArray(), "byte".toCharArray(), "char".toCharArray(), "double".toCharArray(), "float".toCharArray(), "int".toCharArray(), "long".toCharArray(), "short".toCharArray(), "void".toCharArray()};
    static final char[] classField = "class".toCharArray();
    static final char[] lengthField = "length".toCharArray();
    static final char[] cloneMethod = "clone".toCharArray();
    static final char[] THIS = "this".toCharArray();
    static final char[] THROWS = "throws".toCharArray();
    static InvocationSite FakeInvocationSite = new InvocationSite(){

        public boolean isSuperAccess() {
            return false;
        }

        public boolean isTypeAccess() {
            return false;
        }

        public void setActualReceiverType(ReferenceBinding receiverType) {
        }

        public void setDepth(int depth) {
        }

        public void setFieldIndex(int depth) {
        }

        public int sourceStart() {
            return 0;
        }

        public int sourceEnd() {
            return 0;
        }
    };

    public CompletionEngine(ISearchableNameEnvironment nameEnvironment, ICompletionRequestor requestor, Map settings, IJavaProject javaProject) {
        super(settings);
        this.javaProject = javaProject;
        this.requestor = requestor;
        this.nameEnvironment = nameEnvironment;
        this.typeCache = new HashtableOfObject(5);
        this.problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory(Locale.getDefault()){
            int lastErrorStart;

            public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int start, int end, int lineNumber) {
                IProblem pb = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, start, end, lineNumber);
                if (CompletionEngine.this.actualCompletionPosition > start && this.lastErrorStart < start && pb.isError() && (pb.getID() & 0x40000000) == 0) {
                    CompletionEngine.this.problem = pb;
                    this.lastErrorStart = start;
                }
                return pb;
            }
        });
        this.lookupEnvironment = new LookupEnvironment(this, this.compilerOptions, this.problemReporter, nameEnvironment);
        this.parser = new CompletionParser(this.problemReporter);
        this.nameScanner = new Scanner(false, false, false, this.compilerOptions.sourceLevel, null, null, true);
    }

    public void acceptClass(char[] packageName, char[] className, int modifiers) {
        char[] fullyQualifiedName = CharOperation.concat(packageName, className, '.');
        char[] completionName = fullyQualifiedName;
        if (this.knownTypes.containsKey(completionName)) {
            return;
        }
        this.knownTypes.put(completionName, this);
        boolean isQualified = true;
        int relevance = this.computeBaseRelevance();
        relevance += this.computeRelevanceForInterestingProposal();
        if (this.resolvingImports) {
            completionName = CharOperation.concat(completionName, SEMICOLON);
            relevance += this.computeRelevanceForCaseMatching(this.completionToken, fullyQualifiedName);
        } else {
            if (this.mustQualifyType(packageName, className)) {
                if ((packageName == null || packageName.length == 0) && this.unitScope != null && this.unitScope.fPackage.compoundName != CharOperation.NO_CHAR_CHAR) {
                    return;
                }
            } else {
                completionName = className;
                isQualified = false;
            }
            relevance += this.computeRelevanceForCaseMatching(this.completionToken, className);
            relevance += this.computeRelevanceForExpectingType(packageName, className);
            relevance += this.computeRelevanceForClass();
            relevance += this.computeRelevanceForException(className);
            relevance += this.computeRelevanceForQualification(isQualified);
        }
        this.noProposal = false;
        this.requestor.acceptClass(packageName, className, completionName, modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance);
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, int modifiers) {
        char[] fullyQualifiedName = CharOperation.concat(packageName, interfaceName, '.');
        char[] completionName = fullyQualifiedName;
        if (this.knownTypes.containsKey(completionName)) {
            return;
        }
        this.knownTypes.put(completionName, this);
        boolean isQualified = true;
        int relevance = this.computeBaseRelevance();
        relevance += this.computeRelevanceForInterestingProposal();
        if (this.resolvingImports) {
            completionName = CharOperation.concat(completionName, new char[]{';'});
            relevance += this.computeRelevanceForCaseMatching(this.completionToken, fullyQualifiedName);
        } else {
            if (this.mustQualifyType(packageName, interfaceName)) {
                if ((packageName == null || packageName.length == 0) && this.unitScope != null && this.unitScope.fPackage.compoundName != CharOperation.NO_CHAR_CHAR) {
                    return;
                }
            } else {
                completionName = interfaceName;
                isQualified = false;
            }
            relevance += this.computeRelevanceForCaseMatching(this.completionToken, interfaceName);
            relevance += this.computeRelevanceForExpectingType(packageName, interfaceName);
            relevance += this.computeRelevanceForInterface();
            relevance += this.computeRelevanceForQualification(isQualified);
        }
        this.noProposal = false;
        this.requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance);
    }

    public void acceptPackage(char[] packageName) {
        if (this.knownPkgs.containsKey(packageName)) {
            return;
        }
        this.knownPkgs.put(packageName, this);
        int relevance = this.computeBaseRelevance();
        relevance += this.computeRelevanceForInterestingProposal();
        relevance += this.computeRelevanceForCaseMatching(this.qualifiedCompletionToken == null ? this.completionToken : this.qualifiedCompletionToken, packageName);
        this.noProposal = false;
        this.requestor.acceptPackage(packageName, this.resolvingImports ? CharOperation.concat(packageName, new char[]{'.', '*', ';'}) : packageName, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForQualification(true));
    }

    public void acceptType(char[] packageName, char[] typeName) {
        char[] fullyQualifiedName = CharOperation.concat(packageName, typeName, '.');
        char[] completionName = fullyQualifiedName;
        if (this.knownTypes.containsKey(completionName)) {
            return;
        }
        this.knownTypes.put(completionName, this);
        boolean isQualified = true;
        int relevance = this.computeBaseRelevance();
        relevance += this.computeRelevanceForInterestingProposal();
        if (this.resolvingImports) {
            completionName = CharOperation.concat(completionName, new char[]{';'});
            relevance += this.computeRelevanceForCaseMatching(this.completionToken, fullyQualifiedName);
        } else {
            if (this.mustQualifyType(packageName, typeName)) {
                if ((packageName == null || packageName.length == 0) && this.unitScope != null && this.unitScope.fPackage.compoundName != CharOperation.NO_CHAR_CHAR) {
                    return;
                }
            } else {
                completionName = typeName;
                isQualified = false;
            }
            relevance += this.computeRelevanceForCaseMatching(this.completionToken, typeName);
            relevance += this.computeRelevanceForExpectingType(packageName, typeName);
            relevance += this.computeRelevanceForQualification(isQualified);
        }
        this.noProposal = false;
        this.requestor.acceptType(packageName, typeName, completionName, this.startPosition - this.offset, this.endPosition - this.offset, relevance);
    }

    private void complete(ASTNode astNode, ASTNode astNodeParent, Binding qualifiedBinding, Scope scope) {
        this.setSourceRange(astNode.sourceStart, astNode.sourceEnd);
        this.computeUninterestingBindings(astNodeParent, scope);
        if (astNodeParent != null) {
            this.computeExpectedTypes(astNodeParent, scope);
        }
        if (astNode instanceof CompletionOnFieldType) {
            CompletionOnFieldType field = (CompletionOnFieldType)astNode;
            CompletionOnSingleTypeReference type = (CompletionOnSingleTypeReference)field.type;
            this.completionToken = type.token;
            this.setSourceRange(type.sourceStart, type.sourceEnd);
            this.findTypesAndPackages(this.completionToken, scope);
            this.findKeywordsForMember(this.completionToken, field.modifiers);
            if (!field.isLocalVariable && field.modifiers == 0) {
                this.findMethods(this.completionToken, null, scope.enclosingSourceType(), scope, new ObjectVector(), false, false, true, null, null, false, false);
                this.proposeNewMethod(this.completionToken, scope.enclosingSourceType());
            }
        } else if (astNode instanceof CompletionOnMethodReturnType) {
            CompletionOnMethodReturnType method = (CompletionOnMethodReturnType)astNode;
            CompletionOnSingleTypeReference type = (CompletionOnSingleTypeReference)method.returnType;
            this.completionToken = type.token;
            this.setSourceRange(type.sourceStart, type.sourceEnd);
            this.findTypesAndPackages(this.completionToken, scope);
            this.findKeywordsForMember(this.completionToken, method.modifiers);
            if (method.modifiers == 0) {
                this.findMethods(this.completionToken, null, scope.enclosingSourceType(), scope, new ObjectVector(), false, false, true, null, null, false, false);
                this.proposeNewMethod(this.completionToken, scope.enclosingSourceType());
            }
        } else if (astNode instanceof CompletionOnSingleNameReference) {
            CompletionOnSingleNameReference singleNameReference = (CompletionOnSingleNameReference)astNode;
            this.completionToken = singleNameReference.token;
            this.findVariablesAndMethods(this.completionToken, scope, (CompletionOnSingleNameReference)astNode, scope);
            this.findTypesAndPackages(this.completionToken, scope);
            this.findKeywords(this.completionToken, singleNameReference.possibleKeywords);
            if (singleNameReference.canBeExplicitConstructor) {
                if (CharOperation.prefixEquals(this.completionToken, Keywords.THIS, false)) {
                    SourceTypeBinding ref = scope.enclosingSourceType();
                    this.findExplicitConstructors(Keywords.THIS, ref, (MethodScope)scope, singleNameReference);
                } else if (CharOperation.prefixEquals(this.completionToken, Keywords.SUPER, false)) {
                    SourceTypeBinding ref = scope.enclosingSourceType();
                    this.findExplicitConstructors(Keywords.SUPER, ((ReferenceBinding)ref).superclass(), (MethodScope)scope, singleNameReference);
                }
            }
        } else if (astNode instanceof CompletionOnSingleTypeReference) {
            this.completionToken = ((CompletionOnSingleTypeReference)astNode).token;
            this.assistNodeIsClass = astNode instanceof CompletionOnClassReference;
            this.assistNodeIsException = astNode instanceof CompletionOnExceptionReference;
            this.assistNodeIsInterface = astNode instanceof CompletionOnInterfaceReference;
            if (qualifiedBinding == null) {
                this.findTypesAndPackages(this.completionToken, scope);
            } else {
                this.findMemberTypes(this.completionToken, (ReferenceBinding)qualifiedBinding, scope, scope.enclosingSourceType());
            }
        } else if (astNode instanceof CompletionOnQualifiedNameReference) {
            this.insideQualifiedReference = true;
            CompletionOnQualifiedNameReference ref = (CompletionOnQualifiedNameReference)astNode;
            this.completionToken = ref.completionIdentifier;
            long completionPosition = ref.sourcePositions[ref.sourcePositions.length - 1];
            if (qualifiedBinding instanceof VariableBinding) {
                this.setSourceRange((int)(completionPosition >>> 32), (int)completionPosition);
                TypeBinding receiverType = ((VariableBinding)qualifiedBinding).type;
                if (receiverType != null) {
                    this.findFieldsAndMethods(this.completionToken, receiverType, scope, ref, scope, false, false);
                }
            } else if (qualifiedBinding instanceof ReferenceBinding) {
                ReferenceBinding receiverType = (ReferenceBinding)qualifiedBinding;
                this.setSourceRange((int)(completionPosition >>> 32), (int)completionPosition);
                this.findMemberTypes(this.completionToken, receiverType, scope, scope.enclosingSourceType());
                this.findClassField(this.completionToken, (TypeBinding)qualifiedBinding, scope);
                MethodScope methodScope = null;
                if (scope instanceof MethodScope && !((MethodScope)scope).isStatic || (methodScope = scope.enclosingMethodScope()) != null && !methodScope.isStatic) {
                    if (this.completionToken.length > 0) {
                        this.findKeywords(this.completionToken, new char[][]{Keywords.THIS});
                    } else {
                        int relevance = this.computeBaseRelevance();
                        relevance += this.computeRelevanceForInterestingProposal();
                        this.noProposal = false;
                        this.requestor.acceptKeyword(Keywords.THIS, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForCaseMatching(this.completionToken, Keywords.THIS));
                    }
                }
                this.findFields(this.completionToken, receiverType, scope, new ObjectVector(), new ObjectVector(), true, ref, scope, false);
                this.findMethods(this.completionToken, null, receiverType, scope, new ObjectVector(), true, false, false, ref, scope, false, false);
            } else if (qualifiedBinding instanceof PackageBinding) {
                this.setSourceRange(astNode.sourceStart, (int)completionPosition);
                this.findTypesAndSubpackages(this.completionToken, (PackageBinding)qualifiedBinding);
            }
        } else if (astNode instanceof CompletionOnQualifiedTypeReference) {
            this.insideQualifiedReference = true;
            this.assistNodeIsClass = astNode instanceof CompletionOnQualifiedClassReference;
            this.assistNodeIsException = astNode instanceof CompletionOnQualifiedExceptionReference;
            this.assistNodeIsInterface = astNode instanceof CompletionOnQualifiedInterfaceReference;
            CompletionOnQualifiedTypeReference ref = (CompletionOnQualifiedTypeReference)astNode;
            this.completionToken = ref.completionIdentifier;
            long completionPosition = ref.sourcePositions[ref.tokens.length];
            if (qualifiedBinding instanceof ReferenceBinding) {
                this.setSourceRange((int)(completionPosition >>> 32), (int)completionPosition);
                this.findMemberTypes(this.completionToken, (ReferenceBinding)qualifiedBinding, scope, scope.enclosingSourceType());
            } else if (qualifiedBinding instanceof PackageBinding) {
                this.setSourceRange(astNode.sourceStart, (int)completionPosition);
                this.findTypesAndSubpackages(this.completionToken, (PackageBinding)qualifiedBinding);
            }
        } else if (astNode instanceof CompletionOnMemberAccess) {
            this.insideQualifiedReference = true;
            CompletionOnMemberAccess access = (CompletionOnMemberAccess)astNode;
            long completionPosition = access.nameSourcePosition;
            this.setSourceRange((int)(completionPosition >>> 32), (int)completionPosition);
            this.completionToken = access.token;
            this.findKeywords(this.completionToken, new char[][]{Keywords.NEW});
            this.findFieldsAndMethods(this.completionToken, (TypeBinding)qualifiedBinding, scope, access, scope, false, access.receiver instanceof SuperReference);
        } else if (astNode instanceof CompletionOnMessageSend) {
            this.setSourceRange(astNode.sourceStart, astNode.sourceEnd, false);
            CompletionOnMessageSend messageSend = (CompletionOnMessageSend)astNode;
            TypeBinding[] argTypes = this.computeTypes(messageSend.arguments, (BlockScope)scope);
            this.completionToken = messageSend.selector;
            if (qualifiedBinding == null) {
                this.findImplicitMessageSends(this.completionToken, argTypes, scope, messageSend, scope);
            } else {
                this.findMethods(this.completionToken, argTypes, (ReferenceBinding)qualifiedBinding, scope, new ObjectVector(), false, true, false, messageSend, scope, false, messageSend.receiver instanceof SuperReference);
            }
        } else if (astNode instanceof CompletionOnExplicitConstructorCall) {
            this.setSourceRange(astNode.sourceStart, astNode.sourceEnd, false);
            CompletionOnExplicitConstructorCall constructorCall = (CompletionOnExplicitConstructorCall)astNode;
            TypeBinding[] argTypes = this.computeTypes(constructorCall.arguments, (BlockScope)scope);
            this.findConstructors((ReferenceBinding)qualifiedBinding, argTypes, scope, constructorCall, false);
        } else if (astNode instanceof CompletionOnQualifiedAllocationExpression) {
            this.setSourceRange(astNode.sourceStart, astNode.sourceEnd, false);
            CompletionOnQualifiedAllocationExpression allocExpression = (CompletionOnQualifiedAllocationExpression)astNode;
            TypeBinding[] argTypes = this.computeTypes(allocExpression.arguments, (BlockScope)scope);
            ReferenceBinding ref = (ReferenceBinding)qualifiedBinding;
            if (ref.isClass() && !ref.isAbstract()) {
                this.findConstructors(ref, argTypes, scope, allocExpression, false);
            }
            if (!ref.isFinal()) {
                this.findAnonymousType(ref, argTypes, scope, allocExpression);
            }
        } else if (astNode instanceof CompletionOnClassLiteralAccess) {
            CompletionOnClassLiteralAccess access = (CompletionOnClassLiteralAccess)astNode;
            this.setSourceRange(access.classStart, access.sourceEnd);
            this.completionToken = access.completionIdentifier;
            this.findClassField(this.completionToken, (TypeBinding)qualifiedBinding, scope);
        } else if (astNode instanceof CompletionOnMethodName) {
            CompletionOnMethodName method = (CompletionOnMethodName)astNode;
            this.setSourceRange(method.sourceStart, method.selectorEnd);
            FieldBinding[] fields = scope.enclosingSourceType().fields();
            char[][] excludeNames = new char[fields.length][];
            int i = 0;
            while (i < fields.length) {
                excludeNames[i] = fields[i].name;
                ++i;
            }
            this.completionToken = method.selector;
            this.findVariableNames(this.completionToken, method.returnType, excludeNames, 0, method.modifiers);
        } else if (astNode instanceof CompletionOnFieldName) {
            CompletionOnFieldName field = (CompletionOnFieldName)astNode;
            FieldBinding[] fields = scope.enclosingSourceType().fields();
            char[][] excludeNames = new char[fields.length][];
            int i = 0;
            while (i < fields.length) {
                excludeNames[i] = fields[i].name;
                ++i;
            }
            this.completionToken = field.realName;
            this.findVariableNames(field.realName, field.type, excludeNames, 0, field.modifiers);
        } else if (astNode instanceof CompletionOnLocalName || astNode instanceof CompletionOnArgumentName) {
            LocalDeclaration variable = (LocalDeclaration)astNode;
            LocalVariableBinding[] locals = ((BlockScope)scope).locals;
            char[][] excludeNames = new char[locals.length][];
            int localCount = 0;
            int i = 0;
            while (i < locals.length) {
                if (locals[i] != null) {
                    excludeNames[localCount++] = locals[i].name;
                }
                ++i;
            }
            char[][] cArray = excludeNames;
            excludeNames = new char[localCount][];
            System.arraycopy(cArray, 0, excludeNames, 0, localCount);
            if (variable instanceof CompletionOnLocalName) {
                this.completionToken = ((CompletionOnLocalName)variable).realName;
                this.findVariableNames(this.completionToken, variable.type, excludeNames, 1, variable.modifiers);
            } else {
                CompletionOnArgumentName arg = (CompletionOnArgumentName)variable;
                this.completionToken = arg.realName;
                this.findVariableNames(this.completionToken, variable.type, excludeNames, arg.isCatchArgument ? 1 : 2, variable.modifiers);
            }
        } else if (astNode instanceof CompletionOnKeyword) {
            CompletionOnKeyword keyword = (CompletionOnKeyword)((Object)astNode);
            this.findKeywords(keyword.getToken(), keyword.getPossibleKeywords());
        }
    }

    public void complete(IType type, char[] snippet, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic) {
        block9: {
            IType topLevelType = type;
            while (topLevelType.getDeclaringType() != null) {
                topLevelType = topLevelType.getDeclaringType();
            }
            CompilationResult compilationResult = new CompilationResult((String.valueOf(topLevelType.getElementName()) + ".java").toCharArray(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
            CompilationUnitDeclaration compilationUnit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
            try {
                block10: {
                    TypeDeclaration typeDeclaration = TypeConverter.buildTypeDeclaration(type, compilationUnit, compilationResult);
                    if (typeDeclaration == null) break block9;
                    Initializer fakeInitializer = this.parseSnippeInitializer(snippet, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic);
                    FieldDeclaration[] oldFields = typeDeclaration.fields;
                    FieldDeclaration[] newFields = new FieldDeclaration[oldFields.length + 1];
                    System.arraycopy(oldFields, 0, newFields, 0, oldFields.length);
                    newFields[oldFields.length] = fakeInitializer;
                    typeDeclaration.fields = newFields;
                    if (DEBUG) {
                        System.out.println("SNIPPET COMPLETION AST :");
                        System.out.println(compilationUnit.toString());
                    }
                    if (compilationUnit.types != null) {
                        try {
                            this.lookupEnvironment.buildTypeBindings(compilationUnit);
                            this.unitScope = compilationUnit.scope;
                            if (this.unitScope != null) {
                                this.lookupEnvironment.completeTypeBindings(compilationUnit, true);
                                compilationUnit.scope.faultInTypes();
                                compilationUnit.resolve();
                            }
                        }
                        catch (CompletionNodeFound e) {
                            if (e.astNode == null) break block10;
                            this.complete(e.astNode, this.parser.assistNodeParent, e.qualifiedBinding, e.scope);
                        }
                    }
                }
                if (this.noProposal && this.problem != null) {
                    this.requestor.acceptError(this.problem);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private Initializer parseSnippeInitializer(char[] snippet, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic) {
        StringBuffer prefix = new StringBuffer();
        prefix.append("public class FakeType {\n ");
        if (isStatic) {
            prefix.append("static ");
        }
        prefix.append("{\n");
        int i = 0;
        while (i < localVariableTypeNames.length) {
            ASTNode.printModifiers(localVariableModifiers[i], prefix);
            prefix.append(' ');
            prefix.append(localVariableTypeNames[i]);
            prefix.append(' ');
            prefix.append(localVariableNames[i]);
            prefix.append(';');
            ++i;
        }
        char[] fakeSource = CharOperation.concat(prefix.toString().toCharArray(), snippet, "}}".toCharArray());
        this.offset = prefix.length();
        String encoding = this.compilerOptions.defaultEncoding;
        BasicCompilationUnit fakeUnit = new BasicCompilationUnit(fakeSource, null, "FakeType.java", encoding);
        this.actualCompletionPosition = prefix.length() + position - 1;
        CompilationResult fakeResult = new CompilationResult(fakeUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration fakeAST = this.parser.dietParse(fakeUnit, fakeResult, this.actualCompletionPosition);
        this.parseBlockStatements(fakeAST, this.actualCompletionPosition);
        return (Initializer)fakeAST.types[0].fields[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void complete(ICompilationUnit sourceUnit, int completionPosition, int pos) {
        if (CompletionEngine.DEBUG) {
            System.out.print("COMPLETION IN ");
            System.out.print(sourceUnit.getFileName());
            System.out.print(" AT POSITION ");
            System.out.println(completionPosition);
            System.out.println("COMPLETION - Source :");
            System.out.println(sourceUnit.getContents());
        }
        try {
            block27: {
                try {
                    block28: {
                        this.actualCompletionPosition = completionPosition - 1;
                        this.offset = pos;
                        result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
                        parsedUnit = this.parser.dietParse(sourceUnit, result, this.actualCompletionPosition);
                        if (parsedUnit != null) {
                            if (CompletionEngine.DEBUG) {
                                System.out.println("COMPLETION - Diet AST :");
                                System.out.println(parsedUnit.toString());
                            }
                            if (parsedUnit.currentPackage instanceof CompletionOnPackageReference) {
                                this.findPackages((CompletionOnPackageReference)parsedUnit.currentPackage);
                                if (this.noProposal && this.problem != null) {
                                    this.requestor.acceptError(this.problem);
                                }
                                var11_10 = null;
                                break block27;
                            }
                            imports = parsedUnit.imports;
                            if (imports != null) {
                                i = 0;
                                length = imports.length;
                                while (i < length) {
                                    importReference = imports[i];
                                    if (importReference instanceof CompletionOnImportReference) {
                                        this.findImports((CompletionOnImportReference)importReference);
                                        if (this.noProposal && this.problem != null) {
                                            this.requestor.acceptError(this.problem);
                                        }
                                        var11_11 = null;
                                        this.reset();
                                        return;
                                    }
                                    if (importReference instanceof CompletionOnKeyword) {
                                        this.setSourceRange(importReference.sourceStart, importReference.sourceEnd);
                                        keyword = (CompletionOnKeyword)importReference;
                                        this.findKeywords(keyword.getToken(), keyword.getPossibleKeywords());
                                        if (this.noProposal && this.problem != null) {
                                            this.requestor.acceptError(this.problem);
                                        }
                                        var11_12 = null;
                                        this.reset();
                                        return;
                                    }
                                    ++i;
                                }
                            }
                            if (parsedUnit.types != null) {
                                try {
                                    this.lookupEnvironment.buildTypeBindings(parsedUnit);
                                    this.unitScope = parsedUnit.scope;
                                    if (this.unitScope != null) {
                                        this.source = sourceUnit.getContents();
                                        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                                        parsedUnit.scope.faultInTypes();
                                        this.parseBlockStatements(parsedUnit, this.actualCompletionPosition);
                                        if (CompletionEngine.DEBUG) {
                                            System.out.println("COMPLETION - AST :");
                                            System.out.println(parsedUnit.toString());
                                        }
                                        parsedUnit.resolve();
                                    }
                                }
                                catch (CompletionNodeFound e) {
                                    if (e.astNode == null) break block28;
                                    if (CompletionEngine.DEBUG) {
                                        System.out.print("COMPLETION - Completion node : ");
                                        System.out.println(e.astNode.toString());
                                        if (this.parser.assistNodeParent != null) {
                                            System.out.print("COMPLETION - Parent Node : ");
                                            System.out.println(this.parser.assistNodeParent);
                                        }
                                    }
                                    this.complete(e.astNode, this.parser.assistNodeParent, e.qualifiedBinding, e.scope);
                                }
                            }
                        }
                    }
                    if (this.noProposal && this.problem != null) {
                        this.requestor.acceptError(this.problem);
                    }
                    ** GOTO lbl-1000
                }
                catch (IndexOutOfBoundsException var4_5) {
                }
                catch (InvalidCursorLocation var4_6) {
                }
                catch (AbortCompilation var4_7) {
                }
                catch (CompletionNodeFound var4_8) {}
                ** GOTO lbl-1000
            }
            this.reset();
            return;
        }
        catch (Throwable var12_21) {
            var11_13 = null;
            this.reset();
            throw var12_21;
        }
lbl-1000:
        // 6 sources

        {
            var11_14 = null;
            this.reset();
            return;
        }
    }

    private TypeBinding[] computeTypes(Expression[] arguments, BlockScope scope) {
        if (arguments == null) {
            return null;
        }
        int argsLength = arguments.length;
        TypeBinding[] argTypes = new TypeBinding[argsLength];
        int a = argsLength;
        while (--a >= 0) {
            argTypes[a] = arguments[a].resolvedType;
        }
        return argTypes;
    }

    private void findAnonymousType(ReferenceBinding currentType, TypeBinding[] argTypes, Scope scope, InvocationSite invocationSite) {
        if (currentType.isInterface()) {
            char[] completion = CharOperation.NO_CHAR;
            if (this.source == null || this.source.length <= this.endPosition || this.source[this.endPosition] != ')') {
                completion = new char[]{')'};
            }
            int relevance = this.computeBaseRelevance();
            this.noProposal = false;
            this.requestor.acceptAnonymousType(currentType.qualifiedPackageName(), currentType.qualifiedSourceName(), CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR_CHAR, completion, 1, this.endPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterestingProposal());
        } else {
            this.findConstructors(currentType, argTypes, scope, invocationSite, true);
        }
    }

    private void findClassField(char[] token, TypeBinding receiverType, Scope scope) {
        if (token == null) {
            return;
        }
        if (token.length <= classField.length && CharOperation.prefixEquals(token, classField, false)) {
            int relevance = this.computeBaseRelevance();
            relevance += this.computeRelevanceForInterestingProposal();
            relevance += this.computeRelevanceForCaseMatching(token, classField);
            this.noProposal = false;
            this.requestor.acceptField(CharOperation.NO_CHAR, CharOperation.NO_CHAR, classField, CharOperation.NO_CHAR, CharOperation.NO_CHAR, classField, 9, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForExpectingType(scope.getJavaLangClass()));
        }
    }

    private void findExplicitConstructors(char[] name, ReferenceBinding currentType, MethodScope scope, InvocationSite invocationSite) {
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)scope.referenceContext;
        MethodBinding enclosingConstructor = constructorDeclaration.binding;
        MethodBinding[] methods = currentType.availableMethods();
        if (methods != null) {
            int f = methods.length;
            while (--f >= 0) {
                MethodBinding constructor = methods[f];
                if (constructor == enclosingConstructor || !constructor.isConstructor() || constructor.isSynthetic() || this.options.checkVisibility && !constructor.canBeSeenBy(invocationSite, scope)) continue;
                TypeBinding[] parameters = constructor.parameters;
                int paramLength = parameters.length;
                char[][] parameterPackageNames = new char[paramLength][];
                char[][] parameterTypeNames = new char[paramLength][];
                int i = 0;
                while (i < paramLength) {
                    TypeBinding type = parameters[i];
                    parameterPackageNames[i] = type.qualifiedPackageName();
                    parameterTypeNames[i] = type.qualifiedSourceName();
                    ++i;
                }
                char[][] parameterNames = this.findMethodParameterNames(constructor, parameterTypeNames);
                char[] completion = CharOperation.NO_CHAR;
                completion = this.source != null && this.source.length > this.endPosition && this.source[this.endPosition] == '(' ? name : CharOperation.concat(name, new char[]{'(', ')'});
                int relevance = this.computeBaseRelevance();
                relevance += this.computeRelevanceForInterestingProposal();
                this.noProposal = false;
                this.requestor.acceptMethod(currentType.qualifiedPackageName(), currentType.qualifiedSourceName(), name, parameterPackageNames, parameterTypeNames, parameterNames, CharOperation.NO_CHAR, CharOperation.NO_CHAR, completion, constructor.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForCaseMatching(this.completionToken, name));
            }
        }
    }

    private void findConstructors(ReferenceBinding currentType, TypeBinding[] argTypes, Scope scope, InvocationSite invocationSite, boolean forAnonymousType) {
        MethodBinding[] methods = currentType.availableMethods();
        if (methods != null) {
            int minArgLength = argTypes == null ? 0 : argTypes.length;
            int f = methods.length;
            block0: while (--f >= 0) {
                int relevance;
                TypeBinding[] parameters;
                int paramLength;
                MethodBinding constructor = methods[f];
                if (!constructor.isConstructor() || constructor.isSynthetic() || this.options.checkVisibility && !constructor.canBeSeenBy(invocationSite, scope) && (!forAnonymousType || !constructor.isProtected()) || minArgLength > (paramLength = (parameters = constructor.parameters).length)) continue;
                int a = minArgLength;
                while (--a >= 0) {
                    if (argTypes[a] != null && !argTypes[a].isCompatibleWith(constructor.parameters[a])) continue block0;
                }
                char[][] parameterPackageNames = new char[paramLength][];
                char[][] parameterTypeNames = new char[paramLength][];
                int i = 0;
                while (i < paramLength) {
                    TypeBinding type = parameters[i];
                    parameterPackageNames[i] = type.qualifiedPackageName();
                    parameterTypeNames[i] = type.qualifiedSourceName();
                    ++i;
                }
                char[][] parameterNames = this.findMethodParameterNames(constructor, parameterTypeNames);
                char[] completion = CharOperation.NO_CHAR;
                if (this.source == null || this.source.length <= this.endPosition || this.source[this.endPosition] != ')') {
                    completion = new char[]{')'};
                }
                if (forAnonymousType) {
                    relevance = this.computeBaseRelevance();
                    this.noProposal = false;
                    this.requestor.acceptAnonymousType(currentType.qualifiedPackageName(), currentType.qualifiedSourceName(), parameterPackageNames, parameterTypeNames, parameterNames, completion, constructor.modifiers, this.endPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterestingProposal());
                    continue;
                }
                relevance = this.computeBaseRelevance();
                this.noProposal = false;
                this.requestor.acceptMethod(currentType.qualifiedPackageName(), currentType.qualifiedSourceName(), currentType.sourceName(), parameterPackageNames, parameterTypeNames, parameterNames, CharOperation.NO_CHAR, CharOperation.NO_CHAR, completion, constructor.modifiers, this.endPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterestingProposal());
            }
        }
    }

    private void findFields(char[] fieldName, FieldBinding[] fields, Scope scope, ObjectVector fieldsFound, ObjectVector localsFound, boolean onlyStaticFields, ReferenceBinding receiverType, InvocationSite invocationSite, Scope invocationScope, boolean implicitCall) {
        ObjectVector newFieldsFound = new ObjectVector();
        int fieldLength = fieldName.length;
        int f = fields.length;
        block0: while (--f >= 0) {
            FieldBinding field = fields[f];
            if (field.isSynthetic() || onlyStaticFields && !field.isStatic() || fieldLength > field.name.length || !CharOperation.prefixEquals(fieldName, field.name, false) || this.options.checkVisibility && !field.canBeSeenBy(receiverType, invocationSite, scope)) continue;
            boolean prefixRequired = false;
            int i = fieldsFound.size;
            while (--i >= 0) {
                Object[] other = (Object[])fieldsFound.elementAt(i);
                FieldBinding otherField = (FieldBinding)other[0];
                ReferenceBinding otherReceiverType = (ReferenceBinding)other[1];
                if (field == otherField && receiverType == otherReceiverType) continue block0;
                if (!CharOperation.equals(field.name, otherField.name, true)) continue;
                if (field.declaringClass.isSuperclassOf(otherField.declaringClass) || otherField.declaringClass.isInterface() && (field.declaringClass == scope.getJavaLangObject() || field.declaringClass.implementsInterface(otherField.declaringClass, true)) || field.declaringClass.isInterface() && otherField.declaringClass.implementsInterface(field.declaringClass, true)) continue block0;
                prefixRequired = true;
            }
            int l = localsFound.size;
            while (--l >= 0) {
                LocalVariableBinding local = (LocalVariableBinding)localsFound.elementAt(l);
                if (!CharOperation.equals(field.name, local.name, true)) continue;
                SourceTypeBinding declarationType = scope.enclosingSourceType();
                if (declarationType.isAnonymousType() && declarationType != invocationScope.enclosingSourceType()) continue block0;
                prefixRequired = true;
                break;
            }
            newFieldsFound.add(new Object[]{field, receiverType});
            char[] completion = field.name;
            if (prefixRequired || this.options.forceImplicitQualification) {
                char[] prefix = this.computePrefix(scope.enclosingSourceType(), invocationScope.enclosingSourceType(), field.isStatic());
                completion = CharOperation.concat(prefix, completion, '.');
            }
            int relevance = this.computeBaseRelevance();
            relevance += this.computeRelevanceForInterestingProposal(field);
            relevance += this.computeRelevanceForCaseMatching(fieldName, field.name);
            relevance += this.computeRelevanceForExpectingType(field.type);
            relevance += this.computeRelevanceForStatic(onlyStaticFields, field.isStatic());
            this.noProposal = false;
            this.requestor.acceptField(field.declaringClass.qualifiedPackageName(), field.declaringClass.qualifiedSourceName(), field.name, field.type.qualifiedPackageName(), field.type.qualifiedSourceName(), completion, field.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForQualification(prefixRequired));
        }
        fieldsFound.addAll(newFieldsFound);
    }

    private void findFields(char[] fieldName, ReferenceBinding receiverType, Scope scope, ObjectVector fieldsFound, ObjectVector localsFound, boolean onlyStaticFields, InvocationSite invocationSite, Scope invocationScope, boolean implicitCall) {
        if (fieldName == null) {
            return;
        }
        ReferenceBinding currentType = receiverType;
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        do {
            FieldBinding[] fields;
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((fields = currentType.availableFields()) == null) continue;
            this.findFields(fieldName, fields, scope, fieldsFound, localsFound, onlyStaticFields, receiverType, invocationSite, invocationScope, implicitCall);
        } while ((currentType = currentType.superclass()) != null);
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding anInterface = interfaces[j];
                    if ((anInterface.tagBits & 0x800) == 0) {
                        ReferenceBinding[] itsInterfaces;
                        anInterface.tagBits |= 0x800;
                        FieldBinding[] fields = anInterface.availableFields();
                        if (fields != null) {
                            this.findFields(fieldName, fields, scope, fieldsFound, localsFound, onlyStaticFields, receiverType, invocationSite, invocationScope, implicitCall);
                        }
                        if ((itsInterfaces = anInterface.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void findFieldsAndMethods(char[] token, TypeBinding receiverType, Scope scope, InvocationSite invocationSite, Scope invocationScope, boolean implicitCall, boolean superCall) {
        if (token == null) {
            return;
        }
        if (receiverType.isBaseType()) {
            return;
        }
        ObjectVector methodsFound = new ObjectVector();
        if (receiverType.isArrayType()) {
            if (token.length <= lengthField.length && CharOperation.prefixEquals(token, lengthField, false)) {
                int relevance = this.computeBaseRelevance();
                relevance += this.computeRelevanceForInterestingProposal();
                relevance += this.computeRelevanceForCaseMatching(token, lengthField);
                this.noProposal = false;
                this.requestor.acceptField(CharOperation.NO_CHAR, CharOperation.NO_CHAR, lengthField, CharOperation.NO_CHAR, CharOperation.NO_CHAR, lengthField, 1, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForExpectingType(BaseTypes.IntBinding));
            }
            if (token.length <= cloneMethod.length && CharOperation.prefixEquals(token, cloneMethod, false)) {
                ReferenceBinding objectRef = scope.getJavaLangObject();
                int relevance = this.computeBaseRelevance();
                relevance += this.computeRelevanceForInterestingProposal();
                relevance += this.computeRelevanceForCaseMatching(token, cloneMethod);
                relevance += this.computeRelevanceForExpectingType(objectRef);
                relevance += this.computeRelevanceForStatic(false, false);
                char[] completion = this.source != null && this.source.length > this.endPosition && this.source[this.endPosition] == '(' ? cloneMethod : CharOperation.concat(cloneMethod, new char[]{'(', ')'});
                this.noProposal = false;
                this.requestor.acceptMethod(CharOperation.NO_CHAR, CharOperation.NO_CHAR, cloneMethod, CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR_CHAR, CharOperation.concat(TypeConstants.JAVA, TypeConstants.LANG, '.'), TypeConstants.OBJECT, completion, 1, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForQualification(false));
                methodsFound.add(new Object[]{objectRef.getMethods(cloneMethod)[0], objectRef});
            }
            receiverType = scope.getJavaLangObject();
        }
        this.findFields(token, (ReferenceBinding)receiverType, scope, new ObjectVector(), new ObjectVector(), false, invocationSite, invocationScope, implicitCall);
        this.findMethods(token, null, (ReferenceBinding)receiverType, scope, methodsFound, false, false, false, invocationSite, invocationScope, implicitCall, superCall);
    }

    private void findImports(CompletionOnImportReference importReference) {
        char[][] tokens = importReference.tokens;
        char[] importName = CharOperation.concatWith(tokens, '.');
        if (importName.length == 0) {
            return;
        }
        char[] lastToken = tokens[tokens.length - 1];
        if (lastToken != null && lastToken.length == 0) {
            importName = CharOperation.concat(importName, new char[]{'.'});
        }
        this.resolvingImports = true;
        this.setSourceRange(importReference.sourceStart, importReference.declarationSourceEnd);
        this.completionToken = importName;
        this.nameEnvironment.findPackages(importName, this);
        this.nameEnvironment.findTypes(importName, this);
    }

    private void findKeywords(char[] keyword, char[][] choices) {
        if (choices == null || choices.length == 0) {
            return;
        }
        int length = keyword.length;
        if (length > 0) {
            int i = 0;
            while (i < choices.length) {
                if (length <= choices[i].length && CharOperation.prefixEquals(keyword, choices[i], false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    this.noProposal = false;
                    this.requestor.acceptKeyword(choices[i], this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForCaseMatching(keyword, choices[i]));
                }
                ++i;
            }
        }
    }

    private void findKeywordsForMember(char[] token, int modifiers) {
        char[][] keywords = new char[41][];
        int count = 0;
        if ((modifiers & 2) == 0 && (modifiers & 4) == 0 && (modifiers & 1) == 0) {
            keywords[count++] = Keywords.PROTECTED;
            keywords[count++] = Keywords.PUBLIC;
            if ((modifiers & 0x400) == 0) {
                keywords[count++] = Keywords.PRIVATE;
            }
        }
        if ((modifiers & 0x400) == 0) {
            if ((modifiers & 0xFFFFFFF0) == 0) {
                keywords[count++] = Keywords.ABSTRACT;
            }
            if ((modifiers & 0x10) == 0) {
                keywords[count++] = Keywords.FINAL;
            }
            if ((modifiers & 8) == 0) {
                keywords[count++] = Keywords.STATIC;
            }
            boolean canBeField = true;
            boolean canBeMethod = true;
            boolean canBeType = true;
            if ((modifiers & 0x100) != 0 || (modifiers & 0x800) != 0 || (modifiers & 0x20) != 0) {
                canBeField = false;
                canBeType = false;
            }
            if ((modifiers & 0x80) != 0 || (modifiers & 0x40) != 0) {
                canBeMethod = false;
                canBeType = false;
            }
            if (canBeField) {
                if ((modifiers & 0x80) == 0) {
                    keywords[count++] = Keywords.TRANSIENT;
                }
                if ((modifiers & 0x40) == 0) {
                    keywords[count++] = Keywords.VOLATILE;
                }
            }
            if (canBeMethod) {
                if ((modifiers & 0x100) == 0) {
                    keywords[count++] = Keywords.NATIVE;
                }
                if ((modifiers & 0x800) == 0) {
                    keywords[count++] = Keywords.STRICTFP;
                }
                if ((modifiers & 0x20) == 0) {
                    keywords[count++] = Keywords.SYNCHRONIZED;
                }
            }
            if (canBeType) {
                keywords[count++] = Keywords.CLASS;
                keywords[count++] = Keywords.INTERFACE;
            }
        } else {
            keywords[count++] = Keywords.CLASS;
            keywords[count++] = Keywords.INTERFACE;
        }
        char[][] cArray = keywords;
        keywords = new char[count][];
        System.arraycopy(cArray, 0, keywords, 0, count);
        this.findKeywords(token, keywords);
    }

    private void findMemberTypes(char[] typeName, ReferenceBinding[] memberTypes, ObjectVector typesFound, ReferenceBinding receiverType, SourceTypeBinding invocationType) {
        int typeLength = typeName.length;
        int m = memberTypes.length;
        block0: while (--m >= 0) {
            ReferenceBinding memberType = memberTypes[m];
            if (typeLength > memberType.sourceName.length || !CharOperation.prefixEquals(typeName, memberType.sourceName, false) || this.options.checkVisibility && !memberType.canBeSeenBy(receiverType, invocationType)) continue;
            int i = typesFound.size;
            while (--i >= 0) {
                ReferenceBinding otherType = (ReferenceBinding)typesFound.elementAt(i);
                if (memberType == otherType || CharOperation.equals(memberType.sourceName, otherType.sourceName, true) && (memberType.enclosingType().isSuperclassOf(otherType.enclosingType()) || otherType.enclosingType().isInterface() && memberType.enclosingType().implementsInterface(otherType.enclosingType(), true) || memberType.enclosingType().isInterface() && otherType.enclosingType().implementsInterface(memberType.enclosingType(), true))) continue block0;
            }
            typesFound.add(memberType);
            int relevance = this.computeBaseRelevance();
            relevance += this.computeRelevanceForInterestingProposal();
            relevance += this.computeRelevanceForCaseMatching(typeName, memberType.sourceName);
            relevance += this.computeRelevanceForExpectingType(memberType);
            if (memberType.isClass()) {
                relevance += this.computeRelevanceForClass();
                this.noProposal = false;
                this.requestor.acceptClass(memberType.qualifiedPackageName(), memberType.qualifiedSourceName(), memberType.sourceName(), memberType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForException(memberType.sourceName));
                continue;
            }
            this.noProposal = false;
            this.requestor.acceptInterface(memberType.qualifiedPackageName(), memberType.qualifiedSourceName(), memberType.sourceName(), memberType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterface());
        }
    }

    private void findMemberTypes(char[] typeName, ReferenceBinding receiverType, Scope scope, SourceTypeBinding typeInvocation) {
        ReferenceBinding currentType = receiverType;
        if (typeName == null) {
            return;
        }
        if (currentType.superInterfaces() == null) {
            return;
        }
        ObjectVector typesFound = new ObjectVector();
        if (this.insideQualifiedReference || typeName.length == 0) {
            this.findMemberTypes(typeName, currentType.memberTypes(), typesFound, receiverType, typeInvocation);
            return;
        }
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            this.findMemberTypes(typeName, currentType.memberTypes(), typesFound, receiverType, typeInvocation);
        } while ((currentType = currentType.superclass()) != null);
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding anInterface = interfaces[j];
                    if ((anInterface.tagBits & 0x800) == 0) {
                        anInterface.tagBits |= 0x800;
                        this.findMemberTypes(typeName, anInterface.memberTypes(), typesFound, receiverType, typeInvocation);
                        ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void findIntefacesMethods(char[] selector, TypeBinding[] argTypes, ReferenceBinding receiverType, ReferenceBinding[] itsInterfaces, Scope scope, ObjectVector methodsFound, boolean onlyStaticMethods, boolean exactMatch, boolean isCompletingDeclaration, InvocationSite invocationSite, Scope invocationScope, boolean implicitCall, boolean superCall) {
        if (selector == null) {
            return;
        }
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800) == 0) {
                        currentType.tagBits |= 0x800;
                        MethodBinding[] methods = currentType.availableMethods();
                        if (methods != null) {
                            if (isCompletingDeclaration) {
                                this.findLocalMethodDeclarations(selector, methods, scope, methodsFound, onlyStaticMethods, exactMatch, receiverType);
                            } else {
                                this.findLocalMethods(selector, argTypes, methods, scope, methodsFound, onlyStaticMethods, exactMatch, receiverType, invocationSite, invocationScope, implicitCall, superCall);
                            }
                        }
                        if ((itsInterfaces = currentType.superInterfaces()) != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void findImplicitMessageSends(char[] token, TypeBinding[] argTypes, Scope scope, InvocationSite invocationSite, Scope invocationScope) {
        if (token == null) {
            return;
        }
        boolean staticsOnly = false;
        ObjectVector methodsFound = new ObjectVector();
        while (true) {
            switch (scope.kind) {
                case 2: {
                    MethodScope methodScope = (MethodScope)scope;
                    staticsOnly |= methodScope.isStatic | methodScope.isConstructorCall;
                    break;
                }
                case 3: {
                    ClassScope classScope = (ClassScope)scope;
                    SourceTypeBinding enclosingType = classScope.referenceContext.binding;
                    this.findMethods(token, argTypes, enclosingType, classScope, methodsFound, staticsOnly, true, false, invocationSite, invocationScope, true, false);
                    staticsOnly |= enclosingType.isStatic();
                    break;
                }
                case 4: {
                    return;
                }
            }
            scope = scope.parent;
        }
    }

    private void findLocalMethods(char[] methodName, TypeBinding[] argTypes, MethodBinding[] methods, Scope scope, ObjectVector methodsFound, boolean onlyStaticMethods, boolean exactMatch, ReferenceBinding receiverType, InvocationSite invocationSite, Scope invocationScope, boolean implicitCall, boolean superCall) {
        ObjectVector newMethodsFound = new ObjectVector();
        int methodLength = methodName.length;
        int minArgLength = argTypes == null ? 0 : argTypes.length;
        int f = methods.length;
        block0: while (--f >= 0) {
            MethodBinding method = methods[f];
            if (method.isSynthetic() || method.isDefaultAbstract() || method.isConstructor() || onlyStaticMethods && !method.isStatic() || this.options.checkVisibility && !method.canBeSeenBy(receiverType, invocationSite, scope)) continue;
            if (superCall && method.isAbstract()) {
                methodsFound.add(new Object[]{method, receiverType});
                continue;
            }
            if (!exactMatch ? methodLength > method.selector.length || !CharOperation.prefixEquals(methodName, method.selector, false) : !CharOperation.equals(methodName, method.selector, false)) continue;
            if (minArgLength > method.parameters.length) continue;
            int a = minArgLength;
            while (--a >= 0) {
                if (argTypes[a] != null && !argTypes[a].isCompatibleWith(method.parameters[a])) continue block0;
            }
            boolean prefixRequired = false;
            int i = methodsFound.size;
            while (--i >= 0) {
                Object[] other = (Object[])methodsFound.elementAt(i);
                MethodBinding otherMethod = (MethodBinding)other[0];
                ReferenceBinding otherReceiverType = (ReferenceBinding)other[1];
                if (method == otherMethod && receiverType == otherReceiverType) continue block0;
                if (!CharOperation.equals(method.selector, otherMethod.selector, true) || !method.areParametersEqual(otherMethod)) continue;
                if (method.declaringClass.isSuperclassOf(otherMethod.declaringClass) || otherMethod.declaringClass.isInterface() && (method.declaringClass == scope.getJavaLangObject() || method.declaringClass.isInterface() || !superCall && method.declaringClass.implementsInterface(otherMethod.declaringClass, true)) || method.declaringClass.isInterface() && otherMethod.declaringClass.implementsInterface(method.declaringClass, true) || receiverType.isAnonymousType()) continue block0;
                if (superCall) continue;
                prefixRequired = true;
            }
            newMethodsFound.add(new Object[]{method, receiverType});
            int length = method.parameters.length;
            char[][] parameterPackageNames = new char[length][];
            char[][] parameterTypeNames = new char[length][];
            int i2 = 0;
            while (i2 < length) {
                TypeBinding type = method.parameters[i2];
                parameterPackageNames[i2] = type.qualifiedPackageName();
                parameterTypeNames[i2] = type.qualifiedSourceName();
                ++i2;
            }
            char[][] parameterNames = this.findMethodParameterNames(method, parameterTypeNames);
            char[] completion = CharOperation.NO_CHAR;
            int previousStartPosition = this.startPosition;
            if (!exactMatch) {
                completion = this.source != null && this.source.length > this.endPosition && this.source[this.endPosition] == '(' ? method.selector : CharOperation.concat(method.selector, new char[]{'(', ')'});
            } else if (prefixRequired && this.source != null) {
                completion = CharOperation.subarray(this.source, this.startPosition, this.endPosition);
            } else {
                this.startPosition = this.endPosition;
            }
            if (prefixRequired || this.options.forceImplicitQualification) {
                char[] prefix = this.computePrefix(scope.enclosingSourceType(), invocationScope.enclosingSourceType(), method.isStatic());
                completion = CharOperation.concat(prefix, completion, '.');
            }
            int relevance = this.computeBaseRelevance();
            relevance += this.computeRelevanceForInterestingProposal();
            relevance += this.computeRelevanceForCaseMatching(methodName, method.selector);
            relevance += this.computeRelevanceForExpectingType(method.returnType);
            relevance += this.computeRelevanceForStatic(onlyStaticMethods, method.isStatic());
            this.noProposal = false;
            this.requestor.acceptMethod(method.declaringClass.qualifiedPackageName(), method.declaringClass.qualifiedSourceName(), method.selector, parameterPackageNames, parameterTypeNames, parameterNames, method.returnType.qualifiedPackageName(), method.returnType.qualifiedSourceName(), completion, method.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForQualification(prefixRequired));
            this.startPosition = previousStartPosition;
        }
        methodsFound.addAll(newMethodsFound);
    }

    int computeRelevanceForCaseMatching(char[] token, char[] proposalName) {
        if (CharOperation.prefixEquals(token, proposalName, true)) {
            if (CharOperation.equals(token, proposalName, true)) {
                return 14;
            }
            return 10;
        }
        return 0;
    }

    private int computeRelevanceForClass() {
        if (this.assistNodeIsClass) {
            return 20;
        }
        return 0;
    }

    private int computeRelevanceForInterface() {
        if (this.assistNodeIsInterface) {
            return 20;
        }
        return 0;
    }

    private int computeRelevanceForQualification(boolean prefixRequired) {
        if (!prefixRequired && !this.insideQualifiedReference) {
            return 3;
        }
        if (prefixRequired && this.insideQualifiedReference) {
            return 2;
        }
        return 0;
    }

    private int computeRelevanceForStatic(boolean onlyStatic, boolean isStatic) {
        if (this.insideQualifiedReference && !onlyStatic && !isStatic) {
            return 11;
        }
        return 0;
    }

    private int computeRelevanceForStaticOveride(boolean isStatic) {
        return isStatic ? 0 : 3;
    }

    private int computeRelevanceForException(char[] proposalName) {
        if (this.assistNodeIsException && (CharOperation.match(EXCEPTION_PATTERN, proposalName, false) || CharOperation.match(ERROR_PATTERN, proposalName, false))) {
            return 20;
        }
        return 0;
    }

    private int computeRelevanceForExpectingType(TypeBinding proposalType) {
        if (this.expectedTypes != null && proposalType != null) {
            int i = 0;
            while (i <= this.expectedTypesPtr) {
                if (CharOperation.equals(this.expectedTypes[i].qualifiedPackageName(), proposalType.qualifiedPackageName()) && CharOperation.equals(this.expectedTypes[i].qualifiedSourceName(), proposalType.qualifiedSourceName())) {
                    return 30;
                }
                if ((this.expectedTypesFilter & 2) != 0 && proposalType.isCompatibleWith(this.expectedTypes[i])) {
                    return 20;
                }
                if ((this.expectedTypesFilter & 1) != 0 && this.expectedTypes[i].isCompatibleWith(proposalType)) {
                    return 20;
                }
                ++i;
            }
        }
        return 0;
    }

    private int computeRelevanceForExpectingType(char[] packageName, char[] typeName) {
        if (this.expectedTypes != null) {
            int i = 0;
            while (i <= this.expectedTypesPtr) {
                if (CharOperation.equals(this.expectedTypes[i].qualifiedPackageName(), packageName) && CharOperation.equals(this.expectedTypes[i].qualifiedSourceName(), typeName)) {
                    return 30;
                }
                ++i;
            }
        }
        return 0;
    }

    int computeRelevanceForInterestingProposal() {
        return this.computeRelevanceForInterestingProposal(null);
    }

    private int computeRelevanceForInterestingProposal(Binding binding) {
        if (this.uninterestingBindings != null) {
            int i = 0;
            while (i <= this.uninterestingBindingsPtr) {
                if (this.uninterestingBindings[i] == binding) {
                    return 0;
                }
                ++i;
            }
        }
        return 5;
    }

    private void computeUninterestingBindings(ASTNode parent, Scope scope) {
        if (parent instanceof LocalDeclaration) {
            this.addUninterestingBindings(((LocalDeclaration)parent).binding);
        } else if (parent instanceof FieldDeclaration) {
            this.addUninterestingBindings(((FieldDeclaration)parent).binding);
        }
    }

    private void findLocalMethodDeclarations(char[] methodName, MethodBinding[] methods, Scope scope, ObjectVector methodsFound, boolean onlyStaticMethods, boolean exactMatch, ReferenceBinding receiverType) {
        ObjectVector newMethodsFound = new ObjectVector();
        int methodLength = methodName.length;
        int f = methods.length;
        block0: while (--f >= 0) {
            MethodBinding method = methods[f];
            if (method.isSynthetic() || method.isDefaultAbstract() || method.isConstructor() || method.isFinal() || (!method.isStatic() ? onlyStaticMethods : receiverType.isAnonymousType() || receiverType.isMemberType() && !receiverType.isStatic() || receiverType.isLocalType())) continue;
            if (this.options.checkVisibility && !method.canBeSeenBy(receiverType, FakeInvocationSite, scope) || (exactMatch ? !CharOperation.equals(methodName, method.selector, false) : methodLength > method.selector.length || !CharOperation.prefixEquals(methodName, method.selector, false))) continue;
            int i = methodsFound.size;
            while (--i >= 0) {
                MethodBinding otherMethod = (MethodBinding)methodsFound.elementAt(i);
                if (method == otherMethod || CharOperation.equals(method.selector, otherMethod.selector, true) && method.areParametersEqual(otherMethod)) continue block0;
            }
            newMethodsFound.add(method);
            int length = method.parameters.length;
            char[][] parameterPackageNames = new char[length][];
            char[][] parameterTypeNames = new char[length][];
            int i2 = 0;
            while (i2 < length) {
                TypeBinding type = method.parameters[i2];
                parameterPackageNames[i2] = type.qualifiedPackageName();
                parameterTypeNames[i2] = type.qualifiedSourceName();
                ++i2;
            }
            char[][] parameterNames = this.findMethodParameterNames(method, parameterTypeNames);
            StringBuffer completion = new StringBuffer(10);
            int insertedModifiers = method.modifiers & 0xFFFFFAFF;
            if (!exactMatch) {
                char[] returnTypeName;
                char[] returnPackageName;
                if (insertedModifiers != 0) {
                    ASTNode.printModifiers(insertedModifiers, completion);
                }
                if (this.mustQualifyType(returnPackageName = method.returnType.qualifiedPackageName(), returnTypeName = method.returnType.qualifiedSourceName())) {
                    completion.append(CharOperation.concat(returnPackageName, returnTypeName, '.'));
                } else {
                    completion.append(method.returnType.sourceName());
                }
                completion.append(' ');
                completion.append(method.selector);
                completion.append('(');
                int i3 = 0;
                while (i3 < length) {
                    if (this.mustQualifyType(parameterPackageNames[i3], parameterTypeNames[i3])) {
                        completion.append(CharOperation.concat(parameterPackageNames[i3], parameterTypeNames[i3], '.'));
                    } else {
                        completion.append(parameterTypeNames[i3]);
                    }
                    completion.append(' ');
                    if (parameterNames != null) {
                        completion.append(parameterNames[i3]);
                    } else {
                        completion.append('%');
                    }
                    if (i3 != length - 1) {
                        completion.append(',');
                    }
                    ++i3;
                }
                completion.append(')');
                ReferenceBinding[] exceptions = method.thrownExceptions;
                if (exceptions != null && exceptions.length > 0) {
                    completion.append(' ');
                    completion.append(THROWS);
                    completion.append(' ');
                    int i4 = 0;
                    while (i4 < exceptions.length) {
                        ReferenceBinding exception = exceptions[i4];
                        char[] exceptionPackageName = exception.qualifiedPackageName();
                        char[] exceptionTypeName = exception.qualifiedSourceName();
                        if (i4 != 0) {
                            completion.append(',');
                            completion.append(' ');
                        }
                        if (this.mustQualifyType(exceptionPackageName, exceptionTypeName)) {
                            completion.append(CharOperation.concat(exceptionPackageName, exceptionTypeName, '.'));
                        } else {
                            completion.append(exception.sourceName());
                        }
                        ++i4;
                    }
                }
            }
            int relevance = this.computeBaseRelevance();
            relevance += this.computeRelevanceForInterestingProposal();
            relevance += this.computeRelevanceForCaseMatching(methodName, method.selector);
            relevance += this.computeRelevanceForStaticOveride(method.isStatic());
            if (method.isAbstract()) {
                relevance += 20;
            }
            this.noProposal = false;
            this.requestor.acceptMethodDeclaration(method.declaringClass.qualifiedPackageName(), method.declaringClass.qualifiedSourceName(), method.selector, parameterPackageNames, parameterTypeNames, parameterNames, method.returnType.qualifiedPackageName(), method.returnType.qualifiedSourceName(), completion.toString().toCharArray(), method.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance);
        }
        methodsFound.addAll(newMethodsFound);
    }

    private void findMethods(char[] selector, TypeBinding[] argTypes, ReferenceBinding receiverType, Scope scope, ObjectVector methodsFound, boolean onlyStaticMethods, boolean exactMatch, boolean isCompletingDeclaration, InvocationSite invocationSite, Scope invocationScope, boolean implicitCall, boolean superCall) {
        MethodBinding[] methods;
        if (selector == null) {
            return;
        }
        if (isCompletingDeclaration && (methods = receiverType.availableMethods()) != null) {
            int i = 0;
            while (i < methods.length) {
                if (!methods[i].isDefaultAbstract()) {
                    methodsFound.add(methods[i]);
                }
                ++i;
            }
        }
        ReferenceBinding currentType = receiverType;
        if (receiverType.isInterface()) {
            if (isCompletingDeclaration) {
                this.findIntefacesMethods(selector, argTypes, receiverType, currentType.superInterfaces(), scope, methodsFound, onlyStaticMethods, exactMatch, isCompletingDeclaration, invocationSite, invocationScope, implicitCall, superCall);
            } else {
                this.findIntefacesMethods(selector, argTypes, receiverType, new ReferenceBinding[]{currentType}, scope, methodsFound, onlyStaticMethods, exactMatch, isCompletingDeclaration, invocationSite, invocationScope, implicitCall, superCall);
            }
            currentType = scope.getJavaLangObject();
        } else if (isCompletingDeclaration) {
            this.findIntefacesMethods(selector, argTypes, receiverType, currentType.superInterfaces(), scope, methodsFound, onlyStaticMethods, exactMatch, isCompletingDeclaration, invocationSite, invocationScope, implicitCall, superCall);
            currentType = receiverType.superclass();
        }
        boolean hasPotentialDefaultAbstractMethods = true;
        while (currentType != null) {
            MethodBinding[] methods2 = currentType.availableMethods();
            if (methods2 != null) {
                if (isCompletingDeclaration) {
                    this.findLocalMethodDeclarations(selector, methods2, scope, methodsFound, onlyStaticMethods, exactMatch, receiverType);
                } else {
                    this.findLocalMethods(selector, argTypes, methods2, scope, methodsFound, onlyStaticMethods, exactMatch, receiverType, invocationSite, invocationScope, implicitCall, superCall);
                }
            }
            if (hasPotentialDefaultAbstractMethods && currentType.isAbstract()) {
                this.findIntefacesMethods(selector, argTypes, receiverType, currentType.superInterfaces(), scope, methodsFound, onlyStaticMethods, exactMatch, isCompletingDeclaration, invocationSite, invocationScope, implicitCall, superCall);
            } else {
                hasPotentialDefaultAbstractMethods = false;
            }
            currentType = currentType.superclass();
        }
    }

    private char[][] findMethodParameterNames(MethodBinding method, char[][] parameterTypeNames) {
        ReferenceBinding bindingType = method.declaringClass;
        char[][] parameterNames = null;
        int length = parameterTypeNames.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        if (bindingType instanceof SourceTypeBinding) {
            AbstractMethodDeclaration methodDecl;
            TypeDeclaration parsedType;
            SourceTypeBinding sourceType = (SourceTypeBinding)bindingType;
            if (sourceType.scope != null && (parsedType = sourceType.scope.referenceContext) != null && (methodDecl = parsedType.declarationOf(method)) != null) {
                Argument[] arguments = methodDecl.arguments;
                parameterNames = new char[length][];
                int i = 0;
                while (i < length) {
                    parameterNames[i] = arguments[i].name;
                    ++i;
                }
            }
        }
        if (parameterNames == null) {
            char[] compoundName = CharOperation.concatWith(bindingType.compoundName, '.');
            Object type = this.typeCache.get(compoundName);
            ISourceType sourceType = null;
            if (type != null) {
                if (type instanceof ISourceType) {
                    sourceType = (ISourceType)type;
                }
            } else {
                NameEnvironmentAnswer answer = this.nameEnvironment.findType(bindingType.compoundName);
                if (answer != null && answer.isSourceType()) {
                    sourceType = answer.getSourceTypes()[0];
                    this.typeCache.put(compoundName, sourceType);
                }
            }
            if (sourceType != null) {
                ISourceMethod[] sourceMethods = sourceType.getMethods();
                int len = sourceMethods == null ? 0 : sourceMethods.length;
                int i = 0;
                while (i < len) {
                    ISourceMethod sourceMethod = sourceMethods[i];
                    char[][] argTypeNames = sourceMethod.getArgumentTypeNames();
                    if (argTypeNames != null && CharOperation.equals(method.selector, sourceMethod.getSelector()) && CharOperation.equals(argTypeNames, parameterTypeNames)) {
                        parameterNames = sourceMethod.getArgumentNames();
                        break;
                    }
                    ++i;
                }
            }
        }
        return parameterNames;
    }

    private void findNestedTypes(char[] typeName, SourceTypeBinding currentType, Scope scope) {
        if (typeName == null) {
            return;
        }
        int typeLength = typeName.length;
        while (scope != null) {
            switch (scope.kind) {
                case 1: 
                case 2: {
                    BlockScope blockScope = (BlockScope)scope;
                    int i = 0;
                    int length = blockScope.subscopeCount;
                    while (i < length) {
                        SourceTypeBinding localType;
                        if (blockScope.subscopes[i] instanceof ClassScope && !(localType = ((ClassScope)blockScope.subscopes[i]).referenceContext.binding).isAnonymousType() && typeLength <= localType.sourceName.length && CharOperation.prefixEquals(typeName, localType.sourceName, false)) {
                            int relevance = this.computeBaseRelevance();
                            relevance += this.computeRelevanceForInterestingProposal();
                            relevance += this.computeRelevanceForCaseMatching(typeName, localType.sourceName);
                            relevance += this.computeRelevanceForExpectingType(localType);
                            relevance += this.computeRelevanceForException(localType.sourceName);
                            relevance += this.computeRelevanceForClass();
                            this.noProposal = false;
                            this.requestor.acceptClass(localType.qualifiedPackageName(), localType.sourceName, localType.sourceName, localType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForQualification(false));
                        }
                        ++i;
                    }
                    break;
                }
                case 3: {
                    this.findMemberTypes(typeName, scope.enclosingSourceType(), scope, currentType);
                    if (typeLength != 0) break;
                    return;
                }
                case 4: {
                    return;
                }
            }
            scope = scope.parent;
        }
    }

    private void findPackages(CompletionOnPackageReference packageStatement) {
        this.completionToken = CharOperation.concatWith(packageStatement.tokens, '.');
        if (this.completionToken.length == 0) {
            return;
        }
        this.setSourceRange(packageStatement.sourceStart, packageStatement.sourceEnd);
        this.nameEnvironment.findPackages(CharOperation.toLowerCase(this.completionToken), this);
    }

    private void findTypesAndPackages(char[] token, Scope scope) {
        block16: {
            block15: {
                if (token == null) {
                    return;
                }
                if (scope.enclosingSourceType() != null) {
                    this.findNestedTypes(token, scope.enclosingSourceType(), scope);
                }
                if (this.unitScope != null) {
                    int typeLength = token.length;
                    SourceTypeBinding[] types = this.unitScope.topLevelTypes;
                    int i = 0;
                    int length = types.length;
                    while (i < length) {
                        SourceTypeBinding sourceType = types[i];
                        if (typeLength <= sourceType.sourceName.length && CharOperation.prefixEquals(token, sourceType.sourceName, false)) {
                            int relevance = this.computeBaseRelevance();
                            relevance += this.computeRelevanceForInterestingProposal();
                            relevance += this.computeRelevanceForCaseMatching(token, sourceType.sourceName);
                            relevance += this.computeRelevanceForExpectingType(sourceType);
                            relevance += this.computeRelevanceForQualification(false);
                            if (sourceType.isClass()) {
                                relevance += this.computeRelevanceForClass();
                                this.noProposal = false;
                                this.requestor.acceptClass(sourceType.qualifiedPackageName(), sourceType.sourceName(), sourceType.sourceName(), sourceType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForException(sourceType.sourceName));
                            } else {
                                this.noProposal = false;
                                this.requestor.acceptInterface(sourceType.qualifiedPackageName(), sourceType.sourceName(), sourceType.sourceName(), sourceType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterface());
                            }
                        }
                        ++i;
                    }
                }
                if (token.length != 0) break block15;
                if (this.expectedTypesPtr <= -1) break block16;
                int i = 0;
                while (i <= this.expectedTypesPtr) {
                    block17: {
                        boolean isQualified;
                        char[] completionName;
                        char[] typeName;
                        char[] packageName;
                        ReferenceBinding refBinding;
                        block18: {
                            boolean inSameUnit;
                            if (!(this.expectedTypes[i] instanceof ReferenceBinding) || (inSameUnit = this.unitScope.isDefinedInSameUnit(refBinding = (ReferenceBinding)this.expectedTypes[i])) && (!inSameUnit || !refBinding.isMemberType())) break block17;
                            packageName = refBinding.qualifiedPackageName();
                            completionName = typeName = refBinding.sourceName();
                            isQualified = false;
                            if (this.insideQualifiedReference || refBinding.isMemberType() || !this.mustQualifyType(packageName, typeName)) break block18;
                            if ((packageName == null || packageName.length == 0) && this.unitScope != null && this.unitScope.fPackage.compoundName != CharOperation.NO_CHAR_CHAR) break block17;
                            completionName = CharOperation.concat(packageName, typeName, '.');
                            isQualified = true;
                        }
                        int relevance = this.computeBaseRelevance();
                        relevance += this.computeRelevanceForInterestingProposal();
                        relevance += this.computeRelevanceForCaseMatching(token, typeName);
                        relevance += this.computeRelevanceForExpectingType(refBinding);
                        relevance += this.computeRelevanceForQualification(isQualified);
                        if (refBinding.isClass()) {
                            this.noProposal = false;
                            this.requestor.acceptClass(packageName, typeName, completionName, refBinding.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForClass());
                        } else if (refBinding.isInterface()) {
                            this.noProposal = false;
                            this.requestor.acceptInterface(packageName, typeName, completionName, refBinding.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterface());
                        }
                    }
                    ++i;
                }
                break block16;
            }
            this.findKeywords(token, baseTypes);
            this.nameEnvironment.findTypes(token, this);
            this.nameEnvironment.findPackages(token, this);
        }
    }

    private void findTypesAndSubpackages(char[] token, PackageBinding packageBinding) {
        char[] qualifiedName = CharOperation.concatWith(packageBinding.compoundName, token, '.');
        if (token == null || token.length == 0) {
            int length = qualifiedName.length;
            char[] cArray = qualifiedName;
            qualifiedName = new char[length + 1];
            System.arraycopy(cArray, 0, qualifiedName, 0, length);
            qualifiedName[length] = 46;
        }
        this.qualifiedCompletionToken = qualifiedName;
        if (this.unitScope != null) {
            int typeLength = qualifiedName.length;
            SourceTypeBinding[] types = this.unitScope.topLevelTypes;
            int i = 0;
            int length = types.length;
            while (i < length) {
                SourceTypeBinding sourceType = types[i];
                char[] qualifiedSourceTypeName = CharOperation.concatWith(sourceType.compoundName, '.');
                if (typeLength <= qualifiedSourceTypeName.length && packageBinding == sourceType.getPackage() && CharOperation.prefixEquals(qualifiedName, qualifiedSourceTypeName, false)) {
                    int relevance = this.computeBaseRelevance();
                    relevance += this.computeRelevanceForInterestingProposal();
                    relevance += this.computeRelevanceForCaseMatching(qualifiedName, qualifiedSourceTypeName);
                    relevance += this.computeRelevanceForExpectingType(sourceType);
                    relevance += this.computeRelevanceForQualification(false);
                    if (sourceType.isClass()) {
                        relevance += this.computeRelevanceForClass();
                        this.noProposal = false;
                        this.requestor.acceptClass(sourceType.qualifiedPackageName(), sourceType.sourceName(), sourceType.sourceName(), sourceType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForException(sourceType.sourceName));
                    } else {
                        this.noProposal = false;
                        this.requestor.acceptInterface(sourceType.qualifiedPackageName(), sourceType.sourceName(), sourceType.sourceName(), sourceType.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterface());
                    }
                }
                ++i;
            }
        }
        this.nameEnvironment.findTypes(qualifiedName, this);
        this.nameEnvironment.findPackages(qualifiedName, this);
    }

    /*
     * Unable to fully structure code
     */
    private void findVariablesAndMethods(char[] token, Scope scope, InvocationSite invocationSite, Scope invocationScope) {
        if (token == null) {
            return;
        }
        staticsOnly = false;
        tokenLength = token.length;
        localsFound = new ObjectVector();
        fieldsFound = new ObjectVector();
        methodsFound = new ObjectVector();
        currentScope = scope;
        block10: while (true) {
            switch (currentScope.kind) {
                case 2: {
                    methodScope = (MethodScope)currentScope;
                    staticsOnly |= methodScope.isStatic | methodScope.isConstructorCall;
                }
                case 1: {
                    blockScope = (BlockScope)currentScope;
                    i = 0;
                    length = blockScope.locals.length;
                    while (i < length) {
                        local = blockScope.locals[i];
                        if (local == null) ** GOTO lbl41
                        if (tokenLength <= local.name.length && CharOperation.prefixEquals(token, local.name, false) && !local.isSecret()) {
                            f = 0;
                            while (f < localsFound.size) {
                                otherLocal = (LocalVariableBinding)localsFound.elementAt(f);
                                if (!CharOperation.equals(otherLocal.name, local.name, true)) {
                                    ++f;
                                    continue;
                                }
                                ** GOTO lbl36
                            }
                            localsFound.add(local);
                            relevance = this.computeBaseRelevance();
                            relevance += this.computeRelevanceForInterestingProposal(local);
                            relevance += this.computeRelevanceForCaseMatching(token, local.name);
                            relevance += this.computeRelevanceForExpectingType(local.type);
                            this.noProposal = false;
                            this.requestor.acceptLocalVariable(local.name, local.type == null ? CharOperation.NO_CHAR : local.type.qualifiedPackageName(), local.type == null ? local.declaration.type.toString().toCharArray() : local.type.qualifiedSourceName(), local.modifiers, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForQualification(false));
                        }
lbl36:
                        // 4 sources

                        ++i;
                    }
                    ** GOTO lbl41
                }
                case 4: {
                    break block10;
                }
lbl41:
                // 3 sources

                default: {
                    currentScope = currentScope.parent;
                    continue block10;
                }
            }
            break;
        }
        staticsOnly = false;
        currentScope = scope;
        block13: while (true) {
            switch (currentScope.kind) {
                case 2: {
                    methodScope = (MethodScope)currentScope;
                    staticsOnly |= methodScope.isStatic | methodScope.isConstructorCall;
                    ** GOTO lbl61
                }
                case 3: {
                    classScope = (ClassScope)currentScope;
                    enclosingType = classScope.referenceContext.binding;
                    this.findFields(token, enclosingType, classScope, fieldsFound, localsFound, staticsOnly, invocationSite, invocationScope, true);
                    this.findMethods(token, null, enclosingType, classScope, methodsFound, staticsOnly, false, false, invocationSite, invocationScope, true, false);
                    staticsOnly |= enclosingType.isStatic();
                    ** GOTO lbl61
                }
                case 4: {
                    break block13;
                }
lbl61:
                // 3 sources

                default: {
                    currentScope = currentScope.parent;
                    continue block13;
                }
            }
            break;
        }
    }

    private void findVariableName(char[] token, char[] qualifiedPackageName, char[] qualifiedSourceName, char[] sourceName, char[][] excludeNames, int dim, int kind, int modifiers) {
        char[] displayName;
        if (sourceName == null || sourceName.length == 0) {
            return;
        }
        if (dim > 0) {
            int l = qualifiedSourceName.length;
            displayName = new char[l + 2 * dim];
            System.arraycopy(qualifiedSourceName, 0, displayName, 0, l);
            int i = 0;
            while (i < dim) {
                displayName[l + i * 2] = 91;
                displayName[l + i * 2 + 1] = 93;
                ++i;
            }
        } else {
            displayName = qualifiedSourceName;
        }
        final char[] t = token;
        final char[] q = qualifiedPackageName;
        INamingRequestor namingRequestor = new INamingRequestor(){

            public void acceptNameWithPrefixAndSuffix(char[] name, boolean isFirstPrefix, boolean isFirstSuffix) {
                this.accept(name, (isFirstPrefix ? 6 : 5) + (isFirstSuffix ? 4 : 3));
            }

            public void acceptNameWithPrefix(char[] name, boolean isFirstPrefix) {
                this.accept(name, isFirstPrefix ? 6 : 5);
            }

            public void acceptNameWithSuffix(char[] name, boolean isFirstSuffix) {
                this.accept(name, isFirstSuffix ? 4 : 3);
            }

            public void acceptNameWithoutPrefixAndSuffix(char[] name) {
                this.accept(name, 0);
            }

            void accept(char[] name, int prefixAndSuffixRelevance) {
                if (CharOperation.prefixEquals(t, name, false)) {
                    int relevance = CompletionEngine.this.computeBaseRelevance();
                    relevance += CompletionEngine.this.computeRelevanceForInterestingProposal();
                    relevance += CompletionEngine.this.computeRelevanceForCaseMatching(t, name);
                    CompletionEngine.this.noProposal = false;
                    CompletionEngine.this.requestor.acceptVariableName(q, displayName, name, name, CompletionEngine.this.startPosition - CompletionEngine.this.offset, CompletionEngine.this.endPosition - CompletionEngine.this.offset, relevance += prefixAndSuffixRelevance);
                }
            }
        };
        switch (kind) {
            case 0: {
                InternalNamingConventions.suggestFieldNames(this.javaProject, qualifiedPackageName, qualifiedSourceName, dim, modifiers, excludeNames, namingRequestor);
                break;
            }
            case 1: {
                InternalNamingConventions.suggestLocalVariableNames(this.javaProject, qualifiedPackageName, qualifiedSourceName, dim, excludeNames, namingRequestor);
                break;
            }
            case 2: {
                InternalNamingConventions.suggestArgumentNames(this.javaProject, qualifiedPackageName, qualifiedSourceName, dim, excludeNames, namingRequestor);
            }
        }
    }

    private void findVariableNames(char[] name, TypeReference type, char[][] excludeNames, int kind, int modifiers) {
        if (type != null && type.resolvedType != null && type.resolvedType.problemId() == 0) {
            TypeBinding tb = type.resolvedType;
            this.findVariableName(name, tb.leafComponentType().qualifiedPackageName(), tb.leafComponentType().qualifiedSourceName(), tb.leafComponentType().sourceName(), excludeNames, type.dimensions(), kind, modifiers);
        }
    }

    public AssistParser getParser() {
        return this.parser;
    }

    protected void reset() {
        super.reset();
        this.knownPkgs = new HashtableOfObject(10);
        this.knownTypes = new HashtableOfObject(10);
    }

    private void setSourceRange(int start, int end) {
        this.setSourceRange(start, end, true);
    }

    private void setSourceRange(int start, int end, boolean emptyTokenAdjstment) {
        int endOfEmptyToken;
        this.startPosition = start;
        this.endPosition = emptyTokenAdjstment ? ((endOfEmptyToken = ((CompletionScanner)this.parser.scanner).endOfEmptyToken) > end ? endOfEmptyToken + 1 : end + 1) : end + 1;
    }

    int computeBaseRelevance() {
        return 0;
    }

    private void computeExpectedTypes(ASTNode parent, Scope scope) {
        this.expectedTypesFilter = 2;
        if (parent instanceof AbstractVariableDeclaration) {
            AbstractVariableDeclaration variable = (AbstractVariableDeclaration)parent;
            TypeBinding binding = variable.type.resolvedType;
            if (binding != null && !(variable.initialization instanceof ArrayInitializer)) {
                this.addExpectedType(binding);
            }
        } else if (parent instanceof Assignment) {
            TypeBinding binding = ((Assignment)parent).resolvedType;
            if (binding != null) {
                this.addExpectedType(binding);
            }
        } else if (parent instanceof ReturnStatement) {
            if (scope.methodScope().referenceContext instanceof AbstractMethodDeclaration) {
                TypeBinding binding;
                MethodBinding methodBinding = ((AbstractMethodDeclaration)scope.methodScope().referenceContext).binding;
                TypeBinding typeBinding = binding = methodBinding == null ? null : methodBinding.returnType;
                if (binding != null) {
                    this.addExpectedType(binding);
                }
            }
        } else if (parent instanceof CastExpression) {
            Expression e = ((CastExpression)parent).type;
            TypeBinding binding = e.resolvedType;
            if (binding != null) {
                this.addExpectedType(binding);
                this.expectedTypesFilter = 3;
            }
        } else if (parent instanceof MessageSend) {
            MessageSend messageSend = (MessageSend)parent;
            if (messageSend.receiverType instanceof ReferenceBinding) {
                ReferenceBinding binding = (ReferenceBinding)messageSend.receiverType;
                boolean isStatic = messageSend.receiver.isTypeReference();
                while (binding != null) {
                    this.computeExpectedTypesForMessageSend(binding, messageSend.selector, messageSend.arguments, (ReferenceBinding)messageSend.receiverType, scope, messageSend, isStatic);
                    this.computeExpectedTypesForMessageSendForInterface(binding, messageSend.selector, messageSend.arguments, (ReferenceBinding)messageSend.receiverType, scope, messageSend, isStatic);
                    binding = binding.superclass();
                }
            }
        } else if (parent instanceof AllocationExpression) {
            AllocationExpression allocationExpression = (AllocationExpression)parent;
            ReferenceBinding binding = (ReferenceBinding)allocationExpression.type.resolvedType;
            if (binding != null) {
                this.computeExpectedTypesForAllocationExpression(binding, allocationExpression.arguments, scope, allocationExpression);
            }
        } else if (parent instanceof OperatorExpression) {
            int operator = (parent.bits & 0xFC0) >> 6;
            if (!(parent instanceof ConditionalExpression)) {
                if (parent instanceof InstanceOfExpression) {
                    InstanceOfExpression e = (InstanceOfExpression)parent;
                    TypeBinding binding = e.expression.resolvedType;
                    if (binding != null) {
                        this.addExpectedType(binding);
                        this.expectedTypesFilter = 3;
                    }
                } else if (parent instanceof BinaryExpression) {
                    switch (operator) {
                        case 14: {
                            this.addExpectedType(BaseTypes.ShortBinding);
                            this.addExpectedType(BaseTypes.IntBinding);
                            this.addExpectedType(BaseTypes.LongBinding);
                            this.addExpectedType(BaseTypes.FloatBinding);
                            this.addExpectedType(BaseTypes.DoubleBinding);
                            this.addExpectedType(BaseTypes.CharBinding);
                            this.addExpectedType(BaseTypes.ByteBinding);
                            this.addExpectedType(scope.getJavaLangString());
                            break;
                        }
                        case 0: 
                        case 1: 
                        case 8: {
                            this.addExpectedType(BaseTypes.BooleanBinding);
                            break;
                        }
                        default: {
                            this.addExpectedType(BaseTypes.ShortBinding);
                            this.addExpectedType(BaseTypes.IntBinding);
                            this.addExpectedType(BaseTypes.LongBinding);
                            this.addExpectedType(BaseTypes.FloatBinding);
                            this.addExpectedType(BaseTypes.DoubleBinding);
                            this.addExpectedType(BaseTypes.CharBinding);
                            this.addExpectedType(BaseTypes.ByteBinding);
                            break;
                        }
                    }
                } else if (parent instanceof UnaryExpression) {
                    switch (operator) {
                        case 11: {
                            this.addExpectedType(BaseTypes.BooleanBinding);
                            break;
                        }
                        case 12: {
                            this.addExpectedType(BaseTypes.ShortBinding);
                            this.addExpectedType(BaseTypes.IntBinding);
                            this.addExpectedType(BaseTypes.LongBinding);
                            this.addExpectedType(BaseTypes.CharBinding);
                            this.addExpectedType(BaseTypes.ByteBinding);
                            break;
                        }
                        case 13: 
                        case 14: 
                        case 32: 
                        case 33: {
                            this.addExpectedType(BaseTypes.ShortBinding);
                            this.addExpectedType(BaseTypes.IntBinding);
                            this.addExpectedType(BaseTypes.LongBinding);
                            this.addExpectedType(BaseTypes.FloatBinding);
                            this.addExpectedType(BaseTypes.DoubleBinding);
                            this.addExpectedType(BaseTypes.CharBinding);
                            this.addExpectedType(BaseTypes.ByteBinding);
                        }
                    }
                }
            }
        } else if (parent instanceof ArrayReference) {
            this.addExpectedType(BaseTypes.ShortBinding);
            this.addExpectedType(BaseTypes.IntBinding);
            this.addExpectedType(BaseTypes.LongBinding);
        }
        if (this.expectedTypesPtr + 1 != this.expectedTypes.length) {
            this.expectedTypes = new TypeBinding[this.expectedTypesPtr + 1];
            System.arraycopy(this.expectedTypes, 0, this.expectedTypes, 0, this.expectedTypesPtr + 1);
        }
    }

    private void computeExpectedTypesForAllocationExpression(ReferenceBinding binding, Expression[] arguments, Scope scope, InvocationSite invocationSite) {
        MethodBinding[] methods = binding.availableMethods();
        int i = 0;
        while (i < methods.length) {
            block5: {
                TypeBinding[] parameters;
                MethodBinding method = methods[i];
                if (method.isConstructor() && !method.isSynthetic() && (!this.options.checkVisibility || method.canBeSeenBy(invocationSite, scope)) && (parameters = method.parameters).length >= arguments.length) {
                    int length = arguments.length - 1;
                    int j = 0;
                    while (j < length) {
                        Expression argument = arguments[j];
                        TypeBinding argType = argument.resolvedType;
                        if (argType == null || argType.isCompatibleWith(parameters[j])) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    TypeBinding expectedType = method.parameters[arguments.length - 1];
                    if (expectedType != null) {
                        this.addExpectedType(expectedType);
                    }
                }
            }
            ++i;
        }
    }

    private void computeExpectedTypesForMessageSendForInterface(ReferenceBinding binding, char[] selector, Expression[] arguments, ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, boolean isStatic) {
        ReferenceBinding[] itsInterfaces = binding.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = 0;
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800) == 0) {
                        currentType.tagBits |= 0x800;
                        this.computeExpectedTypesForMessageSend(currentType, selector, arguments, receiverType, scope, invocationSite, isStatic);
                        itsInterfaces = currentType.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFF7FF;
                    ++j;
                }
                ++i;
            }
        }
    }

    private void computeExpectedTypesForMessageSend(ReferenceBinding binding, char[] selector, Expression[] arguments, ReferenceBinding receiverType, Scope scope, InvocationSite invocationSite, boolean isStatic) {
        MethodBinding[] methods = binding.availableMethods();
        int i = 0;
        while (i < methods.length) {
            block5: {
                TypeBinding[] parameters;
                MethodBinding method = methods[i];
                if (!(method.isSynthetic() || method.isDefaultAbstract() || method.isConstructor() || isStatic && !method.isStatic() || this.options.checkVisibility && !method.canBeSeenBy(receiverType, invocationSite, scope) || !CharOperation.equals(method.selector, selector) || (parameters = method.parameters).length < arguments.length)) {
                    int length = arguments.length - 1;
                    int j = 0;
                    while (j < length) {
                        Expression argument = arguments[j];
                        TypeBinding argType = argument.resolvedType;
                        if (argType == null || argType.isCompatibleWith(parameters[j])) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    TypeBinding expectedType = method.parameters[arguments.length - 1];
                    if (expectedType != null) {
                        this.addExpectedType(expectedType);
                    }
                }
            }
            ++i;
        }
    }

    private void addExpectedType(TypeBinding type) {
        if (type == null || !type.isValidBinding()) {
            return;
        }
        int length = this.expectedTypes.length;
        if (++this.expectedTypesPtr >= length) {
            this.expectedTypes = new TypeBinding[length * 2];
            System.arraycopy(this.expectedTypes, 0, this.expectedTypes, 0, length);
        }
        this.expectedTypes[this.expectedTypesPtr] = type;
    }

    private void addUninterestingBindings(Binding binding) {
        if (binding == null) {
            return;
        }
        int length = this.uninterestingBindings.length;
        if (++this.uninterestingBindingsPtr >= length) {
            this.uninterestingBindings = new Binding[length * 2];
            System.arraycopy(this.uninterestingBindings, 0, this.uninterestingBindings, 0, length);
        }
        this.uninterestingBindings[this.uninterestingBindingsPtr] = binding;
    }

    private char[] computePrefix(SourceTypeBinding declarationType, SourceTypeBinding invocationType, boolean isStatic) {
        StringBuffer completion = new StringBuffer(10);
        if (isStatic) {
            completion.append(declarationType.sourceName());
        } else if (declarationType == invocationType) {
            completion.append(THIS);
        } else if (!declarationType.isNestedType()) {
            completion.append(declarationType.sourceName());
            completion.append('.');
            completion.append(THIS);
        } else if (!declarationType.isAnonymousType()) {
            completion.append(declarationType.sourceName());
            completion.append('.');
            completion.append(THIS);
        }
        return completion.toString().toCharArray();
    }

    private void proposeNewMethod(char[] token, ReferenceBinding reference) {
        if (this.requestor instanceof IExtendedCompletionRequestor) {
            IExtendedCompletionRequestor extendedRequestor = (IExtendedCompletionRequestor)this.requestor;
            int relevance = this.computeBaseRelevance();
            extendedRequestor.acceptPotentialMethodDeclaration(reference.qualifiedPackageName(), reference.qualifiedSourceName(), token, this.startPosition - this.offset, this.endPosition - this.offset, relevance += this.computeRelevanceForInterestingProposal());
        }
    }
}

