/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] parameters;
    public TypeReference[] thrownExceptions;
    public JavadocReturnStatement returnStatement;
    public Expression[] references;
    public boolean inherited = false;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int sourceStart, int sourceEnd) {
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i;
        ASTNode.printIndent(indent, output).append("/**\n");
        if (this.parameters != null) {
            i = 0;
            length = this.parameters.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @param ");
                this.parameters[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.returnStatement != null) {
            ASTNode.printIndent(indent + 1, output).append(" * @return\n");
        }
        if (this.thrownExceptions != null) {
            i = 0;
            length = this.thrownExceptions.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @throws ");
                this.thrownExceptions[i].print(indent, output).append('\n');
                ++i;
            }
        }
        if (this.references != null) {
            i = 0;
            length = this.references.length;
            while (i < length) {
                ASTNode.printIndent(indent + 1, output).append(" * @see");
                this.references[i].print(indent, output).append('\n');
                ++i;
            }
        }
        ASTNode.printIndent(indent, output).append(" */\n");
        return output;
    }

    public void resolve(ClassScope classScope) {
        int paramTagsSize = this.parameters == null ? 0 : this.parameters.length;
        int i = 0;
        while (i < paramTagsSize) {
            JavadocSingleNameReference param = this.parameters[i];
            classScope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
            ++i;
        }
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        int throwsTagsLength = this.thrownExceptions == null ? 0 : this.thrownExceptions.length;
        int i2 = 0;
        while (i2 < throwsTagsLength) {
            int end;
            int start;
            TypeReference typeRef = this.thrownExceptions[i2];
            if (typeRef instanceof JavadocSingleTypeReference) {
                JavadocSingleTypeReference singleRef = (JavadocSingleTypeReference)typeRef;
                start = singleRef.tagSourceStart;
                end = singleRef.tagSourceEnd;
            } else if (typeRef instanceof JavadocQualifiedTypeReference) {
                JavadocQualifiedTypeReference qualifiedRef = (JavadocQualifiedTypeReference)typeRef;
                start = qualifiedRef.tagSourceStart;
                end = qualifiedRef.tagSourceEnd;
            } else {
                start = typeRef.sourceStart;
                end = typeRef.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(start, end);
            ++i2;
        }
        int seeTagsLength = this.references == null ? 0 : this.references.length;
        int i3 = 0;
        while (i3 < seeTagsLength) {
            this.references[i3].resolveType(classScope);
            if (this.references[i3] instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.references[i3];
                if (fieldRef.receiverType != null && fieldRef.binding == null) {
                    JavadocMessageSend msgSend = new JavadocMessageSend(fieldRef.token, fieldRef.nameSourcePosition);
                    msgSend.receiver = fieldRef.receiver;
                    msgSend.receiverType = fieldRef.receiverType;
                    msgSend.qualifyingType = fieldRef.receiverType;
                    msgSend.superAccess = classScope.enclosingSourceType().isCompatibleWith(msgSend.receiverType);
                    msgSend.binding = classScope.findMethod((ReferenceBinding)msgSend.receiverType, msgSend.selector, new TypeBinding[0], msgSend);
                    this.references[i3] = msgSend;
                }
            }
            ++i3;
        }
    }

    public void resolve(MethodScope methScope) {
        AbstractMethodDeclaration methDecl = methScope.referenceMethod();
        boolean overriding = methDecl == null ? false : (methDecl.binding.modifiers & 0x30000000) != 0;
        int seeTagsLength = this.references == null ? 0 : this.references.length;
        boolean superRef = false;
        int i = 0;
        while (i < seeTagsLength) {
            this.references[i].resolveType(methScope);
            if (this.references[i] instanceof JavadocFieldReference) {
                JavadocFieldReference fieldRef = (JavadocFieldReference)this.references[i];
                if (fieldRef.receiverType != null && fieldRef.binding == null) {
                    JavadocMessageSend msgSend = new JavadocMessageSend(fieldRef.token, fieldRef.nameSourcePosition);
                    msgSend.receiver = fieldRef.receiver;
                    msgSend.receiverType = fieldRef.receiverType;
                    msgSend.qualifyingType = fieldRef.receiverType;
                    msgSend.superAccess = methScope.enclosingSourceType().isCompatibleWith(msgSend.receiverType);
                    msgSend.binding = methScope.findMethod((ReferenceBinding)msgSend.receiverType, msgSend.selector, new TypeBinding[0], msgSend);
                    this.references[i] = msgSend;
                }
            }
            try {
                if (methDecl != null && (methDecl.isConstructor() || overriding) && !superRef) {
                    if (this.references[i] instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)this.references[i];
                        if (messageSend.binding != null && messageSend.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(messageSend.receiverType) && CharOperation.equals(messageSend.selector, methDecl.selector) && messageSend.binding.returnType == methDecl.binding.returnType) {
                            if (messageSend.arguments == null && methDecl.arguments == null) {
                                superRef = true;
                            } else if (messageSend.arguments != null && methDecl.arguments != null) {
                                superRef = methDecl.binding.areParametersEqual(messageSend.binding);
                            }
                        }
                    } else if (this.references[i] instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.references[i];
                        if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && methDecl.binding.declaringClass.isCompatibleWith(allocationExpr.resolvedType)) {
                            if (allocationExpr.arguments == null && methDecl.arguments == null) {
                                superRef = true;
                            } else if (allocationExpr.arguments != null && methDecl.arguments != null) {
                                superRef = methDecl.binding.areParametersEqual(allocationExpr.binding);
                            }
                        }
                    }
                }
            }
            catch (Exception allocationExpr) {
                // empty catch block
            }
            ++i;
        }
        boolean reportMissing = methDecl == null || (!overriding || !this.inherited) && !superRef && (methDecl.binding.declaringClass == null || !methDecl.binding.declaringClass.isLocalType());
        this.resolveParamTags(methScope, reportMissing);
        if (this.returnStatement == null) {
            if (reportMissing && methDecl != null && !methDecl.isConstructor() && !methDecl.isClinit()) {
                MethodDeclaration meth = (MethodDeclaration)methDecl;
                if (meth.binding.returnType != BaseTypes.VoidBinding) {
                    methScope.problemReporter().javadocMissingReturnTag(meth.returnType.sourceStart, meth.returnType.sourceEnd, methDecl.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methScope);
        }
        this.resolveThrowsTags(methScope, reportMissing);
        int length = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        int i2 = 0;
        while (i2 < length) {
            this.invalidParameters[i2].resolve(methScope, false);
            ++i2;
        }
    }

    private void resolveParamTags(MethodScope methScope, boolean reportMissing) {
        block14: {
            int j;
            boolean found;
            int argumentsSize;
            int paramTagsSize;
            AbstractMethodDeclaration md;
            block13: {
                md = methScope.referenceMethod();
                int n = paramTagsSize = this.parameters == null ? 0 : this.parameters.length;
                if (md == null) {
                    int i = 0;
                    while (i < paramTagsSize) {
                        JavadocSingleNameReference param = this.parameters[i];
                        methScope.problemReporter().javadocUnexpectedTag(param.tagSourceStart, param.tagSourceEnd);
                        ++i;
                    }
                    return;
                }
                int n2 = argumentsSize = md.arguments == null ? 0 : md.arguments.length;
                if (paramTagsSize != 0) break block13;
                if (!reportMissing) break block14;
                int i = 0;
                while (i < argumentsSize) {
                    Argument arg = md.arguments[i];
                    methScope.problemReporter().javadocMissingParamTag(arg, md.binding.modifiers);
                    ++i;
                }
                break block14;
            }
            LocalVariableBinding[] bindings = new LocalVariableBinding[paramTagsSize];
            int maxBindings = 0;
            int i = 0;
            while (i < paramTagsSize) {
                JavadocSingleNameReference param = this.parameters[i];
                param.resolve(methScope);
                if (param.binding != null && param.binding.isValidBinding()) {
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        if (bindings[j] == param.binding) {
                            methScope.problemReporter().javadocDuplicatedParamTag(param, md.binding.modifiers);
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        bindings[maxBindings++] = (LocalVariableBinding)param.binding;
                    }
                }
                ++i;
            }
            if (reportMissing) {
                i = 0;
                while (i < argumentsSize) {
                    Argument arg = md.arguments[i];
                    found = false;
                    j = 0;
                    while (j < maxBindings && !found) {
                        LocalVariableBinding binding = bindings[j];
                        if (arg.binding == binding) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        methScope.problemReporter().javadocMissingParamTag(arg, md.binding.modifiers);
                    }
                    ++i;
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methScope, boolean reportMissing) {
        block23: {
            int j;
            TypeReference typeRef;
            int thrownExceptionLength;
            int boundExceptionLength;
            int throwsTagsLength;
            AbstractMethodDeclaration md;
            block22: {
                md = methScope.referenceMethod();
                int n = throwsTagsLength = this.thrownExceptions == null ? 0 : this.thrownExceptions.length;
                if (md == null) {
                    int i = 0;
                    while (i < throwsTagsLength) {
                        TypeReference typeRef2 = this.thrownExceptions[i];
                        int start = typeRef2.sourceStart;
                        int end = typeRef2.sourceEnd;
                        if (typeRef2 instanceof JavadocQualifiedTypeReference) {
                            start = ((JavadocQualifiedTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocQualifiedTypeReference)typeRef2).tagSourceEnd;
                        } else if (typeRef2 instanceof JavadocSingleTypeReference) {
                            start = ((JavadocSingleTypeReference)typeRef2).tagSourceStart;
                            end = ((JavadocSingleTypeReference)typeRef2).tagSourceEnd;
                        }
                        methScope.problemReporter().javadocUnexpectedTag(start, end);
                        ++i;
                    }
                    return;
                }
                boundExceptionLength = md.binding == null || md.binding.thrownExceptions == null ? 0 : md.binding.thrownExceptions.length;
                int n2 = thrownExceptionLength = md.thrownExceptions == null ? 0 : md.thrownExceptions.length;
                if (throwsTagsLength != 0) break block22;
                if (!reportMissing) break block23;
                int i = 0;
                while (i < boundExceptionLength) {
                    ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i];
                    if (exceptionBinding != null && exceptionBinding.isValidBinding()) {
                        int j2 = i;
                        while (j2 < thrownExceptionLength && exceptionBinding != md.thrownExceptions[j2].resolvedType) {
                            ++j2;
                        }
                        if (j2 < thrownExceptionLength) {
                            methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[j2], md.binding.modifiers);
                        }
                    }
                    ++i;
                }
                break block23;
            }
            int maxRef = 0;
            TypeReference[] typeReferences = new TypeReference[throwsTagsLength];
            int i = 0;
            while (i < throwsTagsLength) {
                typeRef = this.thrownExceptions[i];
                typeRef.resolve(methScope);
                TypeBinding typeBinding = typeRef.resolvedType;
                if (typeBinding != null && typeBinding.isValidBinding() && typeBinding.isClass()) {
                    typeReferences[maxRef++] = typeRef;
                }
                ++i;
            }
            i = 0;
            while (i < boundExceptionLength) {
                ReferenceBinding exceptionBinding = md.binding.thrownExceptions[i];
                boolean found = false;
                j = 0;
                while (j < maxRef && !found) {
                    TypeBinding typeBinding;
                    if (typeReferences[j] != null && exceptionBinding == (typeBinding = typeReferences[j].resolvedType)) {
                        found = true;
                        typeReferences[j] = null;
                    }
                    ++j;
                }
                if (!found && reportMissing && exceptionBinding != null && exceptionBinding.isValidBinding()) {
                    int k = i;
                    while (k < thrownExceptionLength && exceptionBinding != md.thrownExceptions[k].resolvedType) {
                        ++k;
                    }
                    if (k < thrownExceptionLength) {
                        methScope.problemReporter().javadocMissingThrowsTag(md.thrownExceptions[k], md.binding.modifiers);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < maxRef) {
                typeRef = typeReferences[i];
                if (typeRef != null) {
                    boolean compatible = false;
                    j = 0;
                    while (j < thrownExceptionLength && !compatible) {
                        TypeBinding exceptionBinding = md.thrownExceptions[j].resolvedType;
                        if (exceptionBinding != null) {
                            compatible = typeRef.resolvedType.isCompatibleWith(exceptionBinding);
                        }
                        ++j;
                    }
                    if (!(compatible || typeRef.resolvedType.isCompatibleWith(methScope.getJavaLangRuntimeException()) || typeRef.resolvedType.isCompatibleWith(methScope.getJavaLangError()))) {
                        methScope.problemReporter().javadocInvalidThrowsClassName(typeRef, md.binding.modifiers);
                    }
                }
                ++i;
            }
        }
    }

    public ASTNode getNodeStartingAt(int start) {
        JavadocSingleNameReference param;
        int i;
        if (this.parameters != null) {
            i = 0;
            while (i < this.parameters.length) {
                param = this.parameters[i];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.invalidParameters != null) {
            i = 0;
            while (i < this.invalidParameters.length) {
                param = this.invalidParameters[i];
                if (param.sourceStart == start) {
                    return param;
                }
                ++i;
            }
        }
        if (this.thrownExceptions != null) {
            i = 0;
            while (i < this.thrownExceptions.length) {
                TypeReference typeRef = this.thrownExceptions[i];
                if (typeRef.sourceStart == start) {
                    return typeRef;
                }
                ++i;
            }
        }
        if (this.references != null) {
            i = 0;
            while (i < this.references.length) {
                int j;
                Expression expression = this.references[i];
                if (expression.sourceStart == start) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    JavadocAllocationExpression allocationExpr = (JavadocAllocationExpression)this.references[i];
                    if (allocationExpr.binding != null && allocationExpr.binding.isValidBinding() && allocationExpr.arguments != null) {
                        j = 0;
                        while (j < allocationExpr.arguments.length) {
                            if (allocationExpr.arguments[j].sourceStart == start) {
                                return allocationExpr.arguments[j];
                            }
                            ++j;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    JavadocMessageSend messageSend = (JavadocMessageSend)this.references[i];
                    if (messageSend.binding != null && messageSend.binding.isValidBinding() && messageSend.arguments != null) {
                        j = 0;
                        while (j < messageSend.arguments.length) {
                            if (messageSend.arguments[j].sourceStart == start) {
                                return messageSend.arguments[j];
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

