/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.flow;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public ASTNode associatedNode;
    public FlowContext parent;
    public static final FlowContext NotContinuableContext = new FlowContext(null, null);

    public FlowContext(FlowContext parent, ASTNode associatedNode) {
        this.parent = parent;
        this.associatedNode = associatedNode;
    }

    public Label breakLabel() {
        return null;
    }

    public void checkExceptionHandlers(TypeBinding[] raisedExceptions, ASTNode location, FlowInfo flowInfo, BlockScope scope) {
        int raisedCount;
        if (raisedExceptions == null || (raisedCount = raisedExceptions.length) == 0) {
            return;
        }
        int remainingCount = raisedCount;
        TypeBinding[] typeBindingArray = raisedExceptions;
        raisedExceptions = new TypeBinding[raisedCount];
        System.arraycopy(typeBindingArray, 0, raisedExceptions, 0, raisedCount);
        FlowContext traversedContext = this;
        while (traversedContext != null) {
            SubRoutineStatement sub = traversedContext.subRoutine();
            if (sub != null && sub.isSubRoutineEscaping()) {
                return;
            }
            if (traversedContext instanceof ExceptionHandlingFlowContext) {
                ExceptionHandlingFlowContext exceptionContext = (ExceptionHandlingFlowContext)traversedContext;
                ReferenceBinding[] caughtExceptions = exceptionContext.handledExceptions;
                if (exceptionContext.handledExceptions != TypeConstants.NoExceptions) {
                    int caughtCount = caughtExceptions.length;
                    boolean[] locallyCaught = new boolean[raisedCount];
                    int caughtIndex = 0;
                    while (caughtIndex < caughtCount) {
                        ReferenceBinding caughtException = caughtExceptions[caughtIndex];
                        int raisedIndex = 0;
                        while (raisedIndex < raisedCount) {
                            TypeBinding raisedException = raisedExceptions[raisedIndex];
                            if (raisedException != null) {
                                int state = caughtException == null ? -1 : Scope.compareTypes(raisedException, caughtException);
                                switch (state) {
                                    case -1: {
                                        exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, locallyCaught[raisedIndex]);
                                        if (locallyCaught[raisedIndex]) break;
                                        locallyCaught[raisedIndex] = true;
                                        --remainingCount;
                                        break;
                                    }
                                    case 1: {
                                        exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, false);
                                    }
                                }
                            }
                            ++raisedIndex;
                        }
                        ++caughtIndex;
                    }
                    int i = 0;
                    while (i < raisedCount) {
                        if (locallyCaught[i]) {
                            raisedExceptions[i] = null;
                        }
                        ++i;
                    }
                }
                if (exceptionContext.isMethodContext) {
                    AbstractMethodDeclaration method;
                    int i = 0;
                    while (i < raisedCount) {
                        TypeBinding raisedException = raisedExceptions[i];
                        if (raisedException != null && (raisedException.isCompatibleWith(scope.getJavaLangRuntimeException()) || raisedException.isCompatibleWith(scope.getJavaLangError()))) {
                            --remainingCount;
                            raisedExceptions[i] = null;
                        }
                        ++i;
                    }
                    if (!(exceptionContext.associatedNode instanceof AbstractMethodDeclaration) || !(method = (AbstractMethodDeclaration)exceptionContext.associatedNode).isConstructor() || !method.binding.declaringClass.isAnonymousType()) break;
                    int i2 = 0;
                    while (i2 < raisedCount) {
                        TypeBinding raisedException = raisedExceptions[i2];
                        if (raisedException != null) {
                            exceptionContext.mergeUnhandledException(raisedException);
                        }
                        ++i2;
                    }
                    return;
                }
            }
            if (remainingCount == 0) {
                return;
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (traversedContext.associatedNode instanceof TryStatement) {
                flowInfo = flowInfo.copy().addInitializationsFrom(((TryStatement)traversedContext.associatedNode).subRoutineInits);
            }
            traversedContext = traversedContext.parent;
        }
        int i = 0;
        while (i < raisedCount) {
            block25: {
                TypeBinding exception = raisedExceptions[i];
                if (exception != null) {
                    int j = 0;
                    while (j < i) {
                        if (raisedExceptions[j] != exception) {
                            ++j;
                            continue;
                        }
                        break block25;
                    }
                    scope.problemReporter().unhandledException(exception, location);
                }
            }
            ++i;
        }
    }

    public void checkExceptionHandlers(TypeBinding raisedException, ASTNode location, FlowInfo flowInfo, BlockScope scope) {
        FlowContext traversedContext = this;
        while (traversedContext != null) {
            SubRoutineStatement sub = traversedContext.subRoutine();
            if (sub != null && sub.isSubRoutineEscaping()) {
                return;
            }
            if (traversedContext instanceof ExceptionHandlingFlowContext) {
                ExceptionHandlingFlowContext exceptionContext = (ExceptionHandlingFlowContext)traversedContext;
                ReferenceBinding[] caughtExceptions = exceptionContext.handledExceptions;
                if (exceptionContext.handledExceptions != TypeConstants.NoExceptions) {
                    boolean definitelyCaught = false;
                    int caughtIndex = 0;
                    int caughtCount = caughtExceptions.length;
                    while (caughtIndex < caughtCount) {
                        ReferenceBinding caughtException = caughtExceptions[caughtIndex];
                        int state = caughtException == null ? -1 : Scope.compareTypes(raisedException, caughtException);
                        switch (state) {
                            case -1: {
                                exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, definitelyCaught);
                                definitelyCaught = true;
                                break;
                            }
                            case 1: {
                                exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, false);
                            }
                        }
                        ++caughtIndex;
                    }
                    if (definitelyCaught) {
                        return;
                    }
                }
                if (exceptionContext.isMethodContext) {
                    AbstractMethodDeclaration method;
                    if (raisedException.isCompatibleWith(scope.getJavaLangRuntimeException()) || raisedException.isCompatibleWith(scope.getJavaLangError())) {
                        return;
                    }
                    if (!(exceptionContext.associatedNode instanceof AbstractMethodDeclaration) || !(method = (AbstractMethodDeclaration)exceptionContext.associatedNode).isConstructor() || !method.binding.declaringClass.isAnonymousType()) break;
                    exceptionContext.mergeUnhandledException(raisedException);
                    return;
                }
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (traversedContext.associatedNode instanceof TryStatement) {
                flowInfo = flowInfo.copy().addInitializationsFrom(((TryStatement)traversedContext.associatedNode).subRoutineInits);
            }
            traversedContext = traversedContext.parent;
        }
        scope.problemReporter().unhandledException(raisedException, location);
    }

    public Label continueLabel() {
        return null;
    }

    public FlowContext getTargetContextForBreakLabel(char[] labelName) {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            char[] currentLabelName;
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if ((currentLabelName = current.labelName()) != null && CharOperation.equals(currentLabelName, labelName)) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] labelName) {
        FlowContext current = this;
        FlowContext lastContinuable = null;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            } else if (current.isContinuable()) {
                lastContinuable = current;
            }
            char[] currentLabelName = current.labelName();
            if (currentLabelName != null && CharOperation.equals(currentLabelName, labelName)) {
                if (lastContinuable != null && current.associatedNode.concreteStatement() == lastContinuable.associatedNode) {
                    if (lastNonReturningSubRoutine == null) {
                        return lastContinuable;
                    }
                    return lastNonReturningSubRoutine;
                }
                return NotContinuableContext;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if (current.isBreakable() && current.labelName() == null) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if (current.isContinuable()) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordContinueFrom(FlowInfo flowInfo) {
    }

    boolean recordFinalAssignment(VariableBinding variable, Reference finalReference) {
        return true;
    }

    public void recordReturnFrom(FlowInfo flowInfo) {
    }

    public void recordSettingFinal(VariableBinding variable, Reference finalReference, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        FlowContext context = this;
        while (context != null) {
            if (!context.recordFinalAssignment(variable, finalReference)) break;
            context = context.parent;
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
    }

    public SubRoutineStatement subRoutine() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        FlowContext current = this;
        int parentsCount = 0;
        while ((current = current.parent) != null) {
            ++parentsCount;
        }
        FlowContext[] parents = new FlowContext[parentsCount + 1];
        current = this;
        int index = parentsCount;
        while (index >= 0) {
            parents[index--] = current;
            current = current.parent;
        }
        int i = 0;
        while (i < parentsCount) {
            int j = 0;
            while (j < i) {
                buffer.append('\t');
                ++j;
            }
            buffer.append(parents[i].individualToString()).append('\n');
            ++i;
        }
        buffer.append('*');
        int j = 0;
        while (j < parentsCount + 1) {
            buffer.append('\t');
            ++j;
        }
        buffer.append(this.individualToString()).append('\n');
        return buffer.toString();
    }
}

