/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.dom.rewrite;

import org.aspectj.org.eclipse.jdt.core.ToolFactory;
import org.aspectj.org.eclipse.jdt.core.compiler.IScanner;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class TokenScanner {
    public static final int END_OF_FILE = 20001;
    public static final int LEXICAL_ERROR = 20002;
    public static final int DOCUMENT_ERROR = 20003;
    private final IScanner scanner;
    private final IDocument document;
    private final int endPosition;

    public TokenScanner(IScanner scanner) {
        this(scanner, null);
    }

    public TokenScanner(IScanner scanner, IDocument document) {
        this.scanner = scanner;
        this.endPosition = this.scanner.getSource().length - 1;
        this.document = document;
    }

    public TokenScanner(IDocument document) {
        this.scanner = ToolFactory.createScanner(true, false, false, false);
        this.scanner.setSource(document.get().toCharArray());
        this.document = document;
        this.endPosition = this.scanner.getSource().length - 1;
    }

    public IScanner getScanner() {
        return this.scanner;
    }

    public void setOffset(int offset) {
        this.scanner.resetTo(offset, this.endPosition);
    }

    public int getCurrentEndOffset() {
        return this.scanner.getCurrentTokenEndPosition() + 1;
    }

    public int getCurrentStartOffset() {
        return this.scanner.getCurrentTokenStartPosition();
    }

    public int getCurrentLength() {
        return this.getCurrentEndOffset() - this.getCurrentStartOffset();
    }

    public int readNext(boolean ignoreComments) throws CoreException {
        int curr = 0;
        do {
            try {
                curr = this.scanner.getNextToken();
                if (curr == 158) {
                    throw new CoreException(TokenScanner.createError(20001, "End Of File", null));
                }
            }
            catch (InvalidInputException e) {
                throw new CoreException(TokenScanner.createError(20002, e.getMessage(), e));
            }
        } while (ignoreComments && TokenScanner.isComment(curr));
        return curr;
    }

    private int readNextWithEOF(boolean ignoreComments) throws CoreException {
        int curr = 0;
        do {
            try {
                curr = this.scanner.getNextToken();
            }
            catch (InvalidInputException e) {
                throw new CoreException(TokenScanner.createError(20002, e.getMessage(), e));
            }
        } while (ignoreComments && TokenScanner.isComment(curr));
        return curr;
    }

    public int readNext(int offset, boolean ignoreComments) throws CoreException {
        this.setOffset(offset);
        return this.readNext(ignoreComments);
    }

    public int getNextStartOffset(int offset, boolean ignoreComments) throws CoreException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentStartOffset();
    }

    public int getNextEndOffset(int offset, boolean ignoreComments) throws CoreException {
        this.readNext(offset, ignoreComments);
        return this.getCurrentEndOffset();
    }

    public void readToToken(int tok) throws CoreException {
        int curr = 0;
        while ((curr = this.readNext(false)) != tok) {
        }
    }

    public void readToToken(int tok, int offset) throws CoreException {
        this.setOffset(offset);
        this.readToToken(tok);
    }

    public int getTokenStartOffset(int token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentStartOffset();
    }

    public int getTokenEndOffset(int token, int startOffset) throws CoreException {
        this.readToToken(token, startOffset);
        return this.getCurrentEndOffset();
    }

    public int getPreviousTokenEndOffset(int token, int startOffset) throws CoreException {
        this.setOffset(startOffset);
        int res = startOffset;
        int curr = this.readNext(false);
        while (curr != token) {
            res = this.getCurrentEndOffset();
            curr = this.readNext(false);
        }
        return res;
    }

    public int getTokenCommentStart(int lastPos, int nodeStart) throws CoreException {
        this.setOffset(lastPos);
        int prevEndPos = lastPos;
        int prevEndLine = prevEndPos > 0 ? this.getLineOfOffset(prevEndPos - 1) : 0;
        int nodeLine = this.getLineOfOffset(nodeStart);
        int res = -1;
        int curr = this.readNextWithEOF(false);
        int currStartPos = this.getCurrentStartOffset();
        int currStartLine = this.getLineOfOffset(currStartPos);
        while (curr != 158 && nodeStart > currStartPos) {
            if (TokenScanner.isComment(curr)) {
                int linesDifference = currStartLine - prevEndLine;
                if (linesDifference > 1 || res == -1 && (linesDifference != 0 || nodeLine == currStartLine)) {
                    res = currStartPos;
                }
            } else {
                res = -1;
            }
            prevEndLine = curr == 1001 ? currStartLine : this.getLineOfOffset(this.getCurrentEndOffset() - 1);
            curr = this.readNextWithEOF(false);
            currStartPos = this.getCurrentStartOffset();
            currStartLine = this.getLineOfOffset(currStartPos);
        }
        if (res == -1 || curr == 158) {
            return nodeStart;
        }
        if (currStartLine - prevEndLine > 1) {
            return nodeStart;
        }
        return res;
    }

    public int getTokenCommentEnd(int nodeEnd, int nextTokenStart) throws CoreException {
        int linesDifference;
        int currStartLine;
        int prevEndLine = this.getLineOfOffset(nodeEnd - 1);
        int prevEndPos = nodeEnd;
        int res = nodeEnd;
        boolean sameLineComment = true;
        this.setOffset(nodeEnd);
        int curr = this.readNextWithEOF(false);
        while (curr == 1001 || curr == 1002) {
            currStartLine = this.getLineOfOffset(this.getCurrentStartOffset());
            linesDifference = currStartLine - prevEndLine;
            if (linesDifference > 1) {
                return prevEndPos;
            }
            if (curr == 1001) {
                prevEndPos = this.getLineEnd(currStartLine);
                prevEndLine = currStartLine;
            } else {
                prevEndPos = this.getCurrentEndOffset();
                prevEndLine = this.getLineOfOffset(prevEndPos - 1);
            }
            if (sameLineComment) {
                if (linesDifference == 0) {
                    res = prevEndPos;
                } else {
                    sameLineComment = false;
                }
            }
            curr = this.readNextWithEOF(false);
        }
        if (curr == 158) {
            return prevEndPos;
        }
        currStartLine = this.getLineOfOffset(this.getCurrentStartOffset());
        linesDifference = currStartLine - prevEndLine;
        if (linesDifference > 1) {
            return prevEndPos;
        }
        return res;
    }

    private int getLineOfOffset(int offset) throws CoreException {
        if (this.document != null) {
            try {
                return this.document.getLineOfOffset(offset);
            }
            catch (BadLocationException e) {
                String message = "Illegal offset: " + offset;
                throw new CoreException(TokenScanner.createError(20003, message, e));
            }
        }
        return this.getScanner().getLineNumber(offset);
    }

    private int getLineEnd(int line) throws CoreException {
        if (this.document != null) {
            try {
                IRegion region = this.document.getLineInformation(line);
                return region.getOffset() + region.getLength();
            }
            catch (BadLocationException e) {
                String message = "Illegal line: " + line;
                throw new CoreException(TokenScanner.createError(20003, message, e));
            }
        }
        return this.getScanner().getLineEnd(line);
    }

    public static boolean isComment(int token) {
        return token == 1002 || token == 1003 || token == 1001;
    }

    public static boolean isModifier(int token) {
        switch (token) {
            case 85: 
            case 94: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return true;
            }
        }
        return false;
    }

    public static IStatus createError(int code, String message, Throwable throwable) {
        return new Status(4, "org.eclipse.ajdt.core.plugin", code, message, throwable);
    }
}

