/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.hierarchy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.IClassFile;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.Openable;
import org.aspectj.org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.HierarchyType;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.IHierarchyRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class HierarchyBuilder
implements IHierarchyRequestor {
    protected TypeHierarchy hierarchy;
    protected NameLookup nameLookup;
    protected HierarchyResolver hierarchyResolver;
    protected Map infoToHandle;

    public HierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        ICompilationUnit[] unitsToLookInside;
        this.hierarchy = hierarchy;
        JavaProject project = (JavaProject)hierarchy.javaProject();
        IType focusType = hierarchy.getType();
        ICompilationUnit unitToLookInside = focusType == null ? null : focusType.getCompilationUnit();
        ICompilationUnit[] workingCopies = this.hierarchy.workingCopies;
        if (unitToLookInside != null) {
            int wcLength;
            int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
            if (wcLength == 0) {
                unitsToLookInside = new ICompilationUnit[]{unitToLookInside};
            } else {
                unitsToLookInside = new ICompilationUnit[wcLength + 1];
                unitsToLookInside[0] = unitToLookInside;
                System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
            }
        } else {
            unitsToLookInside = workingCopies;
        }
        SearchableEnvironment searchableEnvironment = (SearchableEnvironment)project.newSearchableNameEnvironment(unitsToLookInside);
        this.nameLookup = searchableEnvironment.nameLookup;
        this.hierarchyResolver = new HierarchyResolver(searchableEnvironment, project.getOptions(true), this, new DefaultProblemFactory());
        this.infoToHandle = new HashMap(5);
    }

    public abstract void build(boolean var1) throws JavaModelException, CoreException;

    protected void buildSupertypes() {
        IGenericType type;
        IType focusType = this.getType();
        if (focusType == null) {
            return;
        }
        try {
            type = (IGenericType)((JavaElement)((Object)focusType)).getElementInfo();
        }
        catch (JavaModelException e) {
            return;
        }
        this.hierarchyResolver.resolve(type);
        if (!this.hierarchy.contains(focusType)) {
            this.hierarchy.addRootClass(focusType);
        }
    }

    public void connect(IGenericType suppliedType, IGenericType superclass, IGenericType[] superinterfaces) {
        IType typeHandle = this.getHandle(suppliedType);
        if (typeHandle == null) {
            return;
        }
        IType superHandle = null;
        if (superclass != null) {
            if (superclass instanceof HierarchyResolver.MissingType) {
                this.hierarchy.missingTypes.add(((HierarchyResolver.MissingType)superclass).simpleName);
            } else {
                superHandle = this.getHandle(superclass);
            }
        }
        IType[] interfaceHandles = null;
        if (superinterfaces != null && superinterfaces.length > 0) {
            int length = superinterfaces.length;
            IType[] resolvedInterfaceHandles = new IType[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                IGenericType superInterface = superinterfaces[i];
                if (superInterface != null) {
                    if (superInterface instanceof HierarchyResolver.MissingType) {
                        this.hierarchy.missingTypes.add(((HierarchyResolver.MissingType)superInterface).simpleName);
                    } else {
                        resolvedInterfaceHandles[index] = this.getHandle(superInterface);
                        if (resolvedInterfaceHandles[index] != null) {
                            ++index;
                        }
                    }
                }
                ++i;
            }
            interfaceHandles = new IType[index];
            System.arraycopy(resolvedInterfaceHandles, 0, interfaceHandles, 0, index);
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((JavaElement)((Object)typeHandle)).toStringWithAncestors());
            System.out.println("  to superclass: " + (superHandle == null ? "<None>" : ((JavaElement)((Object)superHandle)).toStringWithAncestors()));
            System.out.print("  and superinterfaces:");
            if (interfaceHandles == null || interfaceHandles.length == 0) {
                System.out.println(" <None>");
            } else {
                System.out.println();
                int i = 0;
                int length = interfaceHandles.length;
                while (i < length) {
                    System.out.println("    " + ((JavaElement)((Object)interfaceHandles[i])).toStringWithAncestors());
                    ++i;
                }
            }
        }
        if (suppliedType.isClass()) {
            if (superHandle == null) {
                this.hierarchy.addRootClass(typeHandle);
            } else {
                this.hierarchy.cacheSuperclass(typeHandle, superHandle);
            }
        } else {
            this.hierarchy.addInterface(typeHandle);
        }
        if (interfaceHandles == null) {
            interfaceHandles = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheSuperInterfaces(typeHandle, interfaceHandles);
        this.hierarchy.cacheFlags(typeHandle, suppliedType.getModifiers());
    }

    protected IType getHandle(IGenericType genericType) {
        if (genericType == null) {
            return null;
        }
        if (genericType instanceof HierarchyType) {
            IType handle = (IType)this.infoToHandle.get(genericType);
            if (handle == null) {
                handle = ((HierarchyType)genericType).typeHandle;
                this.infoToHandle.put(genericType, handle);
            }
            return handle;
        }
        if (genericType.isBinaryType()) {
            IClassFile classFile = (IClassFile)this.infoToHandle.get(genericType);
            if (classFile == null) {
                IType handle = this.lookupBinaryHandle((IBinaryType)genericType);
                if (handle == null) {
                    return null;
                }
                this.infoToHandle.put(genericType, handle.getParent());
                return handle;
            }
            try {
                return classFile.getType();
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        if (genericType instanceof SourceTypeElementInfo) {
            return ((SourceTypeElementInfo)genericType).getHandle();
        }
        return null;
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected IType lookupBinaryHandle(IBinaryType typeInfo) {
        int flag = typeInfo.isClass() ? 2 : 4;
        char[] bName = typeInfo.getName();
        String qualifiedName = new String(ClassFile.translatedName(bName));
        return this.nameLookup.findType(qualifiedName, false, flag);
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    protected org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit createCompilationUnitFromPath(Openable handle, String osPath) {
        return new BasicCompilationUnit(null, null, osPath, handle);
    }

    protected IBinaryType createInfoFromClassFile(Openable handle, String osPath) {
        ClassFileReader info = null;
        try {
            info = ClassFileReader.read(osPath);
        }
        catch (ClassFormatException e) {
            if (TypeHierarchy.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        catch (IOException e) {
            if (TypeHierarchy.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        this.infoToHandle.put(info, handle);
        return info;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBinaryType createInfoFromClassFileInJar(Openable classFile) {
        IJavaElement pkg = classFile.getParent();
        String classFilePath = String.valueOf(pkg.getElementName().replace('.', '/')) + "/" + classFile.getElementName();
        ClassFileReader info = null;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = ((JarPackageFragmentRoot)pkg.getParent()).getJar();
                info = ClassFileReader.read(zipFile, classFilePath);
            }
            catch (ClassFormatException e) {
                if (TypeHierarchy.DEBUG) {
                    e.printStackTrace();
                }
                IBinaryType iBinaryType = null;
                Object var7_12 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iBinaryType;
            }
            catch (IOException e) {
                if (TypeHierarchy.DEBUG) {
                    e.printStackTrace();
                }
                IBinaryType iBinaryType = null;
                Object var7_13 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iBinaryType;
            }
            catch (CoreException e) {
                if (TypeHierarchy.DEBUG) {
                    e.printStackTrace();
                }
                IBinaryType iBinaryType = null;
                Object var7_14 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iBinaryType;
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            throw throwable;
        }
        {
            Object var7_16 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            this.infoToHandle.put(info, classFile);
        }
        return info;
    }
}

