/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.indexing;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public abstract class AbstractIndexer
implements IIndexConstants {
    SearchDocument document;

    public AbstractIndexer(SearchDocument document) {
        this.document = document;
    }

    public void addClassDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[] superclass, char[][] superinterfaces) {
        this.addIndexEntry(IIndexConstants.TYPE_DECL, TypeDeclarationPattern.createIndexKey(name, packageName, enclosingTypeNames, 'C'));
        if (superclass != null) {
            this.addTypeReference(superclass);
        }
        this.addIndexEntry(IIndexConstants.SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'C', superclass, 'C'));
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                this.addTypeReference(superinterfaces[i]);
                this.addIndexEntry(IIndexConstants.SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'C', superinterfaces[i], 'I'));
                ++i;
            }
        }
    }

    public void addConstructorDeclaration(char[] typeName, char[][] parameterTypes, char[][] exceptionTypes) {
        int argCount = parameterTypes == null ? 0 : parameterTypes.length;
        this.addIndexEntry(IIndexConstants.CONSTRUCTOR_DECL, ConstructorPattern.createIndexKey(CharOperation.lastSegment(typeName, '.'), argCount));
        int i = 0;
        while (i < argCount) {
            this.addTypeReference(parameterTypes[i]);
            ++i;
        }
        if (exceptionTypes != null) {
            i = 0;
            int max = exceptionTypes.length;
            while (i < max) {
                this.addTypeReference(exceptionTypes[i]);
                ++i;
            }
        }
    }

    public void addConstructorReference(char[] typeName, int argCount) {
        char[] simpleTypeName = CharOperation.lastSegment(typeName, '.');
        this.addTypeReference(simpleTypeName);
        this.addIndexEntry(IIndexConstants.CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(simpleTypeName, argCount));
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName) {
        this.addIndexEntry(IIndexConstants.FIELD_DECL, FieldPattern.createIndexKey(fieldName));
        this.addTypeReference(typeName);
    }

    public void addFieldReference(char[] fieldName) {
        this.addNameReference(fieldName);
    }

    protected void addIndexEntry(char[] category, char[] key) {
        this.document.addIndexEntry(category, key);
    }

    public void addInterfaceDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[][] superinterfaces) {
        this.addIndexEntry(IIndexConstants.TYPE_DECL, TypeDeclarationPattern.createIndexKey(name, packageName, enclosingTypeNames, 'I'));
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                this.addTypeReference(superinterfaces[i]);
                this.addIndexEntry(IIndexConstants.SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'I', superinterfaces[i], 'I'));
                ++i;
            }
        }
    }

    public void addMethodDeclaration(char[] methodName, char[][] parameterTypes, char[] returnType, char[][] exceptionTypes) {
        int argCount = parameterTypes == null ? 0 : parameterTypes.length;
        this.addIndexEntry(IIndexConstants.METHOD_DECL, MethodPattern.createIndexKey(methodName, argCount));
        int i = 0;
        while (i < argCount) {
            this.addTypeReference(parameterTypes[i]);
            ++i;
        }
        if (exceptionTypes != null) {
            i = 0;
            int max = exceptionTypes.length;
            while (i < max) {
                this.addTypeReference(exceptionTypes[i]);
                ++i;
            }
        }
        if (returnType != null) {
            this.addTypeReference(returnType);
        }
    }

    public void addMethodReference(char[] methodName, int argCount) {
        this.addIndexEntry(IIndexConstants.METHOD_REF, MethodPattern.createIndexKey(methodName, argCount));
    }

    public void addNameReference(char[] name) {
        this.addIndexEntry(IIndexConstants.REF, name);
    }

    public void addTypeReference(char[] typeName) {
        this.addNameReference(CharOperation.lastSegment(typeName, '.'));
    }

    public abstract void indexDocument();
}

