/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.VariablePattern;

public class FieldPattern
extends VariablePattern
implements IIndexConstants {
    protected char[] declaringQualification;
    protected char[] declaringSimpleName;
    protected char[] typeQualification;
    protected char[] typeSimpleName;
    protected static char[][] REF_CATEGORIES = new char[][]{IIndexConstants.REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{IIndexConstants.REF, IIndexConstants.FIELD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{IIndexConstants.FIELD_DECL};

    public static char[] createIndexKey(char[] fieldName) {
        return fieldName;
    }

    public FieldPattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, char[] name, char[] declaringQualification, char[] declaringSimpleName, char[] typeQualification, char[] typeSimpleName, int matchRule) {
        super(64, findDeclarations, readAccess, writeAccess, name, matchRule);
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.typeQualification = this.isCaseSensitive() ? typeQualification : CharOperation.toLowerCase(typeQualification);
        this.typeSimpleName = this.isCaseSensitive() ? typeSimpleName : CharOperation.toLowerCase(typeSimpleName);
        this.mustResolve = this.mustResolve();
    }

    public void decodeIndexKey(char[] key) {
        this.name = key;
    }

    public SearchPattern getBlankPattern() {
        return new FieldPattern(false, false, false, null, null, null, null, null, 8);
    }

    public char[] getIndexKey() {
        return this.name;
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations || this.writeAccess ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    protected boolean mustResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.typeSimpleName != null || this.typeQualification != null) {
            return true;
        }
        return super.mustResolve();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "FieldCombinedPattern: " : "FieldDeclarationPattern: ");
        } else {
            buffer.append("FieldReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.name == null) {
            buffer.append("*");
        } else {
            buffer.append(this.name);
        }
        if (this.typeQualification != null) {
            buffer.append(" --> ").append(this.typeQualification).append('.');
        } else if (this.typeSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.typeSimpleName != null) {
            buffer.append(this.typeSimpleName);
        } else if (this.typeQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

