/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.index.EntryResult;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class InternalSearchPattern {
    IJavaElement focus;
    int kind;
    boolean mustResolve = true;

    void acceptMatch(String documentName, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope) {
        String documentPath = Index.convertPath(documentName);
        if (scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, pattern, participant)) {
            throw new OperationCanceledException();
        }
    }

    SearchPattern currentPattern() {
        return (SearchPattern)this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        block10: {
            block9: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    index.startQuery();
                    SearchPattern pattern = this.currentPattern();
                    EntryResult[] entries = pattern.queryIn(index);
                    if (entries == null) {
                        Object var15_8 = null;
                        break block9;
                    }
                    SearchPattern decodedResult = pattern.getBlankPattern();
                    int i = 0;
                    int l = entries.length;
                    while (i < l) {
                        if (monitor != null && monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        EntryResult entry = entries[i];
                        decodedResult.decodeIndexKey(entry.getWord());
                        if (pattern.matchesDecodedKey(decodedResult)) {
                            String[] names = entry.getDocumentNames(index);
                            int j = 0;
                            int n = names.length;
                            while (j < n) {
                                this.acceptMatch(names[j], decodedResult, requestor, participant, scope);
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var15_9 = null;
                    index.stopQuery();
                    throw throwable;
                }
            }
            index.stopQuery();
            return;
        }
        Object var15_10 = null;
        index.stopQuery();
    }

    boolean isPolymorphicSearch() {
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        SearchPattern pattern = (SearchPattern)this;
        return index.query(pattern.getIndexCategories(), pattern.getIndexKey(), pattern.getMatchRule());
    }
}

