/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchMatch;
import org.aspectj.org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.aspectj.org.eclipse.jdt.internal.core.util.SimpleSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class TypeReferenceLocator
extends PatternLocator {
    protected TypeReferencePattern pattern;
    protected boolean isDeclarationOfReferencedTypesPattern;

    public TypeReferenceLocator(TypeReferencePattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedTypesPattern = this.pattern instanceof DeclarationOfReferencedTypesPattern;
    }

    protected IJavaElement findElement(IJavaElement element, int accuracy) {
        if (accuracy != 0) {
            return null;
        }
        DeclarationOfReferencedTypesPattern declPattern = (DeclarationOfReferencedTypesPattern)this.pattern;
        while (element != null && !declPattern.enclosingElement.equals(element)) {
            element = element.getParent();
        }
        return element;
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        if (!(node instanceof ImportReference)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.matchLevel((ImportReference)node));
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        if (!(node instanceof NameReference)) {
            return 0;
        }
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        if (node instanceof SingleNameReference) {
            if (this.matchesName(this.pattern.simpleName, ((SingleNameReference)node).token)) {
                return nodeSet.addMatch(node, 2);
            }
        } else {
            char[][] tokens = ((QualifiedNameReference)node).tokens;
            int i = 0;
            int max = tokens.length;
            while (i < max) {
                if (this.matchesName(this.pattern.simpleName, tokens[i])) {
                    return nodeSet.addMatch(node, 2);
                }
                ++i;
            }
        }
        return 0;
    }

    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        if (node instanceof SingleTypeReference) {
            if (this.matchesName(this.pattern.simpleName, ((SingleTypeReference)node).token)) {
                return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
            }
        } else {
            char[][] tokens = ((QualifiedTypeReference)node).tokens;
            int i = 0;
            int max = tokens.length;
            while (i < max) {
                if (this.matchesName(this.pattern.simpleName, tokens[i])) {
                    return nodeSet.addMatch(node, 2);
                }
                ++i;
            }
        }
        return 0;
    }

    protected int matchLevel(ImportReference importRef) {
        if (this.pattern.qualification == null) {
            if (this.pattern.simpleName == null) {
                return 3;
            }
            char[][] tokens = importRef.tokens;
            int i = 0;
            int length = tokens.length;
            while (i < length) {
                if (this.matchesName(this.pattern.simpleName, tokens[i])) {
                    return 3;
                }
                ++i;
            }
        } else {
            char[][] tokens = importRef.tokens;
            char[] qualifiedPattern = this.pattern.simpleName == null ? this.pattern.qualification : CharOperation.concat(this.pattern.qualification, this.pattern.simpleName, '.');
            char[] qualifiedTypeName = CharOperation.concatWith(tokens, '.');
            switch (this.matchMode) {
                case 0: 
                case 1: {
                    if (!CharOperation.prefixEquals(qualifiedPattern, qualifiedTypeName, this.isCaseSensitive)) break;
                    return 2;
                }
                case 2: {
                    if (!CharOperation.match(qualifiedPattern, qualifiedTypeName, this.isCaseSensitive)) break;
                    return 2;
                }
            }
        }
        return 0;
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfReferencedTypesPattern) {
            if ((element = this.findElement(element, accuracy)) != null) {
                SimpleSet knownTypes = ((DeclarationOfReferencedTypesPattern)this.pattern).knownTypes;
                while (binding instanceof ReferenceBinding) {
                    ReferenceBinding typeBinding = (ReferenceBinding)binding;
                    this.reportDeclaration(typeBinding, 1, locator, knownTypes);
                    binding = typeBinding.enclosingType();
                }
            }
            return;
        }
        if (binding instanceof ReferenceBinding) {
            int lastIndex = importRef.tokens.length - 1;
            ReferenceBinding typeBinding = (ReferenceBinding)binding;
            if (typeBinding instanceof ProblemReferenceBinding) {
                ProblemReferenceBinding pbBinding = (ProblemReferenceBinding)typeBinding;
                typeBinding = pbBinding.original;
                lastIndex = pbBinding.compoundName.length - 1;
            }
            while (typeBinding != null && lastIndex >= 0) {
                if (this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, typeBinding) == 3) {
                    if (locator.encloses(element)) {
                        long[] positions = importRef.sourcePositions;
                        int start = (int)(positions[this.pattern.qualification == null ? lastIndex : 0] >>> 32);
                        int end = (int)positions[lastIndex];
                        SearchMatch match = locator.newTypeReferenceMatch(element, accuracy, start, end - start + 1, importRef);
                        locator.report(match);
                    }
                    return;
                }
                --lastIndex;
                typeBinding = typeBinding.enclosingType();
            }
        }
        locator.reportAccurateTypeReference(importRef, this.pattern.simpleName, element, accuracy);
    }

    protected void matchReportReference(ArrayTypeReference arrayRef, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (this.pattern.simpleName == null) {
            if (locator.encloses(element)) {
                int offset = arrayRef.sourceStart;
                SearchMatch match = locator.newTypeReferenceMatch(element, accuracy, offset, arrayRef.sourceEnd - offset + 1, arrayRef);
                locator.report(match);
            }
        } else {
            locator.reportAccurateTypeReference(arrayRef, this.pattern.simpleName, element, accuracy);
        }
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfReferencedTypesPattern) {
            if ((element = this.findElement(element, accuracy)) != null) {
                this.reportDeclaration(reference, element, locator, ((DeclarationOfReferencedTypesPattern)this.pattern).knownTypes);
            }
            return;
        }
        if (reference instanceof QualifiedNameReference) {
            this.matchReportReference((QualifiedNameReference)reference, element, accuracy, locator);
        } else if (reference instanceof QualifiedTypeReference) {
            this.matchReportReference((QualifiedTypeReference)reference, element, accuracy, locator);
        } else if (reference instanceof ArrayTypeReference) {
            this.matchReportReference((ArrayTypeReference)reference, element, accuracy, locator);
        } else {
            int offset = reference.sourceStart;
            SearchMatch match = locator.newTypeReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            locator.report(match);
        }
    }

    protected void matchReportReference(QualifiedNameReference qNameRef, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        Binding binding = qNameRef.binding;
        TypeBinding typeBinding = null;
        int lastIndex = qNameRef.tokens.length - 1;
        switch (qNameRef.bits & 7) {
            case 1: {
                typeBinding = qNameRef.actualReceiverType;
                lastIndex -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                break;
            }
            case 4: {
                if (!(binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    typeBinding = qNameRef.actualReceiverType;
                    lastIndex -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                typeBinding = ((ProblemBinding)binding).searchType;
            }
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            ProblemReferenceBinding pbBinding = (ProblemReferenceBinding)typeBinding;
            typeBinding = pbBinding.original;
            lastIndex = pbBinding.compoundName.length - 1;
        }
        if (typeBinding instanceof ReferenceBinding) {
            ReferenceBinding refBinding = (ReferenceBinding)typeBinding;
            while (refBinding != null && lastIndex >= 0) {
                if (this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, refBinding) == 3) {
                    if (locator.encloses(element)) {
                        long[] positions = qNameRef.sourcePositions;
                        int start = (int)(positions[this.pattern.qualification == null ? lastIndex : 0] >>> 32);
                        int end = (int)positions[lastIndex];
                        SearchMatch match = locator.newTypeReferenceMatch(element, accuracy, start, end - start + 1, qNameRef);
                        locator.report(match);
                    }
                    return;
                }
                --lastIndex;
                refBinding = refBinding.enclosingType();
            }
        }
        locator.reportAccurateTypeReference(qNameRef, this.pattern.simpleName, element, accuracy);
    }

    protected void matchReportReference(QualifiedTypeReference qTypeRef, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        TypeBinding typeBinding = qTypeRef.resolvedType;
        int lastIndex = qTypeRef.tokens.length - 1;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            ProblemReferenceBinding pbBinding = (ProblemReferenceBinding)typeBinding;
            typeBinding = pbBinding.original;
            lastIndex = pbBinding.compoundName.length - 1;
        }
        if (typeBinding instanceof ReferenceBinding) {
            ReferenceBinding refBinding = (ReferenceBinding)typeBinding;
            while (refBinding != null && lastIndex >= 0) {
                if (this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, refBinding) == 3) {
                    if (locator.encloses(element)) {
                        long[] positions = qTypeRef.sourcePositions;
                        int start = (int)(positions[this.pattern.qualification == null ? lastIndex : 0] >>> 32);
                        int end = (int)positions[lastIndex];
                        SearchMatch match = locator.newTypeReferenceMatch(element, accuracy, start, end - start + 1, qTypeRef);
                        locator.report(match);
                    }
                    return;
                }
                --lastIndex;
                refBinding = refBinding.enclosingType();
            }
        }
        locator.reportAccurateTypeReference(qTypeRef, this.pattern.simpleName, element, accuracy);
    }

    protected int referenceType() {
        return 7;
    }

    protected void reportDeclaration(ASTNode reference, IJavaElement element, MatchLocator locator, SimpleSet knownTypes) throws CoreException {
        TypeBinding typeBinding;
        int maxType;
        block14: {
            block15: {
                block13: {
                    maxType = -1;
                    typeBinding = null;
                    if (!(reference instanceof TypeReference)) break block13;
                    typeBinding = ((TypeReference)reference).resolvedType;
                    maxType = Integer.MAX_VALUE;
                    break block14;
                }
                if (!(reference instanceof QualifiedNameReference)) break block15;
                QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
                Binding binding = qNameRef.binding;
                maxType = qNameRef.tokens.length - 1;
                switch (qNameRef.bits & 7) {
                    case 1: {
                        typeBinding = qNameRef.actualReceiverType;
                        maxType -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                        break;
                    }
                    case 4: {
                        if (binding instanceof TypeBinding) {
                            typeBinding = (TypeBinding)binding;
                            break;
                        }
                        break block14;
                    }
                    case 3: 
                    case 7: {
                        if (binding instanceof ProblemFieldBinding) {
                            typeBinding = qNameRef.actualReceiverType;
                            maxType -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                            break;
                        }
                        if (binding instanceof ProblemBinding) {
                            ProblemBinding pbBinding = (ProblemBinding)binding;
                            typeBinding = pbBinding.searchType;
                            char[] partialQualifiedName = pbBinding.name;
                            maxType = CharOperation.occurencesOf('.', partialQualifiedName) - 1;
                            if (typeBinding == null || maxType < 0) {
                                return;
                            }
                        }
                        break block14;
                    }
                }
                break block14;
            }
            if (reference instanceof SingleNameReference) {
                typeBinding = (TypeBinding)((SingleNameReference)reference).binding;
                maxType = 1;
            }
        }
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding == null || typeBinding instanceof BaseTypeBinding) {
            return;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).original;
        }
        this.reportDeclaration((ReferenceBinding)typeBinding, maxType, locator, knownTypes);
    }

    protected void reportDeclaration(ReferenceBinding typeBinding, int maxType, MatchLocator locator, SimpleSet knownTypes) throws CoreException {
        IType type = locator.lookupType(typeBinding);
        if (type == null) {
            return;
        }
        IResource resource = type.getResource();
        boolean isBinary = type.isBinary();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
        }
        while (maxType >= 0 && type != null) {
            if (!knownTypes.includes(type)) {
                if (isBinary) {
                    locator.reportBinaryMemberDeclaration(resource, type, info, 0);
                } else {
                    ClassScope scope = ((SourceTypeBinding)typeBinding).scope;
                    if (scope != null) {
                        TypeDeclaration typeDecl = scope.referenceContext;
                        int offset = typeDecl.sourceStart;
                        TypeDeclarationMatch match = new TypeDeclarationMatch(type, 0, offset, typeDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
                        locator.report(match);
                    }
                }
                knownTypes.add(type);
            }
            typeBinding = typeBinding.enclosingType();
            IJavaElement parent = type.getParent();
            type = parent instanceof IType ? (IType)parent : null;
            --maxType;
        }
    }

    public int resolveLevel(ASTNode node) {
        if (node instanceof TypeReference) {
            return this.resolveLevel((TypeReference)node);
        }
        if (node instanceof NameReference) {
            return this.resolveLevel((NameReference)node);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        IPackageFragment pkg;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding typeBinding = (TypeBinding)binding;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).original;
        }
        if (this.pattern.focus instanceof IType && typeBinding instanceof ReferenceBinding && !PackageReferenceLocator.isDeclaringPackageFragment(pkg = ((IType)this.pattern.focus).getPackageFragment(), (ReferenceBinding)typeBinding)) {
            return 0;
        }
        return this.resolveLevelForTypeOrEnclosingTypes(this.pattern.simpleName, this.pattern.qualification, typeBinding);
    }

    protected int resolveLevel(NameReference nameRef) {
        Binding binding = nameRef.binding;
        if (nameRef instanceof SingleNameReference) {
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).original;
            }
            if (binding instanceof ReferenceBinding) {
                return this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, (ReferenceBinding)binding);
            }
            return binding == null || binding instanceof ProblemBinding ? 1 : 0;
        }
        TypeBinding typeBinding = null;
        QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
        switch (qNameRef.bits & 7) {
            case 1: {
                if (qNameRef.tokens.length < (qNameRef.otherBindings == null ? 2 : qNameRef.otherBindings.length + 2)) {
                    return 0;
                }
                typeBinding = nameRef.actualReceiverType;
                break;
            }
            case 2: {
                return 0;
            }
            case 4: {
                if (!(binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    if (qNameRef.tokens.length < (qNameRef.otherBindings == null ? 2 : qNameRef.otherBindings.length + 2)) {
                        return 0;
                    }
                    typeBinding = nameRef.actualReceiverType;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding pbBinding = (ProblemBinding)binding;
                if (CharOperation.occurencesOf('.', pbBinding.name) <= 0) {
                    return 1;
                }
                typeBinding = pbBinding.searchType;
            }
        }
        return this.resolveLevel(typeBinding);
    }

    protected int resolveLevel(TypeReference typeRef) {
        TypeBinding typeBinding = typeRef.resolvedType;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).original;
        }
        if (typeRef instanceof SingleTypeReference) {
            return this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, typeBinding);
        }
        return this.resolveLevelForTypeOrEnclosingTypes(this.pattern.simpleName, this.pattern.qualification, typeBinding);
    }

    protected int resolveLevelForTypeOrEnclosingTypes(char[] simpleNamePattern, char[] qualificationPattern, TypeBinding binding) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding type = (ReferenceBinding)binding;
            char[] qualifiedPattern = PatternLocator.qualifiedPattern(simpleNamePattern, qualificationPattern);
            while (type != null) {
                if (this.resolveLevelForType(qualifiedPattern, type) == 3) {
                    return 3;
                }
                type = type.enclosingType();
            }
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

