/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.AndPattern;

public class TypeReferencePattern
extends AndPattern
implements IIndexConstants {
    protected char[] qualification;
    protected char[] simpleName;
    protected char[] currentCategory;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{IIndexConstants.REF};

    public TypeReferencePattern(char[] qualification, char[] simpleName, int matchRule) {
        this(matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        char[] cArray = this.simpleName = this.isCaseSensitive() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.segments = (char[][])(simpleName == null ? (this.qualification == null ? IIndexConstants.ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification)) : null);
        this.mustResolve = true;
    }

    TypeReferencePattern(int matchRule) {
        super(4, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        this.simpleName = key;
    }

    public SearchPattern getBlankPattern() {
        return new TypeReferencePattern(8);
    }

    public char[] getIndexKey() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    protected boolean hasNextQuery() {
        if (this.segments == null) {
            return false;
        }
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    protected void resetQuery() {
        if (this.segments != null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("TypeReferencePattern: qualification<");
        if (this.qualification != null) {
            buffer.append(this.qualification);
        } else {
            buffer.append("*");
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

