/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.util;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceField;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceImport;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.core.InitializerElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.SourceFieldElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;

public class ElementInfoConverter
implements CompilerModifiers {
    private boolean needLocalTypes;
    private ProblemReporter problemReporter;
    private CompilationUnitDeclaration unit;

    public static CompilationUnitDeclaration buildCompilationUnit(SourceTypeElementInfo[] sourceTypes, boolean needLocalTypes, ProblemReporter problemReporter, CompilationResult compilationResult) {
        return new ElementInfoConverter(needLocalTypes, problemReporter).convert(sourceTypes, compilationResult);
    }

    private ElementInfoConverter(boolean needLocalTypes, ProblemReporter problemReporter) {
        this.needLocalTypes = needLocalTypes;
        this.problemReporter = problemReporter;
    }

    private Initializer convert(InitializerElementInfo initializerInfo, CompilationResult compilationResult) {
        Block block = new Block(0);
        Initializer initializer = new Initializer(block, 0);
        int start = initializerInfo.getDeclarationSourceStart();
        int end = initializerInfo.getDeclarationSourceEnd();
        initializer.name = initializerInfo.getName();
        initializer.sourceStart = initializer.declarationSourceStart = start;
        initializer.sourceEnd = initializer.declarationSourceEnd = end;
        initializer.modifiers = initializerInfo.getModifiers();
        IJavaElement[] children = initializerInfo.getChildren();
        int typesLength = children.length;
        if (typesLength > 0) {
            Statement[] statements = new Statement[typesLength];
            int i = 0;
            while (i < typesLength) {
                JavaElement type = (JavaElement)children[i];
                try {
                    TypeDeclaration localType = this.convert((SourceTypeElementInfo)type.getElementInfo(), compilationResult);
                    if ((localType.bits & 0x200) != 0) {
                        QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                        expression.type = localType.superclass;
                        localType.superclass = null;
                        localType.superInterfaces = null;
                        localType.allocation = expression;
                        statements[i] = expression;
                    } else {
                        statements[i] = localType;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++i;
            }
            block.statements = statements;
        }
        return initializer;
    }

    private FieldDeclaration convert(SourceFieldElementInfo sourceField, CompilationResult compilationResult) {
        IJavaElement[] children;
        int typesLength;
        FieldDeclaration field = new FieldDeclaration();
        int start = sourceField.getNameSourceStart();
        int end = sourceField.getNameSourceEnd();
        field.name = sourceField.getName();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.type = this.createTypeReference(sourceField.getTypeName(), start, end);
        field.declarationSourceStart = sourceField.getDeclarationSourceStart();
        field.declarationSourceEnd = sourceField.getDeclarationSourceEnd();
        field.modifiers = sourceField.getModifiers();
        if (this.needLocalTypes && (typesLength = (children = sourceField.getChildren()).length) > 0) {
            ArrayInitializer initializer = new ArrayInitializer();
            field.initialization = initializer;
            Expression[] expressions = new Expression[typesLength];
            initializer.expressions = expressions;
            int i = 0;
            while (i < typesLength) {
                IJavaElement localType = children[i];
                try {
                    TypeDeclaration anonymousLocalTypeDeclaration = this.convert((SourceTypeElementInfo)((JavaElement)localType).getElementInfo(), compilationResult);
                    QualifiedAllocationExpression expression = new QualifiedAllocationExpression(anonymousLocalTypeDeclaration);
                    expression.type = anonymousLocalTypeDeclaration.superclass;
                    anonymousLocalTypeDeclaration.superclass = null;
                    anonymousLocalTypeDeclaration.superInterfaces = null;
                    anonymousLocalTypeDeclaration.allocation = expression;
                    expressions[i] = expression;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return field;
    }

    private AbstractMethodDeclaration convert(SourceMethodElementInfo sourceMethod, CompilationResult compilationResult) {
        IJavaElement[] children;
        int typesLength;
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int start = sourceMethod.getNameSourceStart();
        int end = sourceMethod.getNameSourceEnd();
        if (sourceMethod.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            method = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = this.createTypeReference(sourceMethod.getReturnTypeName(), start, end);
            method = decl;
        }
        method.selector = sourceMethod.getSelector();
        method.modifiers = sourceMethod.getModifiers();
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = sourceMethod.getDeclarationSourceStart();
        method.declarationSourceEnd = sourceMethod.getDeclarationSourceEnd();
        char[][] argumentTypeNames = sourceMethod.getArgumentTypeNames();
        char[][] argumentNames = sourceMethod.getArgumentNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        long position = (long)start << 32 + end;
        method.arguments = new Argument[argumentCount];
        int i = 0;
        while (i < argumentCount) {
            method.arguments[i] = new Argument(argumentNames[i], position, this.createTypeReference(argumentTypeNames[i], start, end), 0);
            ++i;
        }
        char[][] exceptionTypeNames = sourceMethod.getExceptionTypeNames();
        int exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        method.thrownExceptions = new TypeReference[exceptionCount];
        int i2 = 0;
        while (i2 < exceptionCount) {
            method.thrownExceptions[i2] = this.createTypeReference(exceptionTypeNames[i2], start, end);
            ++i2;
        }
        if (this.needLocalTypes && (typesLength = (children = sourceMethod.getChildren()).length) != 0) {
            Statement[] statements = new Statement[typesLength];
            int i3 = 0;
            while (i3 < typesLength) {
                JavaElement type = (JavaElement)children[i3];
                try {
                    TypeDeclaration localType = this.convert((SourceTypeElementInfo)type.getElementInfo(), compilationResult);
                    if ((localType.bits & 0x200) != 0) {
                        QualifiedAllocationExpression expression = new QualifiedAllocationExpression(localType);
                        expression.type = localType.superclass;
                        localType.superclass = null;
                        localType.superInterfaces = null;
                        localType.allocation = expression;
                        statements[i3] = expression;
                    } else {
                        statements[i3] = localType;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++i3;
            }
            method.statements = statements;
        }
        return method;
    }

    private TypeDeclaration convert(SourceTypeElementInfo sourceType, CompilationResult compilationResult) {
        char[][] interfaceNames;
        int end;
        int start;
        TypeDeclaration type = new TypeDeclaration(compilationResult);
        if (sourceType.getEnclosingType() == null) {
            IType typeHandle = sourceType.getHandle();
            try {
                if (typeHandle.isAnonymous()) {
                    type.name = TypeDeclaration.ANONYMOUS_EMPTY_NAME;
                    type.bits |= 0x300;
                } else if (typeHandle.isLocal()) {
                    type.bits |= 0x100;
                }
            }
            catch (JavaModelException e) {}
        } else {
            type.bits |= 0x400;
        }
        if ((type.bits & 0x200) == 0) {
            type.name = sourceType.getName();
        }
        type.sourceStart = start = sourceType.getNameSourceStart();
        type.sourceEnd = end = sourceType.getNameSourceEnd();
        type.modifiers = sourceType.getModifiers();
        type.declarationSourceStart = sourceType.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = sourceType.getDeclarationSourceEnd();
        if (sourceType.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(sourceType.getSuperclassName(), start, end);
        }
        int interfaceCount = (interfaceNames = sourceType.getInterfaceNames()) == null ? 0 : interfaceNames.length;
        type.superInterfaces = new TypeReference[interfaceCount];
        int i = 0;
        while (i < interfaceCount) {
            type.superInterfaces[i] = this.createTypeReference(interfaceNames[i], start, end);
            ++i;
        }
        ISourceType[] sourceMemberTypes = sourceType.getMemberTypes();
        int sourceMemberTypeCount = sourceMemberTypes == null ? 0 : sourceMemberTypes.length;
        type.memberTypes = new TypeDeclaration[sourceMemberTypeCount];
        int i2 = 0;
        while (i2 < sourceMemberTypeCount) {
            type.memberTypes[i2] = this.convert((SourceTypeElementInfo)sourceMemberTypes[i2], compilationResult);
            ++i2;
        }
        ISourceField[] sourceFields = sourceType.getFields();
        int sourceFieldCount = sourceFields == null ? 0 : sourceFields.length;
        InitializerElementInfo[] initializers = null;
        int initializerCount = 0;
        if (this.needLocalTypes) {
            initializers = sourceType.getInitializers();
            initializerCount = initializers.length;
            type.fields = new FieldDeclaration[initializerCount + sourceFieldCount];
            int i3 = 0;
            while (i3 < initializerCount) {
                type.fields[i3] = this.convert(initializers[i3], compilationResult);
                ++i3;
            }
        } else {
            type.fields = new FieldDeclaration[sourceFieldCount];
        }
        int length = initializerCount + sourceFieldCount;
        int index = 0;
        int i4 = initializerCount;
        while (i4 < length) {
            type.fields[i4] = this.convert((SourceFieldElementInfo)sourceFields[index++], compilationResult);
            ++i4;
        }
        ISourceMethod[] sourceMethods = sourceType.getMethods();
        int sourceMethodCount = sourceMethods == null ? 0 : sourceMethods.length;
        int neededCount = 0;
        if (!type.isInterface()) {
            neededCount = 1;
            int i5 = 0;
            while (i5 < sourceMethodCount) {
                if (sourceMethods[i5].isConstructor()) {
                    neededCount = 0;
                    break;
                }
                ++i5;
            }
        }
        type.methods = new AbstractMethodDeclaration[sourceMethodCount + neededCount];
        if (neededCount != 0) {
            type.methods[0] = type.createsInternalConstructor(false, false);
        }
        boolean isInterface = type.isInterface();
        int i6 = 0;
        while (i6 < sourceMethodCount) {
            AbstractMethodDeclaration method = this.convert((SourceMethodElementInfo)sourceMethods[i6], compilationResult);
            if (isInterface || method.isAbstract()) {
                method.modifiers |= 0x1000000;
            }
            type.methods[neededCount + i6] = method;
            ++i6;
        }
        return type;
    }

    private CompilationUnitDeclaration convert(SourceTypeElementInfo[] sourceTypes, CompilationResult compilationResult) {
        ISourceImport[] sourceImports;
        SourceTypeElementInfo sourceType = sourceTypes[0];
        if (sourceType.getName() == null) {
            return null;
        }
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        int start = sourceType.getNameSourceStart();
        int end = sourceType.getNameSourceEnd();
        if (sourceType.getPackageName() != null && sourceType.getPackageName().length > 0) {
            this.unit.currentPackage = this.createImportReference(sourceType.getPackageName(), start, end, false, 0);
        }
        int importCount = (sourceImports = sourceType.getImports()) == null ? 0 : sourceImports.length;
        this.unit.imports = new ImportReference[importCount];
        int i = 0;
        while (i < importCount) {
            ISourceImport sourceImport = sourceImports[i];
            this.unit.imports[i] = this.createImportReference(sourceImport.getName(), sourceImport.getDeclarationSourceStart(), sourceImport.getDeclarationSourceEnd(), sourceImport.onDemand(), sourceImport.getModifiers());
            ++i;
        }
        int typeCount = sourceTypes.length;
        this.unit.types = new TypeDeclaration[typeCount];
        int i2 = 0;
        while (i2 < typeCount) {
            this.unit.types[i2] = this.convert(sourceTypes[i2], compilationResult);
            ++i2;
        }
        return this.unit;
    }

    private ImportReference createImportReference(char[] importName, int start, int end, boolean onDemand, int modifiers) {
        char[][] qImportName = CharOperation.splitOn('.', importName);
        long[] positions = new long[qImportName.length];
        long position = (long)start << 32 + end;
        int i = 0;
        while (i < qImportName.length) {
            positions[i] = position;
            ++i;
        }
        return new ImportReference(qImportName, positions, onDemand, modifiers);
    }

    private TypeReference createTypeReference(char[] typeSignature, int start, int end) {
        int max;
        int dimStart = max = typeSignature.length;
        int dim = 0;
        int identCount = 1;
        int i = 0;
        while (i < max) {
            switch (typeSignature[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    break;
                }
                case '.': {
                    ++identCount;
                }
            }
            ++i;
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(typeSignature, ((long)start << 32) + (long)end);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(typeSignature, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, ((long)start << 32) + (long)end);
        }
        long[] positions = new long[identCount];
        long pos = ((long)start << 32) + (long)end;
        int i2 = 0;
        while (i2 < identCount) {
            positions[i2] = pos;
            ++i2;
        }
        char[][] identifiers = CharOperation.splitOn('.', typeSignature, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, positions);
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, positions);
    }
}

