/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ZipFileSet;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.tools.ajc.Main;
import org.aspectj.tools.ant.taskdefs.AjcTask;
import org.aspectj.tools.ant.taskdefs.ICommandEditor;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;

public class AjcTask
extends MatchingTask {
    private static final int MAX_COMMANDLINE = 4096;
    private static final File DEFAULT_DESTDIR = new File("."){

        public String toString() {
            return "(no destination dir specified)";
        }
    };
    private static final String USAGE_SUBSTRING = "AspectJ-specific options";
    private static final List VALID_XOPTIONS;
    private static final List VALID_WARNINGS;
    private static final List VALID_DEBUG;
    private static final List VALID_XLINT;
    public static final String COMMAND_EDITOR_NAME;
    static final String[] TARGET_INPUTS;
    static final String[] SOURCE_INPUTS;
    static final String[] COMPLIANCE_INPUTS;
    private static final ICommandEditor COMMAND_EDITOR;
    private boolean verbose;
    private boolean listFileArgs;
    private boolean failonerror;
    private boolean fork;
    private String maxMem;
    protected GuardedCommand cmd;
    private Path srcdir;
    private Path injars;
    private Path inpath;
    private Path classpath;
    private Path bootclasspath;
    private Path forkclasspath;
    private Path extdirs;
    private Path aspectpath;
    private Path argfiles;
    private List ignored;
    private Path sourceRoots;
    private File xweaveDir;
    private String xdoneSignal;
    private List adapterFiles;
    private String[] adapterArguments;
    private IMessageHolder messageHolder;
    private ICommandEditor commandEditor;
    private boolean copyInjars;
    private boolean copyInpath;
    private String sourceRootCopyFilter;
    private File destDir;
    private File outjar;
    private boolean outjarFixedup;
    private File tmpOutjar;
    private boolean executing;
    private Main main;
    private boolean executingInOtherVM;
    private boolean inIncrementalMode;
    private boolean inIncrementalFileMode;
    static /* synthetic */ Class class$org$aspectj$tools$ant$taskdefs$AjcTask;
    static /* synthetic */ Class class$org$aspectj$tools$ajc$Main;

    public String setupAjc(Javac javac) {
        if (null == javac) {
            return "null javac";
        }
        AjcTask ajc = this;
        ajc.setProject(javac.getProject());
        ajc.setLocation(javac.getLocation());
        ajc.setTaskName("javac-iajc");
        ajc.setDebug(javac.getDebug());
        ajc.setDeprecation(javac.getDeprecation());
        ajc.setFailonerror(javac.getFailonerror());
        boolean fork = javac.isForkedJavac();
        ajc.setFork(fork);
        if (fork) {
            ajc.setMaxmem(javac.getMemoryMaximumSize());
        }
        ajc.setNowarn(javac.getNowarn());
        ajc.setListFileArgs(javac.getListfiles());
        ajc.setVerbose(javac.getVerbose());
        ajc.setTarget(javac.getTarget());
        ajc.setSource(javac.getSource());
        ajc.setEncoding(javac.getEncoding());
        File javacDestDir = javac.getDestdir();
        if (null != javacDestDir) {
            ajc.setDestdir(javacDestDir);
            ajc.setSourceRootCopyFilter("**/CVS/*,**/*.java,**/*.aj");
        }
        ajc.setBootclasspath(javac.getBootclasspath());
        ajc.setExtdirs(javac.getExtdirs());
        ajc.setClasspath(javac.getClasspath());
        ajc.addFiles(javac.getFileList());
        ajc.readArguments(javac.getCurrentCompilerArgs());
        return null;
    }

    public static File findAspectjtoolsJar() {
        File result = null;
        ClassLoader loader = (class$org$aspectj$tools$ant$taskdefs$AjcTask == null ? (class$org$aspectj$tools$ant$taskdefs$AjcTask = AjcTask.class$("org.aspectj.tools.ant.taskdefs.AjcTask")) : class$org$aspectj$tools$ant$taskdefs$AjcTask).getClassLoader();
        if (loader instanceof AntClassLoader) {
            AntClassLoader taskLoader = (AntClassLoader)loader;
            String cp = taskLoader.getClasspath();
            String[] cps = LangUtil.splitClasspath(cp);
            int i = 0;
            while (i < cps.length && null == result) {
                result = AjcTask.isAspectjtoolsjar(cps[i]);
                ++i;
            }
        }
        if (null == result) {
            Path classpath = Path.systemClasspath;
            String[] paths = classpath.list();
            int i = 0;
            while (i < paths.length && null == result) {
                result = AjcTask.isAspectjtoolsjar(paths[i]);
                ++i;
            }
        }
        return null == result ? null : result.getAbsoluteFile();
    }

    private static File isAspectjtoolsjar(String path) {
        if (null == path) {
            return null;
        }
        String prefix = "aspectj";
        String infix = "tools";
        String altInfix = "-tools";
        String suffix = ".jar";
        int prefixLength = 7;
        int minLength = 16;
        if (!path.endsWith(".jar")) {
            return null;
        }
        int loc = path.lastIndexOf("aspectj");
        if (-1 != loc && loc + 16 <= path.length()) {
            File result;
            String rest = path.substring(loc + 7);
            if (-1 != rest.indexOf(File.pathSeparator)) {
                return null;
            }
            if ((rest.startsWith("tools") || rest.startsWith("-tools")) && (result = new File(path)).canRead() && result.isFile()) {
                return result;
            }
        }
        return null;
    }

    public AjcTask() {
        this.reset();
    }

    public void reset() {
        this.adapterArguments = null;
        this.adapterFiles = new ArrayList();
        this.argfiles = null;
        this.executing = false;
        this.aspectpath = null;
        this.bootclasspath = null;
        this.classpath = null;
        this.cmd = new GuardedCommand();
        this.copyInjars = false;
        this.copyInpath = false;
        this.destDir = DEFAULT_DESTDIR;
        this.executing = false;
        this.executingInOtherVM = false;
        this.extdirs = null;
        this.failonerror = true;
        this.forkclasspath = null;
        this.inIncrementalMode = false;
        this.inIncrementalFileMode = false;
        this.ignored = new ArrayList();
        this.injars = null;
        this.inpath = null;
        this.listFileArgs = false;
        this.maxMem = null;
        this.messageHolder = null;
        this.outjar = null;
        this.sourceRootCopyFilter = null;
        this.sourceRoots = null;
        this.srcdir = null;
        this.tmpOutjar = null;
        this.verbose = false;
        this.xweaveDir = null;
        this.xdoneSignal = null;
    }

    protected void ignore(String ignored) {
        this.ignored.add(ignored + " at " + this.getLocation());
    }

    protected String validCommaList(String list, List valid, String label) {
        return this.validCommaList(list, valid, label, valid.size());
    }

    protected String validCommaList(String list, List valid, String label, int max) {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(list, ",");
        int num = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (++num > max) {
                this.ignore("too many entries for -" + label + ": " + token);
                break;
            }
            if (!valid.contains(token)) {
                this.ignore("bad commaList entry for -" + label + ": " + token);
                continue;
            }
            if (0 < result.length()) {
                result.append(",");
            }
            result.append(token);
        }
        return 0 == result.length() ? null : result.toString();
    }

    public void setIncremental(boolean incremental) {
        this.cmd.addFlag("-incremental", incremental);
        this.inIncrementalMode = incremental;
    }

    public void setHelp(boolean help) {
        this.cmd.addFlag("-help", help);
    }

    public void setVersion(boolean version) {
        this.cmd.addFlag("-version", version);
    }

    public void setXNoweave(boolean noweave) {
        this.cmd.addFlag("-XnoWeave", noweave);
    }

    public void setXReweavable(boolean reweavable) {
        this.cmd.addFlag("-Xreweavable", reweavable);
    }

    public void setShowWeaveInfo(boolean showweaveinfo) {
        this.cmd.addFlag("-showWeaveInfo", showweaveinfo);
    }

    public void setNowarn(boolean nowarn) {
        this.cmd.addFlag("-nowarn", nowarn);
    }

    public void setDeprecation(boolean deprecation) {
        this.cmd.addFlag("-deprecation", deprecation);
    }

    public void setWarn(String warnings) {
        warnings = this.validCommaList(warnings, VALID_WARNINGS, "warn");
        this.cmd.addFlag("-warn:" + warnings, null != warnings);
    }

    public void setDebug(boolean debug) {
        this.cmd.addFlag("-g", debug);
    }

    public void setDebugLevel(String level) {
        level = this.validCommaList(level, VALID_DEBUG, "g");
        this.cmd.addFlag("-g:" + level, null != level);
    }

    public void setEmacssym(boolean emacssym) {
        this.cmd.addFlag("-emacssym", emacssym);
    }

    public void setXlintwarnings(boolean xlintwarnings) {
        this.cmd.addFlag("-Xlint", xlintwarnings);
    }

    public void setXlint(String xlint) {
        xlint = this.validCommaList(xlint, VALID_XLINT, "Xlint", 1);
        this.cmd.addFlag("-Xlint:" + xlint, null != xlint);
    }

    public void setXlintfile(File xlintFile) {
        this.cmd.addFlagged("-Xlintfile", xlintFile.getAbsolutePath());
    }

    public void setPreserveAllLocals(boolean preserveAllLocals) {
        this.cmd.addFlag("-preserveAllLocals", preserveAllLocals);
    }

    public void setNoImportError(boolean noImportError) {
        this.cmd.addFlag("-warn:-unusedImport", noImportError);
    }

    public void setEncoding(String encoding) {
        this.cmd.addFlagged("-encoding", encoding);
    }

    public void setLog(File file) {
        this.cmd.addFlagged("-log", file.getAbsolutePath());
    }

    public void setProceedOnError(boolean proceedOnError) {
        this.cmd.addFlag("-proceedOnError", proceedOnError);
    }

    public void setVerbose(boolean verbose) {
        this.cmd.addFlag("-verbose", verbose);
        this.verbose = verbose;
    }

    public void setListFileArgs(boolean listFileArgs) {
        this.listFileArgs = listFileArgs;
    }

    public void setReferenceInfo(boolean referenceInfo) {
        this.cmd.addFlag("-referenceInfo", referenceInfo);
    }

    public void setProgress(boolean progress) {
        this.cmd.addFlag("-progress", progress);
    }

    public void setTime(boolean time) {
        this.cmd.addFlag("-time", time);
    }

    public void setNoExit(boolean noExit) {
        this.cmd.addFlag("-noExit", noExit);
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public boolean isForked() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setMaxmem(String maxMem) {
        this.maxMem = maxMem;
    }

    public void setTagFile(File file) {
        this.inIncrementalMode = true;
        this.cmd.addFlagged(Main.CommandController.TAG_FILE_OPTION, file.getAbsolutePath());
        this.inIncrementalFileMode = true;
    }

    public void setOutjar(File file) {
        if (DEFAULT_DESTDIR != this.destDir) {
            String e = "specifying both output jar (" + file + ") and destination dir (" + this.destDir + ")";
            throw new BuildException(e);
        }
        this.outjar = file;
        this.outjarFixedup = false;
        this.tmpOutjar = null;
    }

    public void setDestdir(File dir) {
        if (null != this.outjar) {
            String e = "specifying both output jar (" + this.outjar + ") and destination dir (" + dir + ")";
            throw new BuildException(e);
        }
        this.cmd.addFlagged("-d", dir.getAbsolutePath());
        this.destDir = dir;
    }

    public void setTarget(String input) {
        String ignore = this.cmd.addOption("-target", TARGET_INPUTS, input);
        if (null != ignore) {
            this.ignore(ignore);
        }
    }

    public void setCompliance(String input) {
        String ignore = this.cmd.addOption(null, COMPLIANCE_INPUTS, input);
        if (null != ignore) {
            this.ignore(ignore);
        }
    }

    public void setSource(String input) {
        String ignore = this.cmd.addOption("-source", SOURCE_INPUTS, input);
        if (null != ignore) {
            this.ignore(ignore);
        }
    }

    public void setCopyInjars(boolean doCopy) {
        this.ignore("copyInJars");
        this.log("copyInjars not required since 1.1.1.\n", 1);
    }

    public void setSourceRootCopyFilter(String filter) {
        this.sourceRootCopyFilter = filter;
    }

    public void setX(String input) {
        StringTokenizer tokens = new StringTokenizer(input, ",", false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (1 >= token.length()) continue;
            if (VALID_XOPTIONS.contains(token)) {
                this.cmd.addFlag("-X" + token, true);
                continue;
            }
            this.ignore("-X" + token);
        }
    }

    public void setXDoneSignal(String doneSignal) {
        this.xdoneSignal = doneSignal;
    }

    public void setMessageHolder(IMessageHolder holder) {
        this.messageHolder = holder;
    }

    public void setMessageHolderClass(String className) {
        try {
            Class<?> mclass = Class.forName(className);
            IMessageHolder holder = (IMessageHolder)mclass.newInstance();
            this.setMessageHolder(holder);
        }
        catch (Throwable t) {
            String m = "unable to instantiate message holder: " + className;
            throw new BuildException(m, t);
        }
    }

    public void setCommandEditor(ICommandEditor editor) {
        this.commandEditor = editor;
    }

    public void setCommandEditorClass(String className) {
        try {
            Class<?> mclass = Class.forName(className);
            this.setCommandEditor((ICommandEditor)mclass.newInstance());
        }
        catch (Throwable t) {
            String m = "unable to instantiate command editor: " + className;
            throw new BuildException(m, t);
        }
    }

    protected Path incPath(Path source, Path toAdd) {
        if (null == source) {
            source = new Path(((ProjectComponent)this).project);
        }
        if (null != toAdd) {
            source.append(toAdd);
        }
        return source;
    }

    public void setSourcerootsref(Reference ref) {
        this.createSourceRoots().setRefid(ref);
    }

    public void setSourceRoots(Path roots) {
        this.sourceRoots = this.incPath(this.sourceRoots, roots);
    }

    public Path createSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new Path(((ProjectComponent)this).project);
        }
        return this.sourceRoots.createPath();
    }

    public void setXWeaveDir(File file) {
        if (null != file && file.isDirectory() && file.canRead()) {
            this.xweaveDir = file;
        }
    }

    public void setInjarsref(Reference ref) {
        this.createInjars().setRefid(ref);
    }

    public void setInpathref(Reference ref) {
        this.createInpath().setRefid(ref);
    }

    public void setInjars(Path path) {
        this.injars = this.incPath(this.injars, path);
    }

    public void setInpath(Path path) {
        this.inpath = this.incPath(this.inpath, path);
    }

    public Path createInjars() {
        if (this.injars == null) {
            this.injars = new Path(((ProjectComponent)this).project);
        }
        return this.injars.createPath();
    }

    public Path createInpath() {
        if (this.inpath == null) {
            this.inpath = new Path(((ProjectComponent)this).project);
        }
        return this.inpath.createPath();
    }

    public void setClasspath(Path path) {
        this.classpath = this.incPath(this.classpath, path);
    }

    public void setClasspathref(Reference classpathref) {
        this.createClasspath().setRefid(classpathref);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setBootclasspath(Path path) {
        this.bootclasspath = this.incPath(this.bootclasspath, path);
    }

    public void setBootclasspathref(Reference bootclasspathref) {
        this.createBootclasspath().setRefid(bootclasspathref);
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(((ProjectComponent)this).project);
        }
        return this.bootclasspath.createPath();
    }

    public void setForkclasspath(Path path) {
        this.forkclasspath = this.incPath(this.forkclasspath, path);
    }

    public void setForkclasspathref(Reference forkclasspathref) {
        this.createForkclasspath().setRefid(forkclasspathref);
    }

    public Path createForkclasspath() {
        if (this.forkclasspath == null) {
            this.forkclasspath = new Path(((ProjectComponent)this).project);
        }
        return this.forkclasspath.createPath();
    }

    public void setExtdirs(Path path) {
        this.extdirs = this.incPath(this.extdirs, path);
    }

    public void setExtdirsref(Reference ref) {
        this.createExtdirs().setRefid(ref);
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(((ProjectComponent)this).project);
        }
        return this.extdirs.createPath();
    }

    public void setAspectpathref(Reference ref) {
        this.createAspectpath().setRefid(ref);
    }

    public void setAspectpath(Path path) {
        this.aspectpath = this.incPath(this.aspectpath, path);
    }

    public Path createAspectpath() {
        if (this.aspectpath == null) {
            this.aspectpath = new Path(((ProjectComponent)this).project);
        }
        return this.aspectpath.createPath();
    }

    public void setSrcDir(Path path) {
        this.srcdir = this.incPath(this.srcdir, path);
    }

    public Path createSrc() {
        return this.createSrcdir();
    }

    public Path createSrcdir() {
        if (this.srcdir == null) {
            this.srcdir = new Path(((ProjectComponent)this).project);
        }
        return this.srcdir.createPath();
    }

    public boolean isInIncrementalMode() {
        return this.inIncrementalMode;
    }

    public boolean isInIncrementalFileMode() {
        return this.inIncrementalFileMode;
    }

    public void setArgfilesref(Reference ref) {
        this.createArgfiles().setRefid(ref);
    }

    public void setArgfiles(Path path) {
        this.argfiles = this.incPath(this.argfiles, path);
    }

    public Path createArgfiles() {
        if (this.argfiles == null) {
            this.argfiles = new Path(((ProjectComponent)this).project);
        }
        return this.argfiles.createPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.executing) {
            throw new IllegalStateException("already executing");
        }
        this.executing = true;
        this.setupOptions();
        this.verifyOptions();
        try {
            try {
                String[] args = this.makeCommand();
                if (this.verbose || this.listFileArgs) {
                    this.log("ajc " + Arrays.asList(args), 3);
                }
                if (!this.fork) {
                    this.executeInSameVM(args);
                } else {
                    this.executeInOtherVM(args);
                }
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Throwable x) {
                System.err.println(Main.renderExceptionForUser(x));
                throw new BuildException("IGNORE -- See " + LangUtil.unqualifiedClassName(x) + " rendered to System.err");
            }
            Object var4_3 = null;
            this.executing = false;
            if (null == this.tmpOutjar) return;
            this.tmpOutjar.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.executing = false;
            if (null == this.tmpOutjar) throw throwable;
            this.tmpOutjar.delete();
            throw throwable;
        }
    }

    public boolean quit() {
        if (this.executingInOtherVM) {
            return false;
        }
        Main me = this.main;
        if (null != me) {
            me.quit();
        }
        return true;
    }

    String[] makeCommand() {
        ArrayList result = new ArrayList();
        if (0 < this.ignored.size()) {
            Iterator iter = this.ignored.iterator();
            while (iter.hasNext()) {
                this.log("ignored: " + iter.next(), 2);
            }
        }
        if (null != this.outjar && !this.outjarFixedup) {
            if (this.copyInjars || this.copyInpath || null != this.sourceRootCopyFilter) {
                String path = this.outjar.getAbsolutePath();
                int len = FileUtil.zipSuffixLength(path);
                if (len < 1) {
                    this.log("not copying resources - weird outjar: " + path);
                } else {
                    path = path.substring(0, path.length() - len) + ".tmp.jar";
                    this.tmpOutjar = new File(path);
                }
            }
            if (null == this.tmpOutjar) {
                this.cmd.addFlagged("-outjar", this.outjar.getAbsolutePath());
            } else {
                this.cmd.addFlagged("-outjar", this.tmpOutjar.getAbsolutePath());
            }
            this.outjarFixedup = true;
        }
        result.addAll(this.cmd.extractArguments());
        this.addListArgs(result);
        String[] command = result.toArray(new String[0]);
        if (null != this.commandEditor) {
            command = this.commandEditor.editCommand(command);
        } else if (null != COMMAND_EDITOR) {
            command = COMMAND_EDITOR.editCommand(command);
        }
        return command;
    }

    protected void setupOptions() {
        if (null != this.xweaveDir) {
            if (DEFAULT_DESTDIR != this.destDir) {
                throw new BuildException("weaveDir forces destdir");
            }
            if (null != this.outjar) {
                throw new BuildException("weaveDir forces outjar");
            }
            if (null != this.injars) {
                throw new BuildException("weaveDir incompatible with injars now");
            }
            if (null != this.inpath) {
                throw new BuildException("weaveDir incompatible with inpath now");
            }
            File injar = this.zipDirectory(this.xweaveDir);
            this.setInjars(new Path(this.getProject(), injar.getAbsolutePath()));
            this.setDestdir(this.xweaveDir);
        }
    }

    protected File zipDirectory(File dir) {
        File tempDir = new File(".");
        try {
            tempDir = File.createTempFile("AjcTest", ".tmp");
            tempDir.mkdirs();
            tempDir.deleteOnExit();
        }
        catch (IOException e) {
            // empty catch block
        }
        String filename = "AjcTask-" + System.currentTimeMillis() + ".zip";
        File result = new File(filename);
        Zip zip = new Zip();
        zip.setProject(this.getProject());
        zip.setDestFile(result);
        zip.setTaskName(this.getTaskName() + " - zip");
        FileSet fileset = new FileSet();
        fileset.setDir(dir);
        zip.addFileset(fileset);
        zip.execute();
        Delete delete = new Delete();
        delete.setProject(this.getProject());
        delete.setTaskName(this.getTaskName() + " - delete");
        delete.setDir(dir);
        delete.execute();
        Mkdir mkdir = new Mkdir();
        mkdir.setProject(this.getProject());
        mkdir.setTaskName(this.getTaskName() + " - mkdir");
        mkdir.setDir(dir);
        mkdir.execute();
        return result;
    }

    protected void verifyOptions() {
        StringBuffer sb = new StringBuffer();
        if (this.fork && this.isInIncrementalMode() && !this.isInIncrementalFileMode()) {
            sb.append("can fork incremental only using tag file.\n");
        }
        if (null != this.sourceRootCopyFilter && null == this.outjar && DEFAULT_DESTDIR == this.destDir) {
            String REQ = " requires dest dir or output jar.\n";
            sb.append("sourceRootCopyFilter");
            sb.append(" requires dest dir or output jar.\n");
        }
        if (0 < sb.length()) {
            throw new BuildException(sb.toString());
        }
    }

    protected void executeInSameVM(String[] args) {
        block16: {
            Object[] fails;
            int numPreviousErrors;
            IMessageHolder holder;
            if (null != this.maxMem) {
                this.log("maxMem ignored unless forked: " + this.maxMem, 1);
            }
            if (null == (holder = this.messageHolder)) {
                MessageHandler mhandler = new MessageHandler(true);
                IMessageHandler delegate = this.verbose ? Main.MessagePrinter.VERBOSE : Main.MessagePrinter.TERSE;
                mhandler.setInterceptor(delegate);
                if (!this.verbose) {
                    mhandler.ignore(IMessage.INFO);
                }
                holder = mhandler;
                numPreviousErrors = 0;
            } else {
                numPreviousErrors = holder.numMessages(IMessage.ERROR, true);
            }
            Main newmain = new Main();
            newmain.setHolder(holder);
            newmain.setCompletionRunner(new Runnable(){

                public void run() {
                    AjcTask.this.doCompletionTasks();
                }
            });
            if (null != this.main) {
                MessageUtil.fail(holder, "still running prior main");
                return;
            }
            this.main = newmain;
            try {
                this.main.runMain(args, false);
                Object var7_6 = null;
                this.main = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.main = null;
                throw throwable;
            }
            if (this.failonerror) {
                int errs = holder.numMessages(IMessage.ERROR, false);
                if (0 < (errs -= numPreviousErrors)) {
                    String m = errs + " errors";
                    MessageUtil.print(System.err, holder, "", MessageUtil.MESSAGE_ALL, MessageUtil.PICK_ERROR, true);
                    throw new BuildException(m);
                }
            }
            if (LangUtil.isEmpty(fails = holder.getMessages(IMessage.FAIL, true))) break block16;
            StringBuffer sb = new StringBuffer();
            String prefix = "fail due to ";
            int numThrown = 0;
            int i = 0;
            while (i < fails.length) {
                block19: {
                    String message;
                    block18: {
                        block17: {
                            message = fails[i].getMessage();
                            if (!LangUtil.isEmpty(message)) break block17;
                            message = "<no message>";
                            break block18;
                        }
                        if (-1 != message.indexOf(USAGE_SUBSTRING)) break block19;
                    }
                    Throwable t = fails[i].getThrown();
                    if (null != t) {
                        ++numThrown;
                        sb.append(prefix);
                        sb.append(LangUtil.unqualifiedClassName(t.getClass()));
                        String thrownMessage = t.getMessage();
                        if (!LangUtil.isEmpty(thrownMessage)) {
                            sb.append(" \"" + thrownMessage + "\"");
                        }
                    }
                    sb.append("\"" + message + "\"");
                    prefix = ", ";
                }
                ++i;
            }
            if (0 < sb.length()) {
                sb.append(" (" + numThrown + " exceptions)");
                throw new BuildException(sb.toString());
            }
        }
    }

    protected void executeInOtherVM(String[] args) {
        block15: {
            if (null != this.messageHolder) {
                this.log("message holder ignored when forking: " + this.messageHolder.getClass().getName(), 1);
            }
            CommandlineJava javaCmd = new CommandlineJava();
            javaCmd.setClassname((class$org$aspectj$tools$ajc$Main == null ? (class$org$aspectj$tools$ajc$Main = AjcTask.class$("org.aspectj.tools.ajc.Main")) : class$org$aspectj$tools$ajc$Main).getName());
            Path vmClasspath = javaCmd.createClasspath(this.getProject());
            File aspectjtools = null;
            int vmClasspathSize = vmClasspath.size();
            if (null != this.forkclasspath && 0 != this.forkclasspath.size()) {
                vmClasspath.addExisting(this.forkclasspath);
            } else {
                aspectjtools = AjcTask.findAspectjtoolsJar();
                if (null != aspectjtools) {
                    vmClasspath.createPathElement().setLocation(aspectjtools);
                }
            }
            int newVmClasspathSize = vmClasspath.size();
            if (vmClasspathSize == newVmClasspathSize) {
                String m = "unable to find aspectjtools to fork - ";
                m = null != aspectjtools ? m + "tried " + aspectjtools.toString() : (null != this.forkclasspath ? m + "tried " + this.forkclasspath.toString() : m + "define forkclasspath or put aspectjtools on classpath");
                throw new BuildException(m);
            }
            if (null != this.maxMem) {
                javaCmd.setMaxmemory(this.maxMem);
            }
            File tempFile = null;
            int numArgs = args.length;
            if ((args = GuardedCommand.limitTo(args, 4096, this.getLocation())).length != numArgs) {
                tempFile = new File(args[1]);
            }
            try {
                int result;
                String[] javaArgs = javaCmd.getCommandline();
                String[] both = new String[javaArgs.length + args.length];
                System.arraycopy(javaArgs, 0, both, 0, javaArgs.length);
                System.arraycopy(args, 0, both, javaArgs.length, args.length);
                if (both[0].endsWith("java.exe")) {
                    String path = both[0];
                    path = path.substring(0, path.length() - 4);
                    File javaw = new File(path = path + "w.exe");
                    if (javaw.canRead() && javaw.isFile()) {
                        both[0] = path;
                    }
                }
                if (this.verbose) {
                    this.log("forking " + Arrays.asList(both));
                }
                if (0 > (result = this.execInOtherVM(both))) {
                    throw new BuildException("failure[" + result + "] running ajc");
                }
                if (this.failonerror && 0 < result) {
                    throw new BuildException("compile errors: " + result);
                }
                this.doCompletionTasks();
                Object var11_13 = null;
                if (null == tempFile) break block15;
                tempFile.delete();
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (null != tempFile) {
                    tempFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    protected int execInOtherVM(String[] args) {
        try {
            Project project = this.getProject();
            LogStreamHandler handler = new LogStreamHandler((Task)this, 2, 1);
            Execute exe = new Execute((ExecuteStreamHandler)handler);
            exe.setAntRun(project);
            exe.setWorkingDirectory(project.getBaseDir());
            exe.setCommandline(args);
            try {
                if (this.executingInOtherVM) {
                    String s = "already running in other vm?";
                    throw new BuildException(s, ((Task)this).location);
                }
                this.executingInOtherVM = true;
                exe.execute();
                Object var7_8 = null;
                this.executingInOtherVM = false;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.executingInOtherVM = false;
                throw throwable;
            }
            return exe.getExitValue();
        }
        catch (IOException e) {
            String m = "Error executing command " + Arrays.asList(args);
            throw new BuildException(m, (Throwable)e, ((Task)this).location);
        }
    }

    protected static void addFlaggedPath(String flag, Path path, List list) {
        if (!LangUtil.isEmpty(flag) && null != path && 0 < path.size()) {
            list.add(flag);
            list.add(path.toString());
        }
    }

    protected void addListArgs(List list) throws BuildException {
        int i;
        AjcTask.addFlaggedPath("-classpath", this.classpath, list);
        AjcTask.addFlaggedPath("-bootclasspath", this.bootclasspath, list);
        AjcTask.addFlaggedPath("-extdirs", this.extdirs, list);
        AjcTask.addFlaggedPath("-aspectpath", this.aspectpath, list);
        AjcTask.addFlaggedPath("-injars", this.injars, list);
        AjcTask.addFlaggedPath("-inpath", this.inpath, list);
        AjcTask.addFlaggedPath("-sourceroots", this.sourceRoots, list);
        if (this.argfiles != null) {
            String[] files = this.argfiles.list();
            i = 0;
            while (i < files.length) {
                File argfile = ((ProjectComponent)this).project.resolveFile(files[i]);
                if (this.check(argfile, files[i], false, ((Task)this).location)) {
                    list.add("-argfile");
                    list.add(argfile.getAbsolutePath());
                }
                ++i;
            }
        }
        if (this.srcdir != null) {
            String[] dirs = this.srcdir.list();
            i = 0;
            while (i < dirs.length) {
                File dir = ((ProjectComponent)this).project.resolveFile(dirs[i]);
                this.check(dir, dirs[i], true, ((Task)this).location);
                String[] files = this.getDirectoryScanner(dir).getIncludedFiles();
                int j = 0;
                while (j < files.length) {
                    File file = new File(dir, files[j]);
                    if (FileUtil.hasSourceSuffix(file)) {
                        list.add(file.getAbsolutePath());
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (0 < this.adapterFiles.size()) {
            Iterator iter = this.adapterFiles.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                if (file.canRead() && FileUtil.hasSourceSuffix(file)) {
                    list.add(file.getAbsolutePath());
                    continue;
                }
                this.log("skipping file: " + file, 1);
            }
        }
    }

    protected final boolean check(File file, String name, boolean isDir, Location loc) {
        Location location = loc = loc != null ? loc : ((Task)this).location;
        if (file == null) {
            throw new BuildException(name + " is null!", loc);
        }
        if (!file.exists()) {
            throw new BuildException(file + " doesn't exist!", loc);
        }
        if (isDir ^ file.isDirectory()) {
            String e = file + " should" + (isDir ? "" : "n't") + " be a directory!";
            throw new BuildException(e, loc);
        }
        return true;
    }

    protected void doCompletionTasks() {
        if (!this.executing) {
            throw new IllegalStateException("should be executing");
        }
        if (null != this.outjar) {
            this.completeOutjar();
        } else {
            this.completeDestdir();
        }
        if (null != this.xdoneSignal) {
            MessageUtil.info(this.messageHolder, this.xdoneSignal);
        }
    }

    private void completeDestdir() {
        Object[] paths;
        if (!this.copyInjars && null == this.sourceRootCopyFilter) {
            return;
        }
        if (this.destDir == DEFAULT_DESTDIR || !this.destDir.canWrite()) {
            String s = "unable to copy resources to destDir: " + this.destDir;
            throw new BuildException(s);
        }
        Project project = this.getProject();
        if (this.copyInjars) {
            if (null != this.inpath) {
                this.log("copyInjars does not support inpath.\n", 1);
            }
            String taskName = this.getTaskName() + " - unzip";
            Object[] paths2 = this.injars.list();
            if (!LangUtil.isEmpty(paths2)) {
                PatternSet patternSet = new PatternSet();
                patternSet.setProject(project);
                patternSet.setIncludes("**/*");
                patternSet.setExcludes("**/*.class");
                int i = 0;
                while (i < paths2.length) {
                    Expand unzip = new Expand();
                    unzip.setProject(project);
                    unzip.setTaskName(taskName);
                    unzip.setDest(this.destDir);
                    unzip.setSrc(new File((String)paths2[i]));
                    unzip.addPatternset(patternSet);
                    unzip.execute();
                    ++i;
                }
            }
        }
        if (null != this.sourceRootCopyFilter && null != this.sourceRoots && !LangUtil.isEmpty(paths = this.sourceRoots.list())) {
            Copy copy = new Copy();
            copy.setProject(project);
            copy.setTodir(this.destDir);
            int i = 0;
            while (i < paths.length) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File((String)paths[i]));
                fileSet.setIncludes("**/*");
                fileSet.setExcludes(this.sourceRootCopyFilter);
                copy.addFileset(fileSet);
                ++i;
            }
            copy.execute();
        }
    }

    private void completeOutjar() {
        int i;
        Object[] paths;
        if (null == this.tmpOutjar || !this.tmpOutjar.canRead() || !this.copyInjars && null == this.sourceRootCopyFilter) {
            return;
        }
        Zip zip = new Zip();
        Project project = this.getProject();
        zip.setProject(project);
        zip.setTaskName(this.getTaskName() + " - zip");
        zip.setDestFile(this.outjar);
        ZipFileSet zipfileset = new ZipFileSet();
        zipfileset.setProject(project);
        zipfileset.setSrc(this.tmpOutjar);
        zipfileset.setIncludes("**/*.class");
        zip.addZipfileset(zipfileset);
        if (this.copyInjars && !LangUtil.isEmpty(paths = this.injars.list())) {
            i = 0;
            while (i < paths.length) {
                File jarFile = new File((String)paths[i]);
                zipfileset = new ZipFileSet();
                zipfileset.setProject(project);
                zipfileset.setSrc(jarFile);
                zipfileset.setIncludes("**/*");
                zipfileset.setExcludes("**/*.class");
                zip.addZipfileset(zipfileset);
                ++i;
            }
        }
        if (null != this.sourceRootCopyFilter && null != this.sourceRoots && !LangUtil.isEmpty(paths = this.sourceRoots.list())) {
            i = 0;
            while (i < paths.length) {
                File srcRoot = new File((String)paths[i]);
                FileSet fileset = new FileSet();
                fileset.setProject(project);
                fileset.setDir(srcRoot);
                fileset.setIncludes("**/*");
                fileset.setExcludes(this.sourceRootCopyFilter);
                zip.addFileset(fileset);
                ++i;
            }
        }
        zip.execute();
    }

    void addFiles(File[] paths) {
        int i = 0;
        while (i < paths.length) {
            this.addFile(paths[i]);
            ++i;
        }
    }

    void addFile(File path) {
        if (null != path) {
            this.adapterFiles.add(path);
        }
    }

    public void readArguments(String[] args) {
        if (null == args || 0 == args.length) {
            return;
        }
        class Args {
            final String[] args;
            int index;
            private final /* synthetic */ AjcTask this$0;

            Args(AjcTask this$0, String[] args) {
                this.this$0 = this$0;
                this.index = 0;
                this.args = args;
            }

            boolean hasNext() {
                return this.index < this.args.length;
            }

            String next() {
                String s;
                String err = null;
                if (!this.hasNext()) {
                    err = "need arg for flag " + this.args[this.args.length - 1];
                } else if (null == (s = this.args[this.index++])) {
                    err = "null value";
                } else if (0 == (s = s.trim()).trim().length()) {
                    err = "no value";
                } else {
                    return s;
                }
                err = err + " at [" + this.index + "] of " + Arrays.asList(this.args);
                throw new BuildException(err);
            }
        }
        Args in = new Args(this, args);
        while (in.hasNext()) {
            File file;
            String flag = in.next();
            if ("-1.3".equals(flag)) {
                this.setCompliance(flag);
                continue;
            }
            if ("-1.4".equals(flag)) {
                this.setCompliance(flag);
                continue;
            }
            if ("-argfile".equals(flag)) {
                this.setArgfiles(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-aspectpath".equals(flag)) {
                this.setAspectpath(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-classpath".equals(flag)) {
                this.setClasspath(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-extdirs".equals(flag)) {
                this.setExtdirs(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-Xcopyinjars".equals(flag)) {
                this.setCopyInjars(true);
                continue;
            }
            if ("-g".equals(flag)) {
                this.setDebug(true);
                continue;
            }
            if (flag.startsWith("-g:")) {
                this.setDebugLevel(flag.substring(2));
                continue;
            }
            if ("-deprecation".equals(flag)) {
                this.setDeprecation(true);
                continue;
            }
            if ("-d".equals(flag)) {
                this.setDestdir(new File(in.next()));
                continue;
            }
            if ("-emacssym".equals(flag)) {
                this.setEmacssym(true);
                continue;
            }
            if ("-encoding".equals(flag)) {
                this.setEncoding(in.next());
                continue;
            }
            if ("-Xfailonerror".equals(flag)) {
                this.setFailonerror(true);
                continue;
            }
            if ("-fork".equals(flag)) {
                this.setFork(true);
                continue;
            }
            if ("-forkclasspath".equals(flag)) {
                this.setForkclasspath(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-help".equals(flag)) {
                this.setHelp(true);
                continue;
            }
            if ("-incremental".equals(flag)) {
                this.setIncremental(true);
                continue;
            }
            if ("-injars".equals(flag)) {
                this.setInjars(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-inpath".equals(flag)) {
                this.setInpath(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-Xlistfileargs".equals(flag)) {
                this.setListFileArgs(true);
                continue;
            }
            if ("-Xmaxmem".equals(flag)) {
                this.setMaxmem(in.next());
                continue;
            }
            if ("-Xmessageholderclass".equals(flag)) {
                this.setMessageHolderClass(in.next());
                continue;
            }
            if ("-noexit".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-noimport".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-noExit".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-noImportError".equals(flag)) {
                this.setNoImportError(true);
                continue;
            }
            if ("-noWarn".equals(flag)) {
                this.setNowarn(true);
                continue;
            }
            if ("-noexit".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-outjar".equals(flag)) {
                this.setOutjar(new File(in.next()));
                continue;
            }
            if ("-preserveAllLocals".equals(flag)) {
                this.setPreserveAllLocals(true);
                continue;
            }
            if ("-proceedOnError".equals(flag)) {
                this.setProceedOnError(true);
                continue;
            }
            if ("-progress".equals(flag)) {
                this.setProgress(true);
                continue;
            }
            if ("-referenceInfo".equals(flag)) {
                this.setReferenceInfo(true);
                continue;
            }
            if ("-source".equals(flag)) {
                this.setSource(in.next());
                continue;
            }
            if ("-Xsourcerootcopyfilter".equals(flag)) {
                this.setSourceRootCopyFilter(in.next());
                continue;
            }
            if ("-sourceroots".equals(flag)) {
                this.setSourceRoots(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-Xsrcdir".equals(flag)) {
                this.setSrcDir(new Path(((ProjectComponent)this).project, in.next()));
                continue;
            }
            if ("-Xtagfile".equals(flag)) {
                this.setTagFile(new File(in.next()));
                continue;
            }
            if ("-target".equals(flag)) {
                this.setTarget(in.next());
                continue;
            }
            if ("-time".equals(flag)) {
                this.setTime(true);
                continue;
            }
            if ("-time".equals(flag)) {
                this.setTime(true);
                continue;
            }
            if ("-verbose".equals(flag)) {
                this.setVerbose(true);
                continue;
            }
            if ("-version".equals(flag)) {
                this.setVersion(true);
                continue;
            }
            if ("-warn".equals(flag)) {
                this.setWarn(in.next());
                continue;
            }
            if (flag.startsWith("-warn:")) {
                this.setWarn(flag.substring(6));
                continue;
            }
            if ("-Xlint".equals(flag)) {
                this.setXlintwarnings(true);
                continue;
            }
            if (flag.startsWith("-Xlint:")) {
                this.setXlint(flag.substring(7));
                continue;
            }
            if ("-Xlintfile".equals(flag)) {
                this.setXlintfile(new File(in.next()));
                continue;
            }
            if ("-Xnoweave".equals(flag)) {
                this.setXNoweave(true);
                continue;
            }
            if ("-Xreweavable".equals(flag)) {
                this.setXReweavable(true);
                continue;
            }
            if (flag.startsWith("@")) {
                file = new File(flag.substring(1));
                if (file.canRead()) {
                    this.setArgfiles(new Path(((ProjectComponent)this).project, file.getPath()));
                    continue;
                }
                this.ignore(flag);
                continue;
            }
            file = new File(flag);
            if (file.isFile() && file.canRead() && FileUtil.hasSourceSuffix(file)) {
                this.addFile(file);
                continue;
            }
            this.ignore(flag);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        COMMAND_EDITOR_NAME = (class$org$aspectj$tools$ant$taskdefs$AjcTask == null ? (class$org$aspectj$tools$ant$taskdefs$AjcTask = AjcTask.class$("org.aspectj.tools.ant.taskdefs.AjcTask")) : class$org$aspectj$tools$ant$taskdefs$AjcTask).getName() + ".COMMAND_EDITOR";
        TARGET_INPUTS = new String[]{"1.1", "1.2", "1.3", "1.4"};
        SOURCE_INPUTS = new String[]{"1.3", "1.4"};
        COMPLIANCE_INPUTS = new String[]{"-1.3", "-1.4"};
        String[] xs = new String[]{"serializableAspects", "incrementalFile", "lazyTjp", "reweavable", "reweavable:compress", "noInline"};
        VALID_XOPTIONS = Collections.unmodifiableList(Arrays.asList(xs));
        xs = new String[]{"constructorName", "packageDefaultMethod", "deprecation", "maskedCatchBlocks", "unusedLocals", "unusedArguments", "unusedImports", "syntheticAccess", "assertIdentifier", "none"};
        VALID_WARNINGS = Collections.unmodifiableList(Arrays.asList(xs));
        xs = new String[]{"none", "lines", "vars", "source"};
        VALID_DEBUG = Collections.unmodifiableList(Arrays.asList(xs));
        xs = new String[]{"error", "warning", "ignore"};
        VALID_XLINT = Collections.unmodifiableList(Arrays.asList(xs));
        ICommandEditor editor = null;
        try {
            String editorClassName = System.getProperty(COMMAND_EDITOR_NAME);
            if (null != editorClassName) {
                ClassLoader cl = (class$org$aspectj$tools$ant$taskdefs$AjcTask == null ? (class$org$aspectj$tools$ant$taskdefs$AjcTask = AjcTask.class$("org.aspectj.tools.ant.taskdefs.AjcTask")) : class$org$aspectj$tools$ant$taskdefs$AjcTask).getClassLoader();
                Class<?> editorClass = cl.loadClass(editorClassName);
                editor = (ICommandEditor)editorClass.newInstance();
            }
        }
        catch (Throwable t) {
            System.err.println("Warning: unable to load command editor");
            t.printStackTrace(System.err);
        }
        COMMAND_EDITOR = editor;
    }

    public static class GuardedCommand {
        Commandline command = new Commandline();

        static boolean isEmpty(String s) {
            return null == s || 0 == s.trim().length();
        }

        GuardedCommand() {
        }

        void addFlag(String flag, boolean doAdd) {
            if (doAdd && !GuardedCommand.isEmpty(flag)) {
                this.command.createArgument().setValue(flag);
            }
        }

        String addOption(String prefix, String[] validOptions, String input) {
            if (GuardedCommand.isEmpty(input)) {
                return null;
            }
            int i = 0;
            while (i < validOptions.length) {
                if (input.equals(validOptions[i])) {
                    if (GuardedCommand.isEmpty(prefix)) {
                        this.addFlag(input, true);
                    } else {
                        this.addFlagged(prefix, input);
                    }
                    return null;
                }
                ++i;
            }
            return null == prefix ? input : prefix + " " + input;
        }

        void addFlagged(String flag, String argument) {
            if (!GuardedCommand.isEmpty(flag) && !GuardedCommand.isEmpty(argument)) {
                this.command.addArguments(new String[]{flag, argument});
            }
        }

        List extractArguments() {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] cmds = this.command.getArguments();
            if (!LangUtil.isEmpty(cmds)) {
                result.addAll(Arrays.asList(cmds));
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static String[] limitTo(String[] args, int max, Location location) {
            if (max < 0) {
                throw new IllegalArgumentException("negative max: " + max);
            }
            int size = 0;
            int i = 0;
            while (i < args.length && size < max) {
                size += 1 + (null == args[i] ? 0 : args[i].length());
                ++i;
            }
            if (size <= max) {
                return args;
            }
            File tmpFile = null;
            PrintWriter out = null;
            try {
                try {
                    String userDirName = System.getProperty("user.dir");
                    File userDir = new File(userDirName);
                    tmpFile = File.createTempFile("argfile", "", userDir);
                    out = new PrintWriter(new FileWriter(tmpFile));
                    int i2 = 0;
                    while (true) {
                        if (i2 >= args.length) break;
                        out.println(args[i2]);
                        ++i2;
                    }
                    out.flush();
                    String[] stringArray = new String[]{"-argfile", tmpFile.getAbsolutePath()};
                    Object var12_12 = null;
                    if (out == null) return stringArray;
                    try {
                        out.close();
                        return stringArray;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return stringArray;
                }
                catch (IOException e) {
                    throw new BuildException("Error creating temporary file", (Throwable)e, location);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (out == null) throw throwable;
                try {}
                catch (Throwable t) {
                    throw throwable;
                }
                out.close();
                throw throwable;
            }
        }
    }
}

