/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Collection;
import java.util.Collections;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.PerClause;

public class Checker
extends ShadowMunger {
    private String msg;
    private boolean isError;

    public Checker(DeclareErrorOrWarning deow) {
        super(deow.getPointcut(), deow.getStart(), deow.getEnd(), deow.getSourceContext());
        this.msg = deow.getMessage();
        this.isError = deow.isError();
    }

    public ShadowMunger concretize(ResolvedTypeX fromType, World world, PerClause clause) {
        this.pointcut = this.pointcut.concretize(fromType, 0, this);
        return this;
    }

    public void specializeOn(Shadow shadow) {
        throw new RuntimeException("illegal state");
    }

    public void implementOn(Shadow shadow) {
        throw new RuntimeException("illegal state");
    }

    public boolean match(Shadow shadow, World world) {
        if (super.match(shadow, world)) {
            Message message = new Message(this.msg, shadow.toString(), this.isError ? IMessage.ERROR : IMessage.WARNING, shadow.getSourceLocation(), null, new ISourceLocation[]{this.getSourceLocation()}, true, 0, -1, -1);
            world.getMessageHandler().handleMessage(message);
            if (world.xrefHandler != null) {
                world.xrefHandler.addCrossReference(this.getSourceLocation(), shadow.getSourceLocation(), this.isError ? IRelationship.Kind.DECLARE_ERROR : IRelationship.Kind.DECLARE_WARNING, false);
            }
            if (world.getModel() != null) {
                AsmRelationshipProvider.getDefault().checkerMunger(world.getModel(), shadow, this);
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return 0;
    }

    public Collection getThrownExceptions() {
        return Collections.EMPTY_LIST;
    }

    public boolean isError() {
        return this.isError;
    }
}

