/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Iterators {
    public static final Iterator EMPTY = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private Iterators() {
    }

    public static Filter dupFilter() {
        return new Filter(){
            final Set seen = new HashSet();

            public Iterator filter(Iterator in) {
                return new Iterator(this, in){
                    boolean fresh;
                    Object peek;
                    private final /* synthetic */ Iterator val$in;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$in = val$in;
                        this.fresh = false;
                    }

                    public boolean hasNext() {
                        if (this.fresh) {
                            return true;
                        }
                        while (this.val$in.hasNext()) {
                            this.peek = this.val$in.next();
                            if (!this.this$0.seen.contains(this.peek)) {
                                this.fresh = true;
                                return true;
                            }
                            this.peek = null;
                        }
                        return false;
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object ret = this.peek;
                        this.peek = null;
                        this.fresh = false;
                        return ret;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterator array(final Object[] o) {
        return new Iterator(){
            int i = 0;
            int len = o.length;

            public boolean hasNext() {
                return this.i < this.len;
            }

            public Object next() {
                if (this.i < this.len) {
                    return o[this.i++];
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator mapOver(final Iterator a, final Getter g) {
        return new Iterator(){
            Iterator delegate = new Iterator(this){
                private final /* synthetic */ 4 this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean hasNext() {
                    if (!4.access$000(this.this$0).hasNext()) {
                        return false;
                    }
                    E o = 4.access$000(this.this$0).next();
                    this.this$0.delegate = Iterators.append1(4.access$100(this.this$0).get(o), this);
                    return this.this$0.delegate.hasNext();
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new UnsupportedOperationException();
                    }
                    return this.this$0.delegate.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Object next() {
                return this.delegate.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            static /* synthetic */ Iterator access$000(4 x0) {
                return x0.a;
            }

            static /* synthetic */ Getter access$100(4 x0) {
                return x0.g;
            }
        };
    }

    public static Iterator recur(final Object a, final Getter g) {
        return new Iterator(){
            Iterator delegate;
            {
                this.delegate = Iterators.one(a);
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public Object next() {
                Object next = this.delegate.next();
                this.delegate = Iterators.append(g.get(next), this.delegate);
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator append(Iterator a, Iterator b) {
        if (!b.hasNext()) {
            return a;
        }
        return Iterators.append1(a, b);
    }

    public static Iterator append1(final Iterator a, final Iterator b) {
        if (!a.hasNext()) {
            return b;
        }
        return new Iterator(){

            public boolean hasNext() {
                return a.hasNext() || b.hasNext();
            }

            public Object next() {
                if (a.hasNext()) {
                    return a.next();
                }
                if (b.hasNext()) {
                    return b.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator snoc(final Iterator first, final Object last) {
        return new Iterator(){
            Object last1;
            {
                this.last1 = last;
            }

            public boolean hasNext() {
                return first.hasNext() || this.last1 != null;
            }

            public Object next() {
                if (first.hasNext()) {
                    return first.next();
                }
                if (this.last1 == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.last1;
                this.last1 = null;
                return ret;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator one(final Object it) {
        return new Iterator(){
            boolean avail = true;

            public boolean hasNext() {
                return this.avail;
            }

            public Object next() {
                if (!this.avail) {
                    throw new NoSuchElementException();
                }
                this.avail = false;
                return it;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface Filter {
        public Iterator filter(Iterator var1);
    }

    public static interface Getter {
        public Iterator get(Object var1);
    }
}

