/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.aspectj.bridge.IMessage;
import org.aspectj.lang.JoinPoint;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class IfPointcut
extends Pointcut {
    public ResolvedMember testMethod;
    public int extraParameterFlags;
    public Pointcut residueSource;
    int baseArgsCount;
    private boolean findingResidue = false;
    private IfPointcut partiallyConcretized = null;

    public IfPointcut(ResolvedMember testMethod, int extraParameterFlags) {
        this.testMethod = testMethod;
        this.extraParameterFlags = extraParameterFlags;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.MAYBE;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(9);
        this.testMethod.write(s);
        s.writeByte(this.extraParameterFlags);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        IfPointcut ret = new IfPointcut(ResolvedMember.readResolvedMember(s, context), s.readByte());
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
    }

    public void resolveBindingsFromRTTI() {
    }

    public boolean equals(Object other) {
        if (!(other instanceof IfPointcut)) {
            return false;
        }
        IfPointcut o = (IfPointcut)other;
        return o.testMethod.equals(this.testMethod);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.testMethod.hashCode();
        return result;
    }

    public String toString() {
        return "if(" + this.testMethod + ")";
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        if (this.findingResidue) {
            return Literal.TRUE;
        }
        this.findingResidue = true;
        try {
            ExposedState myState = new ExposedState(this.baseArgsCount);
            this.residueSource.findResidue(shadow, myState);
            Test ret = Literal.TRUE;
            ArrayList<Var> args = new ArrayList<Var>();
            int i = 0;
            while (i < this.baseArgsCount) {
                Var v = myState.get(i);
                args.add(v);
                ret = Test.makeAnd(ret, Test.makeInstanceof(v, this.testMethod.getParameterTypes()[i].resolve(shadow.getIWorld())));
                ++i;
            }
            if ((this.extraParameterFlags & 2) != 0) {
                args.add(shadow.getThisJoinPointVar());
            }
            if ((this.extraParameterFlags & 4) != 0) {
                args.add(shadow.getThisJoinPointStaticPartVar());
            }
            if ((this.extraParameterFlags & 8) != 0) {
                args.add(shadow.getThisEnclosingJoinPointStaticPartVar());
            }
            Test test = ret = Test.makeAnd(ret, Test.makeCall(this.testMethod, args.toArray(new Expr[args.size()])));
            Object var9_8 = null;
            this.findingResidue = false;
            return test;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.findingResidue = false;
            throw throwable;
        }
    }

    public Pointcut concretize(ResolvedTypeX inAspect, IntMap bindings) {
        return this.concretize1(inAspect, bindings);
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        IfPointcut ret;
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("ifInDeclare"), bindings.getEnclosingAdvice().getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        if (this.partiallyConcretized != null) {
            return this.partiallyConcretized;
        }
        this.partiallyConcretized = ret = new IfPointcut(this.testMethod, this.extraParameterFlags);
        if (bindings.directlyInAdvice() && bindings.getEnclosingAdvice() == null) {
            inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("ifInPerClause"), this.getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        if (bindings.directlyInAdvice()) {
            ShadowMunger advice = bindings.getEnclosingAdvice();
            ret.baseArgsCount = advice instanceof Advice ? ((Advice)advice).getBaseParameterCount() : 0;
            ret.residueSource = advice.getPointcut().concretize(inAspect, ret.baseArgsCount, advice);
        } else {
            ResolvedPointcutDefinition def = bindings.peekEnclosingDefinitition();
            if (def == CflowPointcut.CFLOW_MARKER) {
                inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("ifLexicallyInCflow"), this.getSourceLocation(), null);
                return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
            }
            ret.baseArgsCount = def.getParameterTypes().length;
            IntMap newBindings = IntMap.idMap(ret.baseArgsCount);
            newBindings.copyContext(bindings);
            ret.residueSource = def.getPointcut().concretize(inAspect, newBindings);
        }
        return ret;
    }

    public static IfPointcut makeIfFalsePointcut(Pointcut.State state) {
        IfFalsePointcut ret = new IfFalsePointcut();
        ret.state = state;
        return ret;
    }

    public static IfPointcut makeIfTruePointcut(Pointcut.State state) {
        IfTruePointcut ret = new IfTruePointcut();
        ret.state = state;
        return ret;
    }

    private static class IfTruePointcut
    extends IfPointcut {
        public IfTruePointcut() {
            super(null, 0);
        }

        public Test findResidue(Shadow shadow, ExposedState state) {
            return Literal.TRUE;
        }

        public FuzzyBoolean fastMatch(FastMatchInfo type) {
            return FuzzyBoolean.YES;
        }

        public FuzzyBoolean match(Shadow shadow) {
            return FuzzyBoolean.YES;
        }

        public FuzzyBoolean match(JoinPoint.StaticPart jpsp) {
            return FuzzyBoolean.YES;
        }

        public void resolveBindings(IScope scope, Bindings bindings) {
        }

        public void resolveBindingsFromRTTI() {
        }

        public void postRead(ResolvedTypeX enclosingType) {
        }

        public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
            if (this.isDeclare(bindings.getEnclosingAdvice())) {
                inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("ifInDeclare"), bindings.getEnclosingAdvice().getSourceLocation(), null);
                return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
            }
            return IfPointcut.makeIfTruePointcut(this.state);
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeByte(14);
        }

        public int hashCode() {
            int result = 37;
            return result;
        }

        public String toString() {
            return "if(true)";
        }
    }

    private static class IfFalsePointcut
    extends IfPointcut {
        public IfFalsePointcut() {
            super(null, 0);
        }

        public Test findResidue(Shadow shadow, ExposedState state) {
            return Literal.FALSE;
        }

        public FuzzyBoolean fastMatch(FastMatchInfo type) {
            return FuzzyBoolean.NO;
        }

        public FuzzyBoolean match(Shadow shadow) {
            return FuzzyBoolean.NO;
        }

        public FuzzyBoolean match(JoinPoint.StaticPart jpsp) {
            return FuzzyBoolean.NO;
        }

        public void resolveBindings(IScope scope, Bindings bindings) {
        }

        public void resolveBindingsFromRTTI() {
        }

        public void postRead(ResolvedTypeX enclosingType) {
        }

        public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
            if (this.isDeclare(bindings.getEnclosingAdvice())) {
                inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("ifInDeclare"), bindings.getEnclosingAdvice().getSourceLocation(), null);
                return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
            }
            return IfPointcut.makeIfFalsePointcut(this.state);
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeByte(15);
        }

        public int hashCode() {
            int result = 17;
            return result;
        }

        public String toString() {
            return "if(false)";
        }
    }
}

