/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.IOException;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.patterns.PerCflow;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerObject;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class PerClause
extends Pointcut {
    protected ResolvedTypeX inAspect;
    public static final Kind SINGLETON = new Kind("issingleton", 1);
    public static final Kind PERCFLOW = new Kind("percflow", 2);
    public static final Kind PEROBJECT = new Kind("perobject", 3);
    public static final Kind FROMSUPER = new Kind("fromsuper", 4);

    public static PerClause readPerClause(DataInputStream s, ISourceContext context) throws IOException {
        Kind kind = Kind.read(s);
        if (kind == SINGLETON) {
            return PerSingleton.readPerClause(s, context);
        }
        if (kind == PERCFLOW) {
            return PerCflow.readPerClause(s, context);
        }
        if (kind == PEROBJECT) {
            return PerObject.readPerClause(s, context);
        }
        if (kind == FROMSUPER) {
            return PerFromSuper.readPerClause(s, context);
        }
        throw new BCException("unknown kind: " + kind);
    }

    public final Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        throw new RuntimeException("unimplemented: wrong concretize");
    }

    public abstract PerClause concretize(ResolvedTypeX var1);

    public abstract Kind getKind();

    public void resolveBindingsFromRTTI() {
        throw new UnsupportedOperationException("Can't resolve per-clauses at runtime");
    }

    public static class Kind
    extends TypeSafeEnum {
        public Kind(String name, int key) {
            super(name, key);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return SINGLETON;
                }
                case 2: {
                    return PERCFLOW;
                }
                case 3: {
                    return PEROBJECT;
                }
                case 4: {
                    return FROMSUPER;
                }
            }
            throw new BCException("weird kind " + key);
        }
    }
}

